/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeRecipeProvider
extends VanillaRecipeProvider {
    private final InterceptingRecipeOutput output;

    private NeoForgeRecipeProvider(HolderLookup.Provider provider, InterceptingRecipeOutput output) {
        super(provider, (RecipeOutput)output);
        this.output = output;
    }

    private void exclude(ItemLike item) {
        this.output.excludes.add(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)item.asItem())));
    }

    private void exclude(String name) {
        this.output.excludes.add(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)name)));
    }

    private void replace(ItemLike item, TagKey<Item> tag) {
        this.output.replacements.put(item.asItem(), tag);
    }

    protected void buildRecipes() {
        this.replace((ItemLike)Items.STICK, Tags.Items.RODS_WOODEN);
        this.replace((ItemLike)Items.GOLD_INGOT, Tags.Items.INGOTS_GOLD);
        this.replace((ItemLike)Items.GOLD_NUGGET, Tags.Items.NUGGETS_GOLD);
        this.replace((ItemLike)Items.IRON_INGOT, Tags.Items.INGOTS_IRON);
        this.replace((ItemLike)Items.IRON_NUGGET, Tags.Items.NUGGETS_IRON);
        this.replace((ItemLike)Items.NETHERITE_INGOT, Tags.Items.INGOTS_NETHERITE);
        this.replace((ItemLike)Items.COPPER_INGOT, Tags.Items.INGOTS_COPPER);
        this.replace((ItemLike)Items.AMETHYST_SHARD, Tags.Items.GEMS_AMETHYST);
        this.replace((ItemLike)Items.DIAMOND, Tags.Items.GEMS_DIAMOND);
        this.replace((ItemLike)Items.EMERALD, Tags.Items.GEMS_EMERALD);
        this.replace((ItemLike)Items.WHITE_DYE, Tags.Items.DYES_WHITE);
        this.replace((ItemLike)Items.ORANGE_DYE, Tags.Items.DYES_ORANGE);
        this.replace((ItemLike)Items.MAGENTA_DYE, Tags.Items.DYES_MAGENTA);
        this.replace((ItemLike)Items.LIGHT_BLUE_DYE, Tags.Items.DYES_LIGHT_BLUE);
        this.replace((ItemLike)Items.YELLOW_DYE, Tags.Items.DYES_YELLOW);
        this.replace((ItemLike)Items.LIME_DYE, Tags.Items.DYES_LIME);
        this.replace((ItemLike)Items.PINK_DYE, Tags.Items.DYES_PINK);
        this.replace((ItemLike)Items.GRAY_DYE, Tags.Items.DYES_GRAY);
        this.replace((ItemLike)Items.LIGHT_GRAY_DYE, Tags.Items.DYES_LIGHT_GRAY);
        this.replace((ItemLike)Items.CYAN_DYE, Tags.Items.DYES_CYAN);
        this.replace((ItemLike)Items.PURPLE_DYE, Tags.Items.DYES_PURPLE);
        this.replace((ItemLike)Items.BLUE_DYE, Tags.Items.DYES_BLUE);
        this.replace((ItemLike)Items.BROWN_DYE, Tags.Items.DYES_BROWN);
        this.replace((ItemLike)Items.GREEN_DYE, Tags.Items.DYES_GREEN);
        this.replace((ItemLike)Items.RED_DYE, Tags.Items.DYES_RED);
        this.replace((ItemLike)Items.BLACK_DYE, Tags.Items.DYES_BLACK);
        this.replace((ItemLike)Blocks.COBBLESTONE, Tags.Items.COBBLESTONES_NORMAL);
        this.replace((ItemLike)Blocks.COBBLED_DEEPSLATE, Tags.Items.COBBLESTONES_DEEPSLATE);
        this.replace((ItemLike)Items.EGG, Tags.Items.EGGS);
        this.replace((ItemLike)Items.STRING, Tags.Items.STRINGS);
        this.exclude(NeoForgeRecipeProvider.getConversionRecipeName((ItemLike)Blocks.WHITE_WOOL, (ItemLike)Items.STRING));
        this.exclude((ItemLike)Blocks.GOLD_BLOCK);
        this.exclude((ItemLike)Items.GOLD_NUGGET);
        this.exclude((ItemLike)Blocks.IRON_BLOCK);
        this.exclude((ItemLike)Items.IRON_NUGGET);
        this.exclude((ItemLike)Blocks.DIAMOND_BLOCK);
        this.exclude((ItemLike)Blocks.EMERALD_BLOCK);
        this.exclude((ItemLike)Blocks.NETHERITE_BLOCK);
        this.exclude((ItemLike)Blocks.COPPER_BLOCK);
        this.exclude((ItemLike)Blocks.AMETHYST_BLOCK);
        this.exclude((ItemLike)Blocks.COBBLESTONE_STAIRS);
        this.exclude((ItemLike)Blocks.COBBLESTONE_SLAB);
        this.exclude((ItemLike)Blocks.COBBLESTONE_WALL);
        this.exclude((ItemLike)Blocks.COBBLED_DEEPSLATE_STAIRS);
        this.exclude((ItemLike)Blocks.COBBLED_DEEPSLATE_SLAB);
        this.exclude((ItemLike)Blocks.COBBLED_DEEPSLATE_WALL);
        this.output.specialReplacements.put(Items.CHEST, DifferenceIngredient.of(this.tag(Tags.Items.CHESTS_WOODEN), this.tag(Tags.Items.CHESTS_TRAPPED)));
        super.buildRecipes();
    }

    private static class InterceptingRecipeOutput
    implements RecipeOutput {
        private final HolderGetter<Item> items;
        private final RecipeOutput output;
        private final Map<Item, TagKey<Item>> replacements = new HashMap<Item, TagKey<Item>>();
        private final Map<Item, Ingredient> specialReplacements = new HashMap<Item, Ingredient>();
        private final Set<ResourceKey<Recipe<?>>> excludes = new HashSet();

        private InterceptingRecipeOutput(HolderGetter<Item> items, RecipeOutput output) {
            this.items = items;
            this.output = output;
        }

        public Advancement.Builder advancement() {
            return this.output.advancement();
        }

        public void includeRootAdvancement() {
        }

        public void accept(ResourceKey<Recipe<?>> id, Recipe<?> recipe, @Nullable AdvancementHolder advancement, ICondition ... conditions) {
            Recipe<?> modified = this.enhance(id, recipe);
            if (modified != null) {
                this.output.accept(id, modified, null, conditions);
            }
        }

        @Nullable
        private Recipe<?> enhance(ResourceKey<Recipe<?>> id, Recipe<?> vanilla) {
            if (vanilla instanceof ShapelessRecipe) {
                ShapelessRecipe shapeless = (ShapelessRecipe)vanilla;
                return this.enhance(id, shapeless);
            }
            if (vanilla instanceof ShapedRecipe) {
                ShapedRecipe shaped = (ShapedRecipe)vanilla;
                return this.enhance(id, shaped);
            }
            return null;
        }

        @Nullable
        private ShapelessRecipe enhance(ResourceKey<Recipe<?>> id, ShapelessRecipe vanilla) {
            List ingredients = (List)ObfuscationReflectionHelper.getPrivateValue(ShapelessRecipe.class, (Object)vanilla, (String)"ingredients");
            boolean modified = false;
            for (int x = 0; x < ingredients.size(); ++x) {
                Ingredient ing = this.enhance(id, (Ingredient)ingredients.get(x));
                if (ing == null) continue;
                ingredients.set(x, ing);
                modified = true;
            }
            return modified ? vanilla : null;
        }

        @Nullable
        private ShapedRecipe enhance(ResourceKey<Recipe<?>> id, ShapedRecipe vanilla) {
            ShapedRecipePattern pattern = (ShapedRecipePattern)ObfuscationReflectionHelper.getPrivateValue(ShapedRecipe.class, (Object)vanilla, (String)"pattern");
            if (pattern == null) {
                throw new IllegalStateException(ShapedRecipe.class.getName() + " has no field pattern");
            }
            ShapedRecipePattern.Data data = (ShapedRecipePattern.Data)((Optional)ObfuscationReflectionHelper.getPrivateValue(ShapedRecipePattern.class, (Object)pattern, (String)"data")).orElseThrow(() -> new IllegalArgumentException("recipe " + String.valueOf(id) + " does not have pattern data"));
            Map ingredients = data.key();
            boolean modified = false;
            for (Character x : ingredients.keySet()) {
                Ingredient ing = this.enhance(id, (Ingredient)ingredients.get(x));
                if (ing == null) continue;
                ingredients.put(x, ing);
                modified = true;
            }
            return modified ? vanilla : null;
        }

        @Nullable
        private Ingredient enhance(ResourceKey<Recipe<?>> name, Ingredient vanilla) {
            if (this.excludes.contains(name)) {
                return null;
            }
            return (Ingredient)vanilla.getValues().unwrap().map(tagKey -> null, items -> {
                if (items.size() == 1) {
                    Ingredient specialReplacement = this.specialReplacements.get(((Holder)items.getFirst()).value());
                    if (specialReplacement != null) {
                        return specialReplacement;
                    }
                    TagKey<Item> replacement = this.replacements.get(((Holder)items.getFirst()).value());
                    if (replacement != null) {
                        return Ingredient.of((HolderSet)this.items.getOrThrow(replacement));
                    }
                }
                for (Holder holder : items) {
                    if (!this.replacements.containsKey(holder.value())) continue;
                    throw new IllegalArgumentException("Cannot replace '%s' which is part of a multi-item ingredient.".formatted(holder.value()));
                }
                return null;
            });
        }
    }

    public static final class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput output) {
            return new NeoForgeRecipeProvider(lookupProvider, new InterceptingRecipeOutput((HolderGetter<Item>)lookupProvider.lookupOrThrow(Registries.ITEM), output));
        }

        public String getName() {
            return "NeoForge recipes";
        }
    }
}

