/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.generators.template;

import com.google.common.base.Preconditions;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RotationBuilder {
    @Nullable
    private Vector3f origin;
    @Nullable
    private Direction.Axis axis;
    private float angle;
    private boolean rescale;

    public RotationBuilder origin(float x, float y, float z) {
        this.origin = new Vector3f(x, y, z);
        return this;
    }

    public RotationBuilder axis(Direction.Axis axis) {
        Preconditions.checkNotNull((Object)axis, (Object)"Axis must not be null");
        this.axis = axis;
        return this;
    }

    public RotationBuilder angle(float angle) {
        Preconditions.checkArgument((angle == 0.0f || Mth.abs((float)angle) == 22.5f || Mth.abs((float)angle) == 45.0f ? 1 : 0) != 0, (String)"Invalid rotation %f found, only -45/-22.5/0/22.5/45 allowed", (Object)Float.valueOf(angle));
        this.angle = angle;
        return this;
    }

    public RotationBuilder rescale(boolean rescale) {
        this.rescale = rescale;
        return this;
    }

    BlockElementRotation build() {
        Preconditions.checkNotNull((Object)this.origin, (Object)"No origin specified");
        Preconditions.checkNotNull((Object)this.axis, (Object)"No axis specified");
        return new BlockElementRotation(this.origin, this.axis, this.angle, this.rescale);
    }

    RotationBuilder copy() {
        RotationBuilder builder = new RotationBuilder();
        builder.origin = this.origin != null ? new Vector3f((Vector3fc)this.origin) : null;
        builder.axis = this.axis;
        builder.angle = this.angle;
        builder.rescale = this.rescale;
        return builder;
    }
}

