/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.IRenderableSection;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public abstract class RenderLevelStageEvent
extends Event {
    private final Level level;
    private final LevelRenderer levelRenderer;
    private final PoseStack poseStack;
    private final Matrix4f modelViewMatrix;
    private final int renderTick;
    private final DeltaTracker partialTick;
    private final CameraRenderState camera;
    private final Frustum frustum;
    private final Iterable<? extends IRenderableSection> renderableSections;

    public RenderLevelStageEvent(Level level, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, int renderTick, DeltaTracker partialTick, CameraRenderState camera, Frustum frustum, Iterable<? extends IRenderableSection> renderableSections) {
        this.level = level;
        this.levelRenderer = levelRenderer;
        this.poseStack = poseStack != null ? poseStack : new PoseStack();
        this.modelViewMatrix = modelViewMatrix;
        this.renderTick = renderTick;
        this.partialTick = partialTick;
        this.camera = camera;
        this.frustum = frustum;
        this.renderableSections = renderableSections;
    }

    public Level getLevel() {
        return this.level;
    }

    public LevelRenderer getLevelRenderer() {
        return this.levelRenderer;
    }

    public PoseStack getPoseStack() {
        return this.poseStack;
    }

    public Matrix4f getModelViewMatrix() {
        return this.modelViewMatrix;
    }

    public int getRenderTick() {
        return this.renderTick;
    }

    public DeltaTracker getPartialTick() {
        return this.partialTick;
    }

    public CameraRenderState getCamera() {
        return this.camera;
    }

    public Frustum getFrustum() {
        return this.frustum;
    }

    public Iterable<? extends IRenderableSection> getRenderableSections() {
        return this.renderableSections;
    }

    public static class AfterLevel
    extends RenderLevelStageEvent {
        public AfterLevel(Level level, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, int renderTick, DeltaTracker partialTick, CameraRenderState camera, Frustum frustum, Iterable<? extends IRenderableSection> renderableSections) {
            super(level, levelRenderer, poseStack, modelViewMatrix, renderTick, partialTick, camera, frustum, renderableSections);
        }
    }

    public static class AfterWeather
    extends RenderLevelStageEvent {
        public AfterWeather(Level level, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, int renderTick, DeltaTracker partialTick, CameraRenderState camera, Frustum frustum, Iterable<? extends IRenderableSection> renderableSections) {
            super(level, levelRenderer, poseStack, modelViewMatrix, renderTick, partialTick, camera, frustum, renderableSections);
        }
    }

    public static class AfterParticles
    extends RenderLevelStageEvent {
        public AfterParticles(Level level, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, int renderTick, DeltaTracker partialTick, CameraRenderState camera, Frustum frustum, Iterable<? extends IRenderableSection> renderableSections) {
            super(level, levelRenderer, poseStack, modelViewMatrix, renderTick, partialTick, camera, frustum, renderableSections);
        }
    }

    public static class AfterTripwireBlocks
    extends RenderLevelStageEvent {
        public AfterTripwireBlocks(Level level, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, int renderTick, DeltaTracker partialTick, CameraRenderState camera, Frustum frustum, Iterable<? extends IRenderableSection> renderableSections) {
            super(level, levelRenderer, poseStack, modelViewMatrix, renderTick, partialTick, camera, frustum, renderableSections);
        }
    }

    public static class AfterTranslucentBlocks
    extends RenderLevelStageEvent {
        public AfterTranslucentBlocks(Level level, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, int renderTick, DeltaTracker partialTick, CameraRenderState camera, Frustum frustum, Iterable<? extends IRenderableSection> renderableSections) {
            super(level, levelRenderer, poseStack, modelViewMatrix, renderTick, partialTick, camera, frustum, renderableSections);
        }
    }

    public static class AfterBlockEntities
    extends RenderLevelStageEvent {
        public AfterBlockEntities(Level level, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, int renderTick, DeltaTracker partialTick, CameraRenderState camera, Frustum frustum, Iterable<? extends IRenderableSection> renderableSections) {
            super(level, levelRenderer, poseStack, modelViewMatrix, renderTick, partialTick, camera, frustum, renderableSections);
        }
    }

    public static class AfterEntities
    extends RenderLevelStageEvent {
        public AfterEntities(Level level, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, int renderTick, DeltaTracker partialTick, CameraRenderState camera, Frustum frustum, Iterable<? extends IRenderableSection> renderableSections) {
            super(level, levelRenderer, poseStack, modelViewMatrix, renderTick, partialTick, camera, frustum, renderableSections);
        }
    }

    public static class AfterOpaqueBlocks
    extends RenderLevelStageEvent {
        public AfterOpaqueBlocks(Level level, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, int renderTick, DeltaTracker partialTick, CameraRenderState camera, Frustum frustum, Iterable<? extends IRenderableSection> renderableSections) {
            super(level, levelRenderer, poseStack, modelViewMatrix, renderTick, partialTick, camera, frustum, renderableSections);
        }
    }

    public static class AfterSky
    extends RenderLevelStageEvent {
        public AfterSky(Level level, LevelRenderer levelRenderer, @Nullable PoseStack poseStack, Matrix4f modelViewMatrix, int renderTick, DeltaTracker partialTick, CameraRenderState camera, Frustum frustum, Iterable<? extends IRenderableSection> renderableSections) {
            super(level, levelRenderer, poseStack, modelViewMatrix, renderTick, partialTick, camera, frustum, renderableSections);
        }
    }
}

