/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event;

import com.google.common.graph.ElementOrder;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.Event;
import org.jetbrains.annotations.ApiStatus;

public abstract class SortedReloadListenerEvent
extends Event {
    private final Map<ResourceLocation, PreparableReloadListener> registry = new LinkedHashMap<ResourceLocation, PreparableReloadListener>();
    private final Map<PreparableReloadListener, ResourceLocation> keys = new IdentityHashMap<PreparableReloadListener, ResourceLocation>();
    private final MutableGraph<PreparableReloadListener> graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
    private final PreparableReloadListener lastVanilla;

    @ApiStatus.Internal
    protected SortedReloadListenerEvent(List<PreparableReloadListener> vanillaListeners, NameLookup lookup) {
        for (PreparableReloadListener listener : vanillaListeners) {
            ResourceLocation key = lookup.apply(listener);
            this.addListener(key, listener);
        }
        for (int i = 1; i < vanillaListeners.size(); ++i) {
            PreparableReloadListener prev = vanillaListeners.get(i - 1);
            PreparableReloadListener listener = vanillaListeners.get(i);
            this.graph.putEdge((Object)prev, (Object)listener);
        }
        this.lastVanilla = vanillaListeners.getLast();
    }

    public void addListener(ResourceLocation key, PreparableReloadListener listener) {
        if (this.registry.containsKey(key) || this.registry.containsValue(listener)) {
            throw new IllegalArgumentException("Attempted to register two reload listeners for the same key: " + String.valueOf(key));
        }
        this.registry.put(key, listener);
        this.keys.put(listener, key);
        this.graph.addNode((Object)listener);
    }

    public void addDependency(ResourceLocation first, ResourceLocation second) {
        this.graph.putEdge((Object)this.getOrThrow(first), (Object)this.getOrThrow(second));
    }

    public Graph<PreparableReloadListener> getGraph() {
        return this.graph;
    }

    public Map<ResourceLocation, PreparableReloadListener> getRegistry() {
        return Collections.unmodifiableMap(this.registry);
    }

    public NameLookup getNameLookup() {
        return this::getOrThrow;
    }

    @ApiStatus.Internal
    public PreparableReloadListener getLastVanillaListener() {
        return this.lastVanilla;
    }

    private PreparableReloadListener getOrThrow(ResourceLocation key) {
        PreparableReloadListener listener = this.registry.get(key);
        if (listener == null) {
            throw new IllegalArgumentException("Unknown reload listener: " + String.valueOf(key));
        }
        return listener;
    }

    private ResourceLocation getOrThrow(PreparableReloadListener listener) {
        ResourceLocation key = this.keys.get(listener);
        if (key == null) {
            throw new IllegalArgumentException("Unknown reload listener: " + String.valueOf(listener));
        }
        return key;
    }

    @FunctionalInterface
    public static interface NameLookup
    extends Function<PreparableReloadListener, ResourceLocation> {
        @Override
        public ResourceLocation apply(PreparableReloadListener var1);
    }
}

