/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.loading;

import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.neoforged.fml.earlydisplay.DisplayWindow;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforge.client.blaze3d.validation.ValidationGpuDevice;

public class NeoForgeLoadingOverlay
extends LoadingOverlay {
    public static final ResourceLocation LOADING_OVERLAY_TEXTURE_ID = ResourceLocation.parse((String)"neoforge:loading_overlay");
    private final Minecraft minecraft;
    private final ReloadInstance reload;
    private final Consumer<Optional<Throwable>> onFinish;
    private final DisplayWindow displayWindow;
    private final ProgressMeter progressMeter;
    private float currentProgress;
    private long fadeOutStart = -1L;

    public NeoForgeLoadingOverlay(Minecraft mc, ReloadInstance reloader, Consumer<Optional<Throwable>> errorConsumer, DisplayWindow displayWindow) {
        super(mc, reloader, errorConsumer, false);
        this.minecraft = mc;
        this.reload = reloader;
        this.onFinish = errorConsumer;
        this.displayWindow = displayWindow;
        this.progressMeter = StartupNotificationManager.prependProgressBar((String)"Minecraft Progress", (int)1000);
        GpuDevice gpuDevice = RenderSystem.getDevice();
        if (gpuDevice instanceof ValidationGpuDevice) {
            ValidationGpuDevice validationGpuDevice = (ValidationGpuDevice)gpuDevice;
            gpuDevice = validationGpuDevice.getRealDevice();
        }
        GpuTexture framebuffer = ((GlDevice)gpuDevice).createExternalTexture("loading overlay framebuffer", 4, displayWindow.getFramebufferTextureId());
        Minecraft.getInstance().getTextureManager().register(LOADING_OVERLAY_TEXTURE_ID, (AbstractTexture)new ExternalTexture(framebuffer));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        long millis = Util.getMillis();
        float fadeouttimer = this.fadeOutStart > -1L ? (float)(millis - this.fadeOutStart) / 1000.0f : -1.0f;
        this.currentProgress = Mth.clamp((float)(this.currentProgress * 0.95f + this.reload.getActualProgress() * 0.05f), (float)0.0f, (float)1.0f);
        this.progressMeter.setAbsolute(Mth.ceil((float)(this.currentProgress * 1000.0f)));
        this.displayWindow.renderToFramebuffer();
        int fbWidth = this.minecraft.getWindow().getWidth();
        int fbHeight = this.minecraft.getWindow().getHeight();
        float fade = 1.0f - Mth.clamp((float)(fadeouttimer - 1.0f), (float)0.0f, (float)1.0f);
        if (fadeouttimer >= 1.0f && this.minecraft.screen != null) {
            this.minecraft.screen.render(graphics, 0, 0, partialTick);
        }
        int width = this.minecraft.getWindow().getGuiScaledWidth();
        int height = this.minecraft.getWindow().getGuiScaledHeight();
        int color = ARGB.colorFromFloat((float)fade, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(RenderPipelines.GUI_TEXTURED, LOADING_OVERLAY_TEXTURE_ID, 0, 0, 0.0f, 0.0f, fbWidth, fbHeight, fbWidth, fbHeight, width, height, color);
        if (fadeouttimer >= 2.0f) {
            this.progressMeter.complete();
            Minecraft.getInstance().schedule(() -> {
                Minecraft.getInstance().getTextureManager().release(LOADING_OVERLAY_TEXTURE_ID);
                this.displayWindow.close();
            });
            this.minecraft.setOverlay(null);
        }
        if (this.fadeOutStart == -1L && this.reload.isDone()) {
            this.fadeOutStart = Util.getMillis();
            try {
                this.reload.checkExceptions();
                this.onFinish.accept(Optional.empty());
            }
            catch (Throwable throwable) {
                this.onFinish.accept(Optional.of(throwable));
            }
            if (this.minecraft.screen != null) {
                this.minecraft.screen.init(this.minecraft, graphics.guiWidth(), graphics.guiHeight());
            }
        }
    }

    static class ExternalTexture
    extends AbstractTexture {
        public ExternalTexture(GpuTexture texture) {
            this.texture = texture;
            this.setFilter(false, false);
            GpuDevice gpuDevice = RenderSystem.getDevice();
            if (gpuDevice instanceof ValidationGpuDevice) {
                ValidationGpuDevice validationGpuDevice = (ValidationGpuDevice)gpuDevice;
                gpuDevice = validationGpuDevice.getRealDevice();
            }
            this.textureView = gpuDevice.createTextureView(texture);
        }
    }
}

