/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.StringUtils;
import net.neoforged.neoforge.server.command.CommandUtils;
import net.neoforged.neoforge.server.command.EnumArgument;
import net.neoforged.neoforge.server.command.ModIdArgument;

public class ConfigCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"config").then(ShowFile.register()));
    }

    public static class ShowFile {
        static ArgumentBuilder<CommandSourceStack, ?> register() {
            return ((LiteralArgumentBuilder)Commands.literal((String)"showfile").requires(cs -> cs.hasPermission(0))).then(Commands.argument((String)"mod", (ArgumentType)ModIdArgument.modIdArgument()).then(Commands.argument((String)"type", EnumArgument.enumArgument(ServerModConfigType.class)).executes(ShowFile::showFile)));
        }

        private static int showFile(CommandContext<CommandSourceStack> context) {
            String modId = (String)context.getArgument("mod", String.class);
            ModConfig.Type type = ModConfig.Type.valueOf((String)((ServerModConfigType)((Object)context.getArgument("type", ServerModConfigType.class))).toString());
            List configFileNames = ModConfigs.getConfigFileNames((String)modId, (ModConfig.Type)type);
            for (String configFileName : configFileNames) {
                File f = new File(configFileName);
                MutableComponent fileComponent = Component.literal((String)f.getName()).withStyle(ChatFormatting.UNDERLINE);
                ServerPlayer caller = ((CommandSourceStack)context.getSource()).getPlayer();
                if (FMLLoader.getDist().isClient() && caller != null && caller.connection.getConnection().isMemoryConnection()) {
                    fileComponent.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenFile(f)));
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.config.getwithtype", modId, type.toString(), fileComponent), true);
            }
            if (configFileNames.isEmpty()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.makeTranslatableWithFallback("commands.config.noconfig", modId, type.toString()), true);
            }
            return 0;
        }
    }

    public static enum ServerModConfigType {
        COMMON,
        SERVER;


        public String extension() {
            return StringUtils.toLowerCase((String)this.name());
        }
    }
}

