/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.SoundDefinition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SoundDefinitionsProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PackOutput output;
    private final String modId;
    private final Map<String, SoundDefinition> sounds = new LinkedHashMap<String, SoundDefinition>();

    protected SoundDefinitionsProvider(PackOutput output, String modId) {
        this.output = output;
        this.modId = modId;
    }

    public abstract void registerSounds();

    public CompletableFuture<?> run(CachedOutput cache) {
        this.sounds.clear();
        this.registerSounds();
        this.validate();
        if (!this.sounds.isEmpty()) {
            return this.save(cache, this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve(this.modId).resolve("sounds.json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String getName() {
        return "Sound Definitions";
    }

    protected static SoundDefinition definition() {
        return SoundDefinition.definition();
    }

    protected static SoundDefinition.Sound sound(ResourceLocation name, SoundDefinition.SoundType type) {
        return SoundDefinition.Sound.sound(name, type);
    }

    protected static SoundDefinition.Sound sound(ResourceLocation name) {
        return SoundDefinitionsProvider.sound(name, SoundDefinition.SoundType.SOUND);
    }

    protected static SoundDefinition.Sound sound(String name, SoundDefinition.SoundType type) {
        return SoundDefinitionsProvider.sound(ResourceLocation.parse((String)name), type);
    }

    protected static SoundDefinition.Sound sound(String name) {
        return SoundDefinitionsProvider.sound(ResourceLocation.parse((String)name));
    }

    protected void add(Supplier<SoundEvent> soundEvent, SoundDefinition definition) {
        this.add(soundEvent.get(), definition);
    }

    protected void add(SoundEvent soundEvent, SoundDefinition definition) {
        this.add(soundEvent.location(), definition);
    }

    protected void add(ResourceLocation soundEvent, SoundDefinition definition) {
        this.addSounds(soundEvent.getPath(), definition);
    }

    protected void add(String soundEvent, SoundDefinition definition) {
        this.add(ResourceLocation.parse((String)soundEvent), definition);
    }

    private void addSounds(String soundEvent, SoundDefinition definition) {
        if (this.sounds.put(soundEvent, definition) != null) {
            throw new IllegalStateException("Sound event '" + this.modId + ":" + soundEvent + "' already exists");
        }
    }

    private void validate() {
        List<String> notValid = this.sounds.entrySet().stream().filter(it -> !this.validate((String)it.getKey(), (SoundDefinition)it.getValue())).map(Map.Entry::getKey).map(it -> this.modId + ":" + it).toList();
        if (!notValid.isEmpty()) {
            throw new IllegalStateException("Found invalid sound events: " + String.valueOf(notValid));
        }
    }

    private boolean validate(String name, SoundDefinition def) {
        return def.soundList().stream().filter(it -> it.type() == SoundDefinition.SoundType.EVENT).allMatch(it -> {
            boolean valid;
            boolean bl = valid = this.sounds.containsKey(name) || BuiltInRegistries.SOUND_EVENT.containsKey(it.name());
            if (!valid) {
                LOGGER.warn("Unable to find event '{}' referenced from '{}'", (Object)it.name(), (Object)name);
            }
            return valid;
        });
    }

    private CompletableFuture<?> save(CachedOutput cache, Path targetFile) {
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)this.mapToJson(this.sounds), (Path)targetFile);
    }

    private JsonObject mapToJson(Map<String, SoundDefinition> map) {
        JsonObject obj = new JsonObject();
        map.forEach((k, v) -> obj.add(k, (JsonElement)v.serialize()));
        return obj;
    }
}

