/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.resources;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.PeriodicNotificationManager;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.CloudRenderer;
import net.minecraft.client.renderer.GpuWarnlistManager;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderManager;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DryFoliageColorReloadListener;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.MapDecorationTextureManager;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.client.resources.SplashManager;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.neoforge.common.util.VanillaClassToKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class VanillaClientListeners {
    private static final Map<Class<?>, ResourceLocation> KNOWN_CLASSES = new LinkedHashMap();
    public static final ResourceLocation LANGUAGE = VanillaClientListeners.key(LanguageManager.class);
    public static final ResourceLocation TEXTURES = VanillaClientListeners.key(TextureManager.class);
    public static final ResourceLocation SHADERS = VanillaClientListeners.key(ShaderManager.class);
    public static final ResourceLocation SOUNDS = VanillaClientListeners.key(SoundManager.class);
    public static final ResourceLocation SPLASHES = VanillaClientListeners.key(SplashManager.class);
    public static final ResourceLocation FONTS = VanillaClientListeners.key(FontManager.class);
    public static final ResourceLocation GRASS_COLOR = VanillaClientListeners.key(GrassColorReloadListener.class);
    public static final ResourceLocation FOLIAGE_COLOR = VanillaClientListeners.key(FoliageColorReloadListener.class);
    public static final ResourceLocation DRY_FOLIAGE_COLOR = VanillaClientListeners.key(DryFoliageColorReloadListener.class);
    public static final ResourceLocation MODELS = VanillaClientListeners.key(ModelManager.class);
    public static final ResourceLocation EQUIPMENT_ASSETS = VanillaClientListeners.key(EquipmentAssetManager.class);
    public static final ResourceLocation MAP_DECORATIONS = VanillaClientListeners.key(MapDecorationTextureManager.class);
    public static final ResourceLocation BLOCK_RENDERER = VanillaClientListeners.key(BlockRenderDispatcher.class);
    public static final ResourceLocation ENTITY_RENDERER = VanillaClientListeners.key(EntityRenderDispatcher.class);
    public static final ResourceLocation BLOCK_ENTITY_RENDERER = VanillaClientListeners.key(BlockEntityRenderDispatcher.class);
    public static final ResourceLocation PARTICLE_ENGINE = VanillaClientListeners.key(ParticleEngine.class);
    public static final ResourceLocation PAINTING_TEXTURES = VanillaClientListeners.key(PaintingTextureManager.class);
    public static final ResourceLocation MOB_EFFECT_TEXTURES = VanillaClientListeners.key(MobEffectTextureManager.class);
    public static final ResourceLocation GUI_SPRITES = VanillaClientListeners.key(GuiSpriteManager.class);
    public static final ResourceLocation LEVEL_RENDERER = VanillaClientListeners.key(LevelRenderer.class);
    public static final ResourceLocation CLOUD_RENDERER = VanillaClientListeners.key(CloudRenderer.class);
    public static final ResourceLocation GPU_WARNLIST = VanillaClientListeners.key(GpuWarnlistManager.class);
    public static final ResourceLocation REGIONAL_COMPLIANCES = VanillaClientListeners.key(PeriodicNotificationManager.class);
    public static final ResourceLocation FIRST = LANGUAGE;
    public static final ResourceLocation LAST = REGIONAL_COMPLIANCES;

    private static ResourceLocation key(Class<? extends PreparableReloadListener> cls) {
        if (KNOWN_CLASSES.containsKey(cls)) {
            throw new UnsupportedOperationException("Attempted to create two keys for the same class");
        }
        ResourceLocation key = VanillaClassToKey.convert(cls);
        KNOWN_CLASSES.put(cls, key);
        return key;
    }

    @Nullable
    @ApiStatus.Internal
    public static ResourceLocation getNameForClass(Class<? extends PreparableReloadListener> cls) {
        return KNOWN_CLASSES.get(cls);
    }
}

