/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.gui;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Function4;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.config.NeoForgeClientConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.TranslatableEnum;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationScreen
extends OptionsSubScreen {
    private static final String LANG_PREFIX = "neoforge.configuration.uitext.";
    private static final String SECTION = "neoforge.configuration.uitext.section";
    private static final String SECTION_TEXT = "neoforge.configuration.uitext.sectiontext";
    public static final Component CRUMB_SEPARATOR = Component.translatable((String)"neoforge.configuration.uitext.breadcrumb.separator").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
    private static final String CRUMB = "neoforge.configuration.uitext.breadcrumb.order";
    private static final String LIST_ELEMENT = "neoforge.configuration.uitext.listelement";
    private static final String RANGE_TOOLTIP = "neoforge.configuration.uitext.rangetooltip";
    private static final ChatFormatting RANGE_TOOLTIP_STYLE = ChatFormatting.GRAY;
    private static final String FILENAME_TOOLTIP = "neoforge.configuration.uitext.filenametooltip";
    private static final ChatFormatting FILENAME_TOOLTIP_STYLE = ChatFormatting.GRAY;
    private static final MutableComponent EMPTY_LINE = Component.literal((String)"\n\n");
    public static final Component TOOLTIP_CANNOT_EDIT_THIS_WHILE_ONLINE = Component.translatable((String)"neoforge.configuration.uitext.notonline").withStyle(ChatFormatting.RED);
    public static final Component TOOLTIP_CANNOT_EDIT_THIS_WHILE_OPEN_TO_LAN = Component.translatable((String)"neoforge.configuration.uitext.notlan").withStyle(ChatFormatting.RED);
    public static final Component TOOLTIP_CANNOT_EDIT_NOT_LOADED = Component.translatable((String)"neoforge.configuration.uitext.notloaded").withStyle(ChatFormatting.RED);
    public static final Component NEW_LIST_ELEMENT = Component.translatable((String)"neoforge.configuration.uitext.newlistelement");
    public static final Component MOVE_LIST_ELEMENT_UP = Component.translatable((String)"neoforge.configuration.uitext.listelementup");
    public static final Component MOVE_LIST_ELEMENT_DOWN = Component.translatable((String)"neoforge.configuration.uitext.listelementdown");
    public static final Component REMOVE_LIST_ELEMENT = Component.translatable((String)"neoforge.configuration.uitext.listelementremove");
    public static final Component UNSUPPORTED_ELEMENT = Component.translatable((String)"neoforge.configuration.uitext.unsupportedelement").withStyle(ChatFormatting.RED);
    public static final Component LONG_STRING = Component.translatable((String)"neoforge.configuration.uitext.longstring").withStyle(ChatFormatting.RED);
    public static final Component GAME_RESTART_TITLE = Component.translatable((String)"neoforge.configuration.uitext.restart.game.title");
    public static final Component GAME_RESTART_MESSAGE = Component.translatable((String)"neoforge.configuration.uitext.restart.game.text");
    public static final Component GAME_RESTART_YES = Component.translatable((String)"menu.quit");
    public static final Component SERVER_RESTART_TITLE = Component.translatable((String)"neoforge.configuration.uitext.restart.server.title");
    public static final Component SERVER_RESTART_MESSAGE = Component.translatable((String)"neoforge.configuration.uitext.restart.server.text");
    public static final Component RETURN_TO_MENU = Component.translatable((String)"menu.returnToMenu");
    public static final Component SAVING_LEVEL = Component.translatable((String)"menu.savingLevel");
    public static final Component RESTART_NO = Component.translatable((String)"neoforge.configuration.uitext.restart.return");
    public static final Component RESTART_NO_TOOLTIP = Component.translatable((String)"neoforge.configuration.uitext.restart.return.tooltip").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
    public static final Component UNDO = Component.translatable((String)"neoforge.configuration.uitext.undo");
    public static final Component UNDO_TOOLTIP = Component.translatable((String)"neoforge.configuration.uitext.undo.tooltip");
    public static final Component RESET = Component.translatable((String)"neoforge.configuration.uitext.reset");
    public static final Component RESET_TOOLTIP = Component.translatable((String)"neoforge.configuration.uitext.reset.tooltip");
    public static final int BIG_BUTTON_WIDTH = 310;
    protected static final TranslationChecker translationChecker = new TranslationChecker();
    protected final ModContainer mod;
    private final Function4<ConfigurationScreen, ModConfig.Type, ModConfig, Component, Screen> sectionScreen;
    public ModConfigSpec.RestartType needsRestart = ModConfigSpec.RestartType.NONE;
    private boolean autoClose = false;

    public ConfigurationScreen(ModContainer mod, Screen parent) {
        this(mod, parent, (Function4<ConfigurationScreen, ModConfig.Type, ModConfig, Component, Screen>)((Function4)ConfigurationSectionScreen::new));
    }

    public ConfigurationScreen(ModContainer mod, Screen parent, ConfigurationSectionScreen.Filter filter) {
        this(mod, parent, (Function4<ConfigurationScreen, ModConfig.Type, ModConfig, Component, Screen>)((Function4)(a, b, c, d) -> new ConfigurationSectionScreen((Screen)a, (ModConfig.Type)b, (ModConfig)c, (Component)d, filter)));
    }

    public ConfigurationScreen(ModContainer mod, Screen parent, Function4<ConfigurationScreen, ModConfig.Type, ModConfig, Component, Screen> sectionScreen) {
        super(parent, Minecraft.getInstance().options, (Component)Component.translatable((String)translationChecker.check(mod.getModId() + ".configuration.title", "neoforge.configuration.uitext.title"), (Object[])new Object[]{mod.getModInfo().getDisplayName()}));
        this.mod = mod;
        this.sectionScreen = sectionScreen;
    }

    protected void addOptions() {
        Button btn = null;
        int count = 0;
        for (ModConfig.Type type : ModConfig.Type.values()) {
            boolean headerAdded = false;
            for (ModConfig modConfig : ModConfigs.getConfigSet((ModConfig.Type)type)) {
                if (!modConfig.getModId().equals(this.mod.getModId())) continue;
                if (!headerAdded) {
                    this.list.addSmall((AbstractWidget)new StringWidget(310, 20, (Component)Component.translatable((String)(LANG_PREFIX + type.name().toLowerCase(Locale.ENGLISH))).withStyle(ChatFormatting.UNDERLINE), this.font).alignLeft(), null);
                    headerAdded = true;
                }
                btn = Button.builder((Component)Component.translatable((String)SECTION, (Object[])new Object[]{this.translatableConfig(modConfig, "", "neoforge.configuration.uitext.type." + modConfig.getType().name().toLowerCase(Locale.ROOT))}), button -> this.minecraft.setScreen((Screen)this.sectionScreen.apply((Object)this, (Object)type, (Object)modConfig, (Object)this.translatableConfig(modConfig, ".title", "neoforge.configuration.uitext.title." + type.name().toLowerCase(Locale.ROOT))))).width(310).build();
                MutableComponent tooltip = Component.empty();
                if (!((ModConfigSpec)modConfig.getSpec()).isLoaded()) {
                    tooltip.append(TOOLTIP_CANNOT_EDIT_NOT_LOADED).append((Component)EMPTY_LINE);
                    btn.active = false;
                    count = 99;
                } else if (type == ModConfig.Type.SERVER && this.minecraft.getCurrentServer() != null && !this.minecraft.isSingleplayer()) {
                    tooltip.append(TOOLTIP_CANNOT_EDIT_THIS_WHILE_ONLINE).append((Component)EMPTY_LINE);
                    btn.active = false;
                    count = 99;
                } else if (type == ModConfig.Type.SERVER && this.minecraft.hasSingleplayerServer() && this.minecraft.getSingleplayerServer().isPublished()) {
                    tooltip.append(TOOLTIP_CANNOT_EDIT_THIS_WHILE_OPEN_TO_LAN).append((Component)EMPTY_LINE);
                    btn.active = false;
                    count = 99;
                }
                tooltip.append((Component)Component.translatable((String)FILENAME_TOOLTIP, (Object[])new Object[]{modConfig.getFileName()}).withStyle(FILENAME_TOOLTIP_STYLE));
                btn.setTooltip(Tooltip.create((Component)tooltip));
                this.list.addSmall((AbstractWidget)btn, null);
                ++count;
            }
        }
        if (count == 1) {
            this.autoClose = true;
            btn.onPress();
        }
    }

    public Component translatableConfig(ModConfig modConfig, String suffix, String fallback) {
        return Component.translatable((String)translationChecker.check(this.mod.getModId() + ".configuration.section." + modConfig.getFileName().replaceAll("[^a-zA-Z0-9]+", ".").replaceFirst("^\\.", "").replaceFirst("\\.$", "").toLowerCase(Locale.ENGLISH) + suffix, fallback), (Object[])new Object[]{this.mod.getModInfo().getDisplayName()});
    }

    public void added() {
        super.added();
        if (this.autoClose) {
            this.autoClose = false;
            this.onClose();
        }
    }

    public void onClose() {
        translationChecker.finish();
        switch (this.needsRestart) {
            case GAME: {
                this.minecraft.setScreen((Screen)new TooltipConfirmScreen(b -> {
                    if (b) {
                        this.minecraft.stop();
                    } else {
                        super.onClose();
                    }
                }, GAME_RESTART_TITLE, GAME_RESTART_MESSAGE, GAME_RESTART_YES, RESTART_NO));
                return;
            }
            case WORLD: {
                if (this.minecraft.level == null) break;
                this.minecraft.setScreen((Screen)new TooltipConfirmScreen(b -> {
                    if (b) {
                        this.onDisconnect();
                    } else {
                        super.onClose();
                    }
                }, SERVER_RESTART_TITLE, SERVER_RESTART_MESSAGE, this.minecraft.isLocalServer() ? RETURN_TO_MENU : CommonComponents.GUI_DISCONNECT, RESTART_NO));
                return;
            }
        }
        super.onClose();
    }

    private void onDisconnect() {
        boolean flag = this.minecraft.isLocalServer();
        ServerData serverdata = this.minecraft.getCurrentServer();
        this.minecraft.level.disconnect();
        if (flag) {
            this.minecraft.disconnect((Screen)new GenericMessageScreen(SAVING_LEVEL));
        } else {
            this.minecraft.disconnect();
        }
        TitleScreen titlescreen = new TitleScreen();
        if (flag) {
            this.minecraft.setScreen((Screen)titlescreen);
        } else if (serverdata != null && serverdata.isRealm()) {
            this.minecraft.setScreen((Screen)new RealmsMainScreen((Screen)titlescreen));
        } else {
            this.minecraft.setScreen((Screen)new JoinMultiplayerScreen((Screen)titlescreen));
        }
    }

    public static class ConfigurationSectionScreen
    extends OptionsSubScreen {
        protected static final long MAX_SLIDER_SIZE = 256L;
        protected final Context context;
        protected boolean changed = false;
        protected ModConfigSpec.RestartType needsRestart = ModConfigSpec.RestartType.NONE;
        protected final Map<String, ConfigurationSectionScreen> sectionCache = new HashMap<String, ConfigurationSectionScreen>();
        @Nullable
        protected Button undoButton;
        @Nullable
        protected Button resetButton;
        protected final Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(120).build();
        protected final UndoManager undoManager = new UndoManager();

        public ConfigurationSectionScreen(Screen parent, ModConfig.Type type, ModConfig modConfig, Component title) {
            this(parent, type, modConfig, title, (c, k, e) -> e);
        }

        public ConfigurationSectionScreen(Screen parent, ModConfig.Type type, ModConfig modConfig, Component title, Filter filter) {
            this(Context.top(modConfig.getModId(), parent, modConfig, filter), title);
            this.needsRestart = type == ModConfig.Type.STARTUP ? ModConfigSpec.RestartType.GAME : ModConfigSpec.RestartType.NONE;
        }

        public ConfigurationSectionScreen(Context parentContext, Screen parent, Map<String, Object> valueSpecs, String key, Set<? extends UnmodifiableConfig.Entry> entrySet, Component title) {
            this(Context.section(parentContext, parent, entrySet, valueSpecs, key), (Component)Component.translatable((String)ConfigurationScreen.CRUMB, (Object[])new Object[]{parent.getTitle(), CRUMB_SEPARATOR, title}));
        }

        protected ConfigurationSectionScreen(Context context, Component title) {
            super(context.parent, Minecraft.getInstance().options, title);
            this.context = context;
        }

        @Nullable
        protected ModConfigSpec.ValueSpec getValueSpec(String key) {
            Object object = this.context.valueSpecs.get(key);
            if (object instanceof ModConfigSpec.ValueSpec) {
                ModConfigSpec.ValueSpec vs = (ModConfigSpec.ValueSpec)object;
                return vs;
            }
            return null;
        }

        protected String getTranslationKey(String key) {
            ModConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
            String result = valueSpec != null ? valueSpec.getTranslationKey() : this.context.modSpec.getLevelTranslationKey(this.context.makeKeyList(key));
            return result != null ? result : this.context.modId + ".configuration." + key;
        }

        protected MutableComponent getTranslationComponent(String key) {
            return Component.translatable((String)translationChecker.check(this.getTranslationKey(key)));
        }

        protected String getComment(String key) {
            ModConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
            return valueSpec != null ? this.getValueSpec(key).getComment() : this.context.modSpec.getLevelComment(this.context.makeKeyList(key));
        }

        protected <T> OptionInstance.TooltipSupplier<T> getTooltip(String key, @Nullable ModConfigSpec.Range<?> range) {
            return OptionInstance.cachedConstantTooltip((Component)this.getTooltipComponent(key, range));
        }

        protected Component getTooltipComponent(String key, @Nullable ModConfigSpec.Range<?> range) {
            String tooltipKey = this.getTranslationKey(key) + ".tooltip";
            String comment = this.getComment(key);
            boolean hasTranslatedTooltip = translationChecker.existsWithFallback(tooltipKey);
            MutableComponent component = Component.empty().append((Component)this.getTranslationComponent(key).withStyle(ChatFormatting.BOLD));
            if (hasTranslatedTooltip || !Strings.isBlank((String)comment)) {
                component = component.append((Component)EMPTY_LINE).append((Component)Component.translatableWithFallback((String)tooltipKey, (String)comment));
            }
            component = component.append(translationChecker.optional((Component)EMPTY_LINE, tooltipKey + ".warning", ChatFormatting.RED, ChatFormatting.BOLD));
            if (hasTranslatedTooltip && range != null) {
                component = component.append((Component)EMPTY_LINE).append((Component)Component.translatable((String)ConfigurationScreen.RANGE_TOOLTIP, (Object[])new Object[]{range.toString()}).withStyle(RANGE_TOOLTIP_STYLE));
            }
            return component;
        }

        protected void onChanged(String key) {
            this.changed = true;
            ModConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
            if (valueSpec != null) {
                this.needsRestart = this.needsRestart.with(valueSpec.restartType());
            }
        }

        protected void addOptions() {
            this.rebuild();
        }

        protected ConfigurationSectionScreen rebuild() {
            if (this.list != null) {
                this.list.children().clear();
                boolean hasUndoableElements = false;
                ArrayList<@Nullable ? extends Element> elements = new ArrayList<Element>();
                block20: for (UnmodifiableConfig.Entry entry : this.context.entries) {
                    String key = entry.getKey();
                    Object rawValue = entry.getRawValue();
                    Objects.requireNonNull(entry.getRawValue());
                    int n = 0;
                    block21: while (true) {
                        Object object;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModConfigSpec.ConfigValue.class, UnmodifiableConfig.class}, (Object)object, n)) {
                            case 0: {
                                Element element;
                                ModConfigSpec.ConfigValue cv = (ModConfigSpec.ConfigValue)object;
                                ModConfigSpec.ValueSpec valueSpec = this.getValueSpec(key);
                                Object object2 = valueSpec;
                                int n2 = 0;
                                block22: while (true) {
                                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModConfigSpec.ListValueSpec.class, ModConfigSpec.ValueSpec.class, ModConfigSpec.ValueSpec.class, ModConfigSpec.ValueSpec.class, ModConfigSpec.ValueSpec.class, ModConfigSpec.ValueSpec.class}, (Object)object2, n2)) {
                                        case 0: {
                                            ModConfigSpec.ListValueSpec listValueSpec = (ModConfigSpec.ListValueSpec)object2;
                                            element = this.createList(key, listValueSpec, cv);
                                            break block22;
                                        }
                                        case 1: {
                                            Object spec = object2;
                                            if (cv.getClass() != ModConfigSpec.ConfigValue.class || !(((ModConfigSpec.ValueSpec)spec).getDefault() instanceof String)) {
                                                n2 = 2;
                                                continue block22;
                                            }
                                            element = this.createStringValue(key, valueSpec::test, () -> (String)cv.getRaw(), cv::set);
                                            break block22;
                                        }
                                        case 2: {
                                            Object spec = object2;
                                            if (cv.getClass() != ModConfigSpec.ConfigValue.class || !(((ModConfigSpec.ValueSpec)spec).getDefault() instanceof Integer)) {
                                                n2 = 3;
                                                continue block22;
                                            }
                                            element = this.createIntegerValue(key, valueSpec, () -> (Integer)cv.getRaw(), cv::set);
                                            break block22;
                                        }
                                        case 3: {
                                            Object spec = object2;
                                            if (cv.getClass() != ModConfigSpec.ConfigValue.class || !(((ModConfigSpec.ValueSpec)spec).getDefault() instanceof Long)) {
                                                n2 = 4;
                                                continue block22;
                                            }
                                            element = this.createLongValue(key, valueSpec, () -> (Long)cv.getRaw(), cv::set);
                                            break block22;
                                        }
                                        case 4: {
                                            Object spec = object2;
                                            if (cv.getClass() != ModConfigSpec.ConfigValue.class || !(((ModConfigSpec.ValueSpec)spec).getDefault() instanceof Double)) {
                                                n2 = 5;
                                                continue block22;
                                            }
                                            element = this.createDoubleValue(key, valueSpec, () -> (Double)cv.getRaw(), cv::set);
                                            break block22;
                                        }
                                        case 5: {
                                            Object spec = object2;
                                            if (cv.getClass() != ModConfigSpec.ConfigValue.class || !(((ModConfigSpec.ValueSpec)spec).getDefault() instanceof Enum)) {
                                                n2 = 6;
                                                continue block22;
                                            }
                                            element = this.createEnumValue(key, valueSpec, cv::getRaw, cv::set);
                                            break block22;
                                        }
                                        case -1: {
                                            element = null;
                                            break block22;
                                        }
                                        default: {
                                            ModConfigSpec.ConfigValue configValue;
                                            Objects.requireNonNull(cv);
                                            int n3 = 0;
                                            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModConfigSpec.BooleanValue.class, ModConfigSpec.IntValue.class, ModConfigSpec.LongValue.class, ModConfigSpec.DoubleValue.class, ModConfigSpec.EnumValue.class}, (Object)configValue, n3)) {
                                                case 0: {
                                                    ModConfigSpec.BooleanValue value = (ModConfigSpec.BooleanValue)configValue;
                                                    element = this.createBooleanValue(key, valueSpec, value::getRaw, value::set);
                                                    break block22;
                                                }
                                                case 1: {
                                                    ModConfigSpec.IntValue value = (ModConfigSpec.IntValue)configValue;
                                                    element = this.createIntegerValue(key, valueSpec, value::getRaw, value::set);
                                                    break block22;
                                                }
                                                case 2: {
                                                    ModConfigSpec.LongValue value = (ModConfigSpec.LongValue)configValue;
                                                    element = this.createLongValue(key, valueSpec, value::getRaw, value::set);
                                                    break block22;
                                                }
                                                case 3: {
                                                    ModConfigSpec.DoubleValue value = (ModConfigSpec.DoubleValue)configValue;
                                                    element = this.createDoubleValue(key, valueSpec, value::getRaw, value::set);
                                                    break block22;
                                                }
                                                case 4: {
                                                    ModConfigSpec.EnumValue value = (ModConfigSpec.EnumValue)configValue;
                                                    element = this.createEnumValue(key, valueSpec, value::getRaw, value::set);
                                                    break block22;
                                                }
                                            }
                                            element = this.createOtherValue(key, cv);
                                            break block22;
                                        }
                                    }
                                    break;
                                }
                                Element element2 = element;
                                elements.add(this.context.filter.filterEntry(this.context, key, element2));
                                continue block20;
                            }
                            case 1: {
                                UnmodifiableConfig subsection = (UnmodifiableConfig)object;
                                Object object2 = this.context.valueSpecs.get(key);
                                if (!(object2 instanceof UnmodifiableConfig)) {
                                    n = 2;
                                    continue block21;
                                }
                                UnmodifiableConfig subconfig = (UnmodifiableConfig)object2;
                                elements.add(this.createSection(key, subconfig, subsection));
                                continue block20;
                            }
                        }
                        break;
                    }
                    elements.add(this.context.filter.filterEntry(this.context, key, this.createOtherSection(key, rawValue)));
                }
                elements.addAll(this.createSyntheticValues());
                for (Element element : elements) {
                    if (element == null) continue;
                    if (element.name() == null) {
                        this.list.addSmall((AbstractWidget)new StringWidget(150, 20, (Component)Component.empty(), this.font), element.getWidget(this.options));
                    } else {
                        StringWidget label = new StringWidget(150, 20, element.name, this.font).alignLeft();
                        label.setTooltip(Tooltip.create((Component)element.tooltip));
                        this.list.addSmall((AbstractWidget)label, element.getWidget(this.options));
                    }
                    hasUndoableElements |= element.undoable;
                }
                if (hasUndoableElements && this.undoButton == null) {
                    this.createUndoButton();
                    this.createResetButton();
                }
            }
            return this;
        }

        protected Collection<? extends Element> createSyntheticValues() {
            return Collections.emptyList();
        }

        protected boolean isNonDefault(ModConfigSpec.ConfigValue<?> cv) {
            return !Objects.equals(cv.getRaw(), cv.getDefault());
        }

        protected boolean isAnyNondefault() {
            for (UnmodifiableConfig.Entry entry : this.context.entries) {
                Object object = entry.getRawValue();
                if (!(object instanceof ModConfigSpec.ConfigValue)) continue;
                ModConfigSpec.ConfigValue cv = (ModConfigSpec.ConfigValue)object;
                if (this.getValueSpec(entry.getKey()) instanceof ModConfigSpec.ListValueSpec || !this.isNonDefault(cv)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        protected Element createStringValue(String key, Predicate<String> tester, Supplier<String> source, Consumer<String> target) {
            if (source.get().length() > 192) {
                StringWidget label = new StringWidget(150, 20, (Component)Component.literal((String)source.get().substring(0, 128)), this.font).alignLeft();
                label.setTooltip(Tooltip.create((Component)LONG_STRING));
                return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), (AbstractWidget)label, false);
            }
            EditBox box = new EditBox(this.font, 150, 20, (Component)this.getTranslationComponent(key));
            box.setEditable(true);
            box.setTooltip(Tooltip.create((Component)this.getTooltipComponent(key, null)));
            box.setMaxLength(Mth.clamp((int)(source.get().length() + 5), (int)128, (int)192));
            box.setValue(source.get());
            box.setResponder(newValue -> {
                if (newValue != null && tester.test((String)newValue)) {
                    if (!newValue.equals(source.get())) {
                        this.undoManager.add(v -> {
                            target.accept((String)v);
                            this.onChanged(key);
                        }, newValue, v -> {
                            target.accept((String)v);
                            this.onChanged(key);
                        }, (String)source.get());
                    }
                    box.setTextColor(0xE0E0E0);
                    return;
                }
                box.setTextColor(-65536);
            });
            return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), (AbstractWidget)box);
        }

        @Nullable
        protected Element createOtherSection(String key, Object value) {
            return null;
        }

        @Nullable
        protected Element createOtherValue(String key, ModConfigSpec.ConfigValue<?> value) {
            StringWidget label = new StringWidget(150, 20, (Component)Component.literal((String)Objects.toString(value.getRaw())), this.font).alignLeft();
            label.setTooltip(Tooltip.create((Component)UNSUPPORTED_ELEMENT));
            return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), (AbstractWidget)label, false);
        }

        @Nullable
        protected Element createBooleanValue(String key, ModConfigSpec.ValueSpec spec, Supplier<Boolean> source, Consumer<Boolean> target) {
            return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), new OptionInstance(this.getTranslationKey(key), this.getTooltip(key, null), OptionInstance.BOOLEAN_TO_STRING, Custom.BOOLEAN_VALUES_NO_PREFIX, (Object)source.get(), newValue -> this.undoManager.add(v -> {
                target.accept((Boolean)v);
                this.onChanged(key);
            }, newValue, v -> {
                target.accept((Boolean)v);
                this.onChanged(key);
            }, (Boolean)source.get())));
        }

        @Nullable
        protected <T extends Enum<T>> Element createEnumValue(String key, ModConfigSpec.ValueSpec spec, Supplier<T> source, Consumer<T> target) {
            Class<?> clazz = spec.getClazz();
            assert (clazz != null);
            List<Enum> list = Arrays.stream((Enum[])clazz.getEnumConstants()).filter(spec::test).toList();
            return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), new OptionInstance(this.getTranslationKey(key), this.getTooltip(key, null), (caption, displayvalue) -> {
                MutableComponent mutableComponent;
                if (displayvalue instanceof TranslatableEnum) {
                    TranslatableEnum tenum = (TranslatableEnum)((Object)displayvalue);
                    mutableComponent = tenum.getTranslatedName();
                } else {
                    mutableComponent = Component.literal((String)displayvalue.name());
                }
                return mutableComponent;
            }, new Custom<Enum>(list), (Object)((Enum)source.get()), newValue -> this.undoManager.add(v -> {
                target.accept(v);
                this.onChanged(key);
            }, newValue, v -> {
                target.accept(v);
                this.onChanged(key);
            }, (Enum)source.get())));
        }

        @Nullable
        protected Element createIntegerValue(String key, ModConfigSpec.ValueSpec spec, Supplier<Integer> source, Consumer<Integer> target) {
            int max;
            ModConfigSpec.Range<Integer> range = spec.getRange();
            int min = range != null ? (Integer)range.getMin() : 0;
            int n = max = range != null ? (Integer)range.getMax() : Integer.MAX_VALUE;
            if ((long)max - (long)min < 256L) {
                return this.createSlider(key, source, target, range);
            }
            return this.createNumberBox(key, spec, source, target, null, Integer::decode, 0);
        }

        @Nullable
        protected Element createSlider(String key, Supplier<Integer> source, Consumer<Integer> target, @Nullable ModConfigSpec.Range<Integer> range) {
            return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), new OptionInstance(this.getTranslationKey(key), this.getTooltip(key, range), (caption, displayvalue) -> Component.literal((String)("" + displayvalue)), (OptionInstance.ValueSet)new OptionInstance.IntRange(range != null ? range.getMin() : 0, range != null ? range.getMax() : Integer.MAX_VALUE), null, (Object)source.get(), newValue -> {
                if (!newValue.equals(source.get())) {
                    this.undoManager.add(v -> {
                        target.accept((Integer)v);
                        this.onChanged(key);
                    }, newValue, v -> {
                        target.accept((Integer)v);
                        this.onChanged(key);
                    }, (Integer)source.get());
                }
            }));
        }

        @Nullable
        protected Element createLongValue(String key, ModConfigSpec.ValueSpec spec, Supplier<Long> source, Consumer<Long> target) {
            return this.createNumberBox(key, spec, source, target, null, Long::decode, 0L);
        }

        @Nullable
        protected <T extends Number> Element createNumberBox(String key, ModConfigSpec.ValueSpec spec, Supplier<T> source, Consumer<T> target, @Nullable Predicate<T> tester, Function<String, T> parser, T zero) {
            ModConfigSpec.Range range = spec.getRange();
            EditBox box = new EditBox(this.font, 150, 20, (Component)this.getTranslationComponent(key));
            box.setEditable(true);
            box.setFilter(newValueString -> {
                try {
                    parser.apply((String)newValueString);
                    return true;
                }
                catch (NumberFormatException e) {
                    return this.isPartialNumber((String)newValueString, range == null || ((Comparable)((Object)((Number)range.getMin()))).compareTo(zero) < 0);
                }
            });
            box.setTooltip(Tooltip.create((Component)this.getTooltipComponent(key, range)));
            box.setValue(String.valueOf(source.get()));
            box.setResponder(newValueString -> {
                try {
                    Number newValue = (Number)parser.apply((String)newValueString);
                    if (tester != null ? tester.test(newValue) : newValue != null && (range == null || range.test(newValue)) && spec.test(newValue)) {
                        if (!newValue.equals(source.get())) {
                            this.undoManager.add(v -> {
                                target.accept(v);
                                this.onChanged(key);
                            }, newValue, v -> {
                                target.accept(v);
                                this.onChanged(key);
                            }, (Number)source.get());
                        }
                        box.setTextColor(0xE0E0E0);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                box.setTextColor(-65536);
            });
            return new Element((Component)this.getTranslationComponent(key), this.getTooltipComponent(key, null), (AbstractWidget)box);
        }

        protected boolean isPartialNumber(String value, boolean allowNegative) {
            return switch (value) {
                case "" -> true;
                case "0" -> true;
                case "0x" -> true;
                case "0X" -> true;
                case "#" -> true;
                case "-" -> allowNegative;
                case "-0" -> allowNegative;
                case "-0x" -> allowNegative;
                case "-0X" -> allowNegative;
                default -> false;
            };
        }

        @Nullable
        protected Element createDoubleValue(String key, ModConfigSpec.ValueSpec spec, Supplier<Double> source, Consumer<Double> target) {
            return this.createNumberBox(key, spec, source, target, null, Double::parseDouble, 0.0);
        }

        @Nullable
        protected Element createSection(String key, UnmodifiableConfig subconfig, UnmodifiableConfig subsection) {
            if (subconfig.isEmpty()) {
                return null;
            }
            return new Element((Component)Component.translatable((String)ConfigurationScreen.SECTION, (Object[])new Object[]{this.getTranslationComponent(key)}), this.getTooltipComponent(key, null), (AbstractWidget)Button.builder((Component)Component.translatable((String)ConfigurationScreen.SECTION, (Object[])new Object[]{Component.translatable((String)translationChecker.check(this.getTranslationKey(key) + ".button", ConfigurationScreen.SECTION_TEXT))}), button -> this.minecraft.setScreen((Screen)this.sectionCache.computeIfAbsent(key, k -> new ConfigurationSectionScreen(this.context, (Screen)this, subconfig.valueMap(), key, subsection.entrySet(), (Component)Component.translatable((String)this.getTranslationKey(key))).rebuild()))).tooltip(Tooltip.create((Component)this.getTooltipComponent(key, null))).width(150).build(), false);
        }

        @Nullable
        protected <T> Element createList(String key, ModConfigSpec.ListValueSpec spec, ModConfigSpec.ConfigValue<List<T>> list) {
            return new Element((Component)Component.translatable((String)ConfigurationScreen.SECTION, (Object[])new Object[]{this.getTranslationComponent(key)}), this.getTooltipComponent(key, null), (AbstractWidget)Button.builder((Component)Component.translatable((String)ConfigurationScreen.SECTION, (Object[])new Object[]{Component.translatable((String)translationChecker.check(this.getTranslationKey(key) + ".button", ConfigurationScreen.SECTION_TEXT))}), button -> this.minecraft.setScreen((Screen)this.sectionCache.computeIfAbsent(key, k -> new ConfigurationListScreen(Context.list(this.context, (Screen)this), key, (Component)Component.translatable((String)ConfigurationScreen.CRUMB, (Object[])new Object[]{this.getTitle(), CRUMB_SEPARATOR, this.getTranslationComponent(key)}), spec, list)).rebuild())).tooltip(Tooltip.create((Component)this.getTooltipComponent(key, null))).build(), false);
        }

        public void render(GuiGraphics graphics, int p_281550_, int p_282878_, float p_282465_) {
            this.setUndoButtonstate(this.undoManager.canUndo());
            this.setResetButtonstate(this.isAnyNondefault());
            super.render(graphics, p_281550_, p_282878_, p_282465_);
        }

        protected void addFooter() {
            if (this.undoButton != null || this.resetButton != null) {
                LinearLayout linearlayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
                if (this.undoButton != null) {
                    linearlayout.addChild((LayoutElement)this.undoButton);
                }
                if (this.resetButton != null) {
                    linearlayout.addChild((LayoutElement)this.resetButton);
                }
                linearlayout.addChild((LayoutElement)this.doneButton);
            } else {
                super.addFooter();
            }
        }

        protected void createUndoButton() {
            this.undoButton = Button.builder((Component)UNDO, button -> {
                this.undoManager.undo();
                this.rebuild();
            }).tooltip(Tooltip.create((Component)UNDO_TOOLTIP)).width(120).build();
            this.undoButton.active = false;
        }

        protected void setUndoButtonstate(boolean state) {
            if (this.undoButton != null) {
                this.undoButton.active = state;
            }
        }

        protected void createResetButton() {
            this.resetButton = Button.builder((Component)RESET, button -> {
                ArrayList list = new ArrayList();
                for (UnmodifiableConfig.Entry entry : this.context.entries) {
                    Object patt0$temp = entry.getRawValue();
                    if (!(patt0$temp instanceof ModConfigSpec.ConfigValue)) continue;
                    ModConfigSpec.ConfigValue cv = (ModConfigSpec.ConfigValue)patt0$temp;
                    if (this.getValueSpec(entry.getKey()) instanceof ModConfigSpec.ListValueSpec || !this.isNonDefault(cv)) continue;
                    String key = entry.getKey();
                    list.add(this.undoManager.step(v -> {
                        cv.set(v);
                        this.onChanged(key);
                    }, this.getValueSpec(key).correct(null), v -> {
                        cv.set(v);
                        this.onChanged(key);
                    }, cv.getRaw()));
                }
                this.undoManager.add(list);
                this.rebuild();
            }).tooltip(Tooltip.create((Component)RESET_TOOLTIP)).width(120).build();
        }

        protected void setResetButtonstate(boolean state) {
            if (this.resetButton != null) {
                this.resetButton.active = state;
            }
        }

        public void onClose() {
            if (this.changed) {
                ConfigurationSectionScreen parent;
                Screen screen = this.lastScreen;
                if (screen instanceof ConfigurationSectionScreen) {
                    parent = (ConfigurationSectionScreen)screen;
                    parent.changed = true;
                } else {
                    this.context.modSpec.save();
                }
                Screen screen2 = this.lastScreen;
                if (screen2 instanceof ConfigurationSectionScreen) {
                    parent = (ConfigurationSectionScreen)screen2;
                    parent.needsRestart = parent.needsRestart.with(this.needsRestart);
                } else {
                    screen2 = this.lastScreen;
                    if (screen2 instanceof ConfigurationScreen) {
                        ConfigurationScreen parent2 = (ConfigurationScreen)screen2;
                        parent2.needsRestart = parent2.needsRestart.with(this.needsRestart);
                    }
                }
            }
            super.onClose();
        }

        public static interface Filter {
            @Nullable
            public Element filterEntry(Context var1, String var2, Element var3);
        }

        public record Context(String modId, Screen parent, ModConfig modConfig, ModConfigSpec modSpec, Set<? extends UnmodifiableConfig.Entry> entries, Map<String, Object> valueSpecs, List<String> keylist, Filter filter) {
            public static Context top(String modId, Screen parent, ModConfig modConfig, Filter filter) {
                return new Context(modId, parent, modConfig, (ModConfigSpec)modConfig.getSpec(), ((ModConfigSpec)modConfig.getSpec()).getValues().entrySet(), ((ModConfigSpec)modConfig.getSpec()).getSpec().valueMap(), List.of(), filter);
            }

            public static Context section(Context parentContext, Screen parent, Set<? extends UnmodifiableConfig.Entry> entries, Map<String, Object> valueSpecs, String key) {
                return new Context(parentContext.modId, parent, parentContext.modConfig, parentContext.modSpec, entries, valueSpecs, parentContext.makeKeyList(key), parentContext.filter);
            }

            public static Context list(Context parentContext, Screen parent) {
                return new Context(parentContext.modId, parent, parentContext.modConfig, parentContext.modSpec, parentContext.entries, parentContext.valueSpecs, parentContext.keylist, null);
            }

            private ArrayList<String> makeKeyList(String key) {
                ArrayList<String> result = new ArrayList<String>(this.keylist);
                result.add(key);
                return result;
            }
        }

        public record Element(@Nullable Component name, @Nullable Component tooltip, @Nullable AbstractWidget widget, @Nullable OptionInstance<?> option, boolean undoable) {
            public Element(@Nullable Component name, @Nullable Component tooltip, AbstractWidget widget) {
                this(name, tooltip, widget, null, true);
            }

            public Element(@Nullable Component name, @Nullable Component tooltip, AbstractWidget widget, boolean undoable) {
                this(name, tooltip, widget, null, undoable);
            }

            public Element(Component name, Component tooltip, OptionInstance<?> option) {
                this(name, tooltip, null, option, true);
            }

            public Element(Component name, Component tooltip, OptionInstance<?> option, boolean undoable) {
                this(name, tooltip, null, option, undoable);
            }

            public AbstractWidget getWidget(Options options) {
                return this.widget != null ? this.widget : this.option.createButton(options);
            }

            @Nullable
            public Object any() {
                return this.widget != null ? this.widget : this.option;
            }
        }

        public record Custom<T>(List<T> values) implements OptionInstance.ValueSet<T>
        {
            public static final Custom<Boolean> BOOLEAN_VALUES_NO_PREFIX = new Custom(ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE));

            public Function<OptionInstance<T>, AbstractWidget> createButton(OptionInstance.TooltipSupplier<T> tooltip, Options options, int x, int y, int width, Consumer<T> target) {
                return optionsInstance -> CycleButton.builder((Function)optionsInstance.toString).withValues(CycleButton.ValueListSupplier.create(this.values)).withTooltip(tooltip).displayOnlyValue().withInitialValue(optionsInstance.get()).create(x, y, width, 20, optionsInstance.caption, (source, newValue) -> {
                    optionsInstance.set(newValue);
                    options.save();
                    target.accept(newValue);
                });
            }

            public Optional<T> validateValue(T value) {
                return this.values.contains(value) ? Optional.of(value) : Optional.empty();
            }

            public Codec<T> codec() {
                return null;
            }
        }
    }

    public static class TranslationChecker {
        private static final Logger LOGGER = LogManager.getLogger();
        private final Set<String> untranslatables = new HashSet<String>();
        private final Set<String> untranslatablesWithFallback = new HashSet<String>();

        public String check(String translationKey) {
            if (!I18n.exists((String)translationKey)) {
                this.untranslatables.add(translationKey);
            }
            return translationKey;
        }

        public String check(String translationKey, String fallback) {
            if (!I18n.exists((String)translationKey)) {
                this.untranslatablesWithFallback.add(translationKey);
                return this.check(fallback);
            }
            return translationKey;
        }

        public boolean existsWithFallback(String translationKey) {
            if (!I18n.exists((String)translationKey)) {
                this.untranslatablesWithFallback.add(translationKey);
                return false;
            }
            return true;
        }

        public Component optional(Component prefix, String translationKey, ChatFormatting ... style) {
            if (I18n.exists((String)translationKey)) {
                return Component.empty().append(prefix).append((Component)Component.translatable((String)translationKey).withStyle(style));
            }
            return Component.empty();
        }

        public void finish() {
            if (!(!((Boolean)NeoForgeClientConfig.INSTANCE.logUntranslatedConfigurationWarnings.get()).booleanValue() || FMLLoader.isProduction() || this.untranslatables.isEmpty() && this.untranslatablesWithFallback.isEmpty())) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\n\tDev warning - Untranslated configuration keys encountered. Please translate your configuration keys so users can properly configure your mod.\n");
                if (!this.untranslatables.isEmpty()) {
                    stringBuilder.append("\nUntranslated keys:");
                    for (String key : this.untranslatables) {
                        stringBuilder.append("\n  \"").append(key).append("\": \"\",");
                    }
                }
                if (!this.untranslatablesWithFallback.isEmpty()) {
                    stringBuilder.append("\nThe following keys have fallbacks. Please check if those are suitable, and translate them if they're not.");
                    for (String key : this.untranslatablesWithFallback) {
                        stringBuilder.append("\n  \"").append(key).append("\": \"\",");
                    }
                }
                LOGGER.warn((CharSequence)stringBuilder);
            }
            this.untranslatables.clear();
        }
    }

    private static final class TooltipConfirmScreen
    extends ConfirmScreen {
        boolean seenYes = false;

        private TooltipConfirmScreen(BooleanConsumer callback, Component title, Component message, Component yesButton, Component noButton) {
            super(callback, title, message, yesButton, noButton);
        }

        protected void init() {
            this.seenYes = false;
            super.init();
        }

        protected void addExitButton(Button button) {
            if (this.seenYes) {
                button.setTooltip(Tooltip.create((Component)RESTART_NO_TOOLTIP));
            } else {
                this.seenYes = true;
            }
            super.addExitButton(button);
        }
    }

    public static final class UndoManager {
        private final List<Step<?>> undos = new ArrayList();
        private final List<Step<?>> redos = new ArrayList();

        public void undo() {
            if (this.canUndo()) {
                Step<?> step = this.undos.removeLast();
                step.runUndo();
                this.redos.add(step);
            }
        }

        public void redo() {
            if (this.canRedo()) {
                Step<?> step = this.redos.removeLast();
                step.runRedo();
                this.undos.add(step);
            }
        }

        private void add(Step<?> step, boolean execute) {
            this.undos.add(step);
            this.redos.clear();
            if (execute) {
                step.runRedo();
            }
        }

        public <T> Step<T> step(Consumer<T> run, T newValue, Consumer<T> undo, T oldValue) {
            return new Step<T>(run, newValue, undo, oldValue);
        }

        public <T> void add(Consumer<T> run, T newValue, Consumer<T> undo, T oldValue) {
            this.add(this.step(run, newValue, undo, oldValue), true);
        }

        public <T> void addNoExecute(Consumer<T> run, T newValue, Consumer<T> undo, T oldValue) {
            this.add(this.step(run, newValue, undo, oldValue), false);
        }

        public void add(Step<?> ... steps) {
            this.add((List<Step<?>>)ImmutableList.copyOf((Object[])steps));
        }

        public void add(List<Step<?>> steps) {
            this.add(new Step<Object>(n -> steps.forEach(Step::runRedo), null, n -> steps.forEach(Step::runUndo), null), true);
        }

        public boolean canUndo() {
            return !this.undos.isEmpty();
        }

        public boolean canRedo() {
            return !this.redos.isEmpty();
        }

        public record Step<T>(Consumer<T> run, T newValue, Consumer<T> undo, T oldValue) {
            private void runUndo() {
                this.undo.accept(this.oldValue);
            }

            private void runRedo() {
                this.run.accept(this.newValue);
            }
        }
    }

    public static class ConfigurationListScreen<T>
    extends ConfigurationSectionScreen {
        protected final String key;
        protected final ModConfigSpec.ListValueSpec spec;
        protected final ModConfigSpec.ConfigValue<List<T>> valueList;
        protected List<T> cfgList;

        public ConfigurationListScreen(ConfigurationSectionScreen.Context context, String key, Component title, ModConfigSpec.ListValueSpec spec, ModConfigSpec.ConfigValue<List<T>> valueList) {
            super(context, title);
            this.key = key;
            this.spec = spec;
            this.valueList = valueList;
            this.cfgList = new ArrayList<T>((Collection)valueList.getRaw());
        }

        @Override
        protected ConfigurationSectionScreen rebuild() {
            if (this.list != null) {
                this.list.children().clear();
                for (int idx = 0; idx < this.cfgList.size(); ++idx) {
                    ConfigurationSectionScreen.Element element;
                    T entry;
                    T t = entry = this.cfgList.get(idx);
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Integer.class, Long.class, Double.class, String.class}, t, n)) {
                        case -1: {
                            ConfigurationSectionScreen.Element element2 = null;
                            break;
                        }
                        case 0: {
                            Boolean value = (Boolean)t;
                            ConfigurationSectionScreen.Element element2 = this.createBooleanListValue(idx, value);
                            break;
                        }
                        case 1: {
                            Integer value = (Integer)t;
                            ConfigurationSectionScreen.Element element2 = this.createIntegerListValue(idx, value);
                            break;
                        }
                        case 2: {
                            Long value = (Long)t;
                            ConfigurationSectionScreen.Element element2 = this.createLongListValue(idx, value);
                            break;
                        }
                        case 3: {
                            Double value = (Double)t;
                            ConfigurationSectionScreen.Element element2 = this.createDoubleListValue(idx, value);
                            break;
                        }
                        case 4: {
                            String value = (String)t;
                            ConfigurationSectionScreen.Element element2 = this.createStringListValue(idx, value);
                            break;
                        }
                        default: {
                            ConfigurationSectionScreen.Element element2 = element = this.createOtherValue(idx, entry);
                        }
                    }
                    if (element == null) continue;
                    AbstractWidget widget = element.getWidget(this.options);
                    if (widget instanceof EditBox) {
                        EditBox box = (EditBox)widget;
                        box.setValue(box.getValue());
                    }
                    this.list.addSmall(this.createListLabel(idx), widget);
                }
                this.createAddElementButton();
                if (this.undoButton == null) {
                    this.createUndoButton();
                    this.createResetButton();
                }
            }
            return this;
        }

        @Override
        protected boolean isAnyNondefault() {
            return !this.cfgList.equals(this.valueList.getDefault());
        }

        protected void createAddElementButton() {
            Supplier<?> newElement = this.spec.getNewElementSupplier();
            ModConfigSpec.Range<Integer> sizeRange = this.spec.getSizeRange();
            if (newElement != null && sizeRange.test((Object)(this.cfgList.size() + 1))) {
                this.list.addSmall((AbstractWidget)new StringWidget(150, 20, (Component)Component.empty(), this.font), (AbstractWidget)Button.builder((Component)NEW_LIST_ELEMENT, button -> {
                    ArrayList<T> newValue = new ArrayList<T>(this.cfgList);
                    newValue.add(newElement.get());
                    this.undoManager.add(v -> {
                        this.cfgList = v;
                        this.onChanged(this.key);
                    }, newValue, v -> {
                        this.cfgList = v;
                        this.onChanged(this.key);
                    }, this.cfgList);
                    this.rebuild();
                }).build());
            }
        }

        protected AbstractWidget createListLabel(int idx) {
            return new ListLabelWidget(0, 0, 150, 20, (Component)Component.translatable((String)ConfigurationScreen.LIST_ELEMENT, (Object[])new Object[]{idx}), idx);
        }

        @Nullable
        protected ConfigurationSectionScreen.Element createOtherValue(int idx, T entry) {
            StringWidget label = new StringWidget(150, 20, (Component)Component.literal((String)Objects.toString(entry)), this.font).alignLeft();
            label.setTooltip(Tooltip.create((Component)UNSUPPORTED_ELEMENT));
            return new ConfigurationSectionScreen.Element((Component)this.getTranslationComponent(this.key), this.getTooltipComponent(this.key, null), (AbstractWidget)label, false);
        }

        @Nullable
        protected ConfigurationSectionScreen.Element createStringListValue(int idx, String value) {
            return this.createStringValue(this.key, v -> this.spec.test(List.of(v)), () -> value, newValue -> this.cfgList.set(idx, newValue));
        }

        @Nullable
        protected ConfigurationSectionScreen.Element createDoubleListValue(int idx, Double value) {
            return this.createNumberBox(this.key, this.spec, () -> value, newValue -> this.cfgList.set(idx, newValue), v -> this.spec.test(List.of(v)), Double::parseDouble, 0.0);
        }

        @Nullable
        protected ConfigurationSectionScreen.Element createLongListValue(int idx, Long value) {
            return this.createNumberBox(this.key, this.spec, () -> value, newValue -> this.cfgList.set(idx, newValue), v -> this.spec.test(List.of(v)), Long::decode, 0L);
        }

        @Nullable
        protected ConfigurationSectionScreen.Element createIntegerListValue(int idx, Integer value) {
            return this.createNumberBox(this.key, this.spec, () -> value, newValue -> this.cfgList.set(idx, newValue), v -> this.spec.test(List.of(v)), Integer::decode, 0);
        }

        @Nullable
        protected ConfigurationSectionScreen.Element createBooleanListValue(int idx, Boolean value) {
            return this.createBooleanValue(this.key, this.spec, () -> value, newValue -> this.cfgList.set(idx, newValue));
        }

        protected boolean swap(int idx, boolean simulate) {
            ArrayList<T> values = new ArrayList<T>(this.cfgList);
            values.add(idx, values.remove(idx + 1));
            return this.addUndoListener(simulate, values);
        }

        protected boolean del(int idx, boolean simulate) {
            ArrayList<T> values = new ArrayList<T>(this.cfgList);
            values.remove(idx);
            return this.addUndoListener(simulate, values);
        }

        private boolean addUndoListener(boolean simulate, List<T> values) {
            boolean valid = this.spec.test(values);
            if (!simulate && valid) {
                this.undoManager.add(v -> {
                    this.cfgList = v;
                    this.onChanged(this.key);
                }, values, v -> {
                    this.cfgList = v;
                    this.onChanged(this.key);
                }, this.cfgList);
                this.rebuild();
            }
            return valid;
        }

        @Override
        public void onClose() {
            if (this.changed && this.spec.test(this.cfgList)) {
                this.valueList.set(this.cfgList);
                Screen screen = this.context.parent;
                if (screen instanceof ConfigurationSectionScreen) {
                    ConfigurationSectionScreen parent = (ConfigurationSectionScreen)screen;
                    parent.onChanged(this.key);
                }
            }
            super.onClose();
        }

        @Override
        public void render(GuiGraphics graphics, int p_281550_, int p_282878_, float p_282465_) {
            this.doneButton.active = this.spec.test(this.cfgList);
            super.render(graphics, p_281550_, p_282878_, p_282465_);
        }

        @Override
        protected void onChanged(String key) {
            this.changed = true;
        }

        @Override
        protected void createResetButton() {
            this.resetButton = Button.builder((Component)RESET, button -> {
                this.undoManager.add(v -> {
                    this.cfgList = v;
                    this.onChanged(this.key);
                }, new ArrayList((List)this.getValueSpec(this.key).correct(null)), v -> {
                    this.cfgList = v;
                    this.onChanged(this.key);
                }, this.cfgList);
                this.rebuild();
            }).tooltip(Tooltip.create((Component)RESET_TOOLTIP)).width(120).build();
        }

        public class ListLabelWidget
        extends AbstractContainerWidget {
            protected final Button upButton;
            protected final Button downButton;
            protected final Button delButton;
            protected final StringWidget label;
            protected final int idx;
            protected final boolean isFirst;
            protected final boolean isLast;

            public ListLabelWidget(int x, int y, int width, int height, Component labelText, int idx) {
                super(x, y, width, height, labelText);
                this.upButton = Button.builder((Component)MOVE_LIST_ELEMENT_UP, this::up).build();
                this.downButton = Button.builder((Component)MOVE_LIST_ELEMENT_DOWN, this::down).build();
                this.delButton = Button.builder((Component)REMOVE_LIST_ELEMENT, this::rem).build();
                this.label = new StringWidget(0, 0, 0, 0, (Component)Component.empty(), ConfigurationListScreen.this.font).alignLeft();
                this.idx = idx;
                this.isFirst = idx == 0;
                this.isLast = idx + 1 == ConfigurationListScreen.this.cfgList.size();
                this.label.setMessage(labelText);
                this.checkButtons();
                this.updateLayout();
            }

            public void setX(int pX) {
                super.setX(pX);
                this.updateLayout();
            }

            public void setY(int pY) {
                super.setY(pY);
                this.updateLayout();
            }

            public void setHeight(int pHeight) {
                super.setHeight(pHeight);
                this.updateLayout();
            }

            public void setWidth(int pWidth) {
                super.setWidth(pWidth);
                this.updateLayout();
            }

            public void setSize(int pWidth, int pHeight) {
                super.setSize(pWidth, pHeight);
                this.updateLayout();
            }

            protected void updateLayout() {
                this.upButton.setX(this.getX());
                this.downButton.setX(this.getX() + this.getHeight() + 2);
                this.delButton.setX(this.getX() + this.getWidth() - this.getHeight());
                this.label.setX(this.getX() + 44);
                this.upButton.setY(this.getY());
                this.downButton.setY(this.getY());
                this.delButton.setY(this.getY());
                this.label.setY(this.getY());
                this.upButton.setHeight(this.getHeight());
                this.downButton.setHeight(this.getHeight());
                this.delButton.setHeight(this.getHeight());
                this.label.setHeight(this.getHeight());
                this.upButton.setWidth(this.getHeight());
                this.downButton.setWidth(this.getHeight());
                this.delButton.setWidth(this.getHeight());
                this.label.setWidth(this.getWidth() - 3 * (this.getHeight() + 2));
            }

            void up(Button button) {
                ConfigurationListScreen.this.swap(this.idx - 1, false);
            }

            void down(Button button) {
                ConfigurationListScreen.this.swap(this.idx, false);
            }

            void rem(Button button) {
                ConfigurationListScreen.this.del(this.idx, false);
            }

            public List<? extends GuiEventListener> children() {
                return List.of(this.upButton, this.label, this.downButton, this.delButton);
            }

            protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                this.checkButtons();
                this.label.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
                if (!this.isFirst) {
                    this.upButton.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
                }
                if (!this.isLast) {
                    this.downButton.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
                }
                this.delButton.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            }

            protected void checkButtons() {
                this.upButton.visible = !this.isFirst;
                this.upButton.active = !this.isFirst && ConfigurationListScreen.this.swap(this.idx - 1, true);
                this.downButton.visible = !this.isLast;
                this.downButton.active = !this.isLast && ConfigurationListScreen.this.swap(this.idx, true);
                ModConfigSpec.Range<Integer> sizeRange = ConfigurationListScreen.this.spec.getSizeRange();
                this.delButton.active = !ConfigurationListScreen.this.cfgList.isEmpty() && (sizeRange == null || sizeRange.test((Object)(ConfigurationListScreen.this.cfgList.size() - 1))) && ConfigurationListScreen.this.del(this.idx, true);
            }

            protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
            }

            protected int contentHeight() {
                return 0;
            }

            protected double scrollRate() {
                return 4.0;
            }
        }
    }
}

