/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.lighting;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.config.NeoForgeClientConfig;
import net.neoforged.neoforge.client.model.lighting.FlatQuadLighter;
import net.neoforged.neoforge.client.model.lighting.QuadLighter;
import net.neoforged.neoforge.client.model.lighting.SmoothQuadLighter;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LightPipelineAwareModelBlockRenderer
extends ModelBlockRenderer {
    private static final Direction[] SIDES = Direction.values();
    private final ThreadLocal<QuadLighter> flatLighter = ThreadLocal.withInitial(() -> new FlatQuadLighter(colors));
    private final ThreadLocal<QuadLighter> smoothLighter = ThreadLocal.withInitial(() -> new SmoothQuadLighter(colors));

    public LightPipelineAwareModelBlockRenderer(BlockColors colors) {
        super(colors);
    }

    public void tesselateWithoutAO(BlockAndTintGetter level, List<BlockModelPart> modelParts, BlockState state, BlockPos pos, PoseStack poseStack, Function<RenderType, VertexConsumer> bufferLookup, boolean checkSides, int packedOverlay) {
        if (((Boolean)NeoForgeClientConfig.INSTANCE.experimentalForgeLightPipelineEnabled.get()).booleanValue()) {
            LightPipelineAwareModelBlockRenderer.render(bufferLookup, this.flatLighter.get(), level, modelParts, state, pos, poseStack, checkSides, packedOverlay);
        } else {
            super.tesselateWithoutAO(level, modelParts, state, pos, poseStack, bufferLookup, checkSides, packedOverlay);
        }
    }

    public void tesselateWithAO(BlockAndTintGetter level, List<BlockModelPart> modelParts, BlockState state, BlockPos pos, PoseStack poseStack, Function<RenderType, VertexConsumer> bufferLookup, boolean checkSides, int packedOverlay) {
        if (((Boolean)NeoForgeClientConfig.INSTANCE.experimentalForgeLightPipelineEnabled.get()).booleanValue()) {
            LightPipelineAwareModelBlockRenderer.render(bufferLookup, this.smoothLighter.get(), level, modelParts, state, pos, poseStack, checkSides, packedOverlay);
        } else {
            super.tesselateWithAO(level, modelParts, state, pos, poseStack, bufferLookup, checkSides, packedOverlay);
        }
    }

    public static boolean render(Function<RenderType, VertexConsumer> bufferLookup, QuadLighter lighter, BlockAndTintGetter level, List<BlockModelPart> modelParts, BlockState state, BlockPos pos, PoseStack poseStack, boolean checkSides, int packedOverlay) {
        LightPipelineAwareModelBlockRenderer renderer = (LightPipelineAwareModelBlockRenderer)Minecraft.getInstance().getBlockRenderer().getModelRenderer();
        ModelBlockRenderer.Cache cache = (ModelBlockRenderer.Cache)ModelBlockRenderer.CACHE.get();
        PoseStack.Pose pose = poseStack.last();
        boolean empty = true;
        boolean smoothLighter = lighter instanceof SmoothQuadLighter;
        QuadLighter flatLighter = null;
        BlockPos.MutableBlockPos scratchPos = new BlockPos.MutableBlockPos();
        int checkedSides = 0;
        int visibleSides = 0;
        for (BlockModelPart part : modelParts) {
            VertexConsumer vertexConsumer = bufferLookup.apply(part.getRenderType(state));
            List quads = part.getQuads(null);
            if (!quads.isEmpty()) {
                empty = false;
                lighter.setup(level, pos, state, cache);
                for (BakedQuad quad : quads) {
                    if (smoothLighter && !quad.hasAmbientOcclusion()) {
                        if (flatLighter == null) {
                            flatLighter = renderer.flatLighter.get();
                            flatLighter.setup(level, pos, state, cache);
                        }
                        flatLighter.process(vertexConsumer, pose, quad, packedOverlay);
                        continue;
                    }
                    lighter.process(vertexConsumer, pose, quad, packedOverlay);
                }
            }
            for (Direction side : SIDES) {
                boolean sideVisible;
                int sideOrdinal = 1 << side.ordinal();
                boolean sideChecked = (checkedSides & sideOrdinal) == 1;
                boolean bl = sideVisible = (visibleSides & sideOrdinal) == 1;
                if (sideChecked && !sideVisible) continue;
                if (!sideChecked) {
                    checkedSides |= sideOrdinal;
                    if (!LightPipelineAwareModelBlockRenderer.shouldRenderFace((BlockAndTintGetter)level, (BlockPos)pos, (BlockState)state, (boolean)checkSides, (Direction)side, (BlockPos)scratchPos.setWithOffset((Vec3i)pos, side))) continue;
                    visibleSides |= sideOrdinal;
                }
                if ((quads = part.getQuads(side)).isEmpty()) continue;
                if (empty) {
                    empty = false;
                    lighter.setup(level, pos, state, cache);
                }
                for (BakedQuad quad : quads) {
                    if (smoothLighter && !quad.hasAmbientOcclusion()) {
                        if (flatLighter == null) {
                            flatLighter = renderer.flatLighter.get();
                            flatLighter.setup(level, pos, state, cache);
                        }
                        flatLighter.process(vertexConsumer, pose, quad, packedOverlay);
                        continue;
                    }
                    lighter.process(vertexConsumer, pose, quad, packedOverlay);
                }
            }
        }
        lighter.reset();
        if (flatLighter != null) {
            flatLighter.reset();
        }
        return !empty;
    }

    public QuadLighter getQuadLighter(boolean smooth) {
        return (smooth ? this.smoothLighter : this.flatLighter).get();
    }
}

