/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.config;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public final class NeoForgeClientConfig {
    @ApiStatus.Internal
    public static final ModConfigSpec SPEC;
    public static final NeoForgeClientConfig INSTANCE;
    public final ModConfigSpec.BooleanValue experimentalForgeLightPipelineEnabled;
    boolean experimentalPipelineActive;
    public final ModConfigSpec.BooleanValue showLoadWarnings;
    public final ModConfigSpec.BooleanValue logUntranslatedConfigurationWarnings;
    public final ModConfigSpec.BooleanValue reducedDepthStencilFormat;

    private NeoForgeClientConfig(ModConfigSpec.Builder builder) {
        this.experimentalForgeLightPipelineEnabled = builder.comment("EXPERIMENTAL: Enable the NeoForge block rendering pipeline - fixes the lighting of custom models.").translation("neoforge.configgui.forgeLightPipelineEnabled").define("experimentalForgeLightPipelineEnabled", false);
        this.showLoadWarnings = builder.comment("When enabled, NeoForge will show any warnings that occurred during loading.").translation("neoforge.configgui.showLoadWarnings").define("showLoadWarnings", true);
        this.logUntranslatedConfigurationWarnings = builder.comment("A config option mainly for developers. Logs out configuration values that do not have translations when running a client in a development environment.").translation("neoforge.configgui.logUntranslatedConfigurationWarnings").define("logUntranslatedConfigurationWarnings", true);
        this.reducedDepthStencilFormat = builder.comment("Configures how many bits are used for the depth buffer when stenciling has been enabled by a mod. Set to true for 24+8 bits and to false for 32+8 bits. Setting to true will slightly reduce VRAM usage, but risks introducing visual artifacts.").translation("neoforge.configgui.reducedDepthStencilFormat").define("reducedDepthStencilFormat", false);
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == SPEC) {
            NeoForgeClientConfig.INSTANCE.experimentalPipelineActive = NeoForgeClientConfig.INSTANCE.experimentalForgeLightPipelineEnabled.getAsBoolean();
        }
    }

    @SubscribeEvent
    static void onFileChange(ModConfigEvent.Reloading configEvent) {
        boolean experimentalPipelineActive;
        if (configEvent.getConfig().getSpec() == SPEC && (experimentalPipelineActive = NeoForgeClientConfig.INSTANCE.experimentalForgeLightPipelineEnabled.getAsBoolean()) != NeoForgeClientConfig.INSTANCE.experimentalPipelineActive) {
            NeoForgeClientConfig.INSTANCE.experimentalPipelineActive = experimentalPipelineActive;
            ClientHooks.reloadRenderer();
        }
    }

    static {
        Pair<NeoForgeClientConfig, ModConfigSpec> specPair = new ModConfigSpec.Builder().configure(NeoForgeClientConfig::new);
        SPEC = (ModConfigSpec)specPair.getRight();
        INSTANCE = (NeoForgeClientConfig)specPair.getLeft();
    }
}

