/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.world.chunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.TicketStorage;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.common.world.chunk.TicketHelper;
import net.neoforged.neoforge.common.world.chunk.TicketSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ForcedChunkManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean initialised = false;
    private static Map<ResourceLocation, TicketController> controllers = Map.of();

    @ApiStatus.Internal
    public static synchronized void init() {
        if (initialised) {
            throw new UnsupportedOperationException("Cannot init ticket controllers multiple times!");
        }
        initialised = true;
        HashMap controllers = new HashMap();
        ModLoader.postEvent((Event)new RegisterTicketControllersEvent(controller -> {
            if (controllers.containsKey(controller.id())) {
                throw new IllegalArgumentException("Attempted to register two controllers with the same ID " + String.valueOf(controller.id()));
            }
            controllers.put(controller.id(), controller);
        }));
        ForcedChunkManager.controllers = Map.copyOf(controllers);
    }

    public static boolean hasForcedChunks(ServerLevel level) {
        TicketStorage data = (TicketStorage)level.getDataStorage().get(TicketStorage.TYPE);
        if (data == null) {
            return false;
        }
        return !data.getForceLoadedChunks().isEmpty() || !data.getBlockForcedChunks().isEmpty() || !data.getEntityForcedChunks().isEmpty();
    }

    static <T extends Comparable<? super T>> boolean forceChunk(ServerLevel level, ResourceLocation id, T owner, int chunkX, int chunkZ, boolean add, boolean forceNaturalSpawning, Function<TicketStorage, TicketTracker<T>> ticketGetter) {
        if (!controllers.containsKey(id)) {
            throw new IllegalArgumentException("Controller with ID " + String.valueOf(id) + " is not registered!");
        }
        TicketStorage saveData = (TicketStorage)level.getDataStorage().computeIfAbsent(TicketStorage.TYPE);
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        long chunk = pos.toLong();
        TicketTracker<T> tickets = ticketGetter.apply(saveData);
        TicketOwner<T> ticketOwner = new TicketOwner<T>(id, owner);
        if (add) {
            boolean success = tickets.add(ticketOwner, chunk, forceNaturalSpawning);
            if (success) {
                level.getChunk(chunkX, chunkZ);
            }
            return success;
        }
        return tickets.remove(ticketOwner, chunk, forceNaturalSpawning, false);
    }

    @ApiStatus.Internal
    public static void activateAllDeactivatedTickets(ServerLevel level, TicketStorage saveData) {
        TicketTracker blockForcedChunks = saveData.getBlockForcedChunks();
        TicketTracker entityForcedChunks = saveData.getEntityForcedChunks();
        if (blockForcedChunks.hasNoDeactivatedTickets() && entityForcedChunks.hasNoDeactivatedTickets()) {
            return;
        }
        List<Map.Entry> controllers = ForcedChunkManager.controllers.entrySet().stream().filter(c -> ((TicketController)c.getValue()).callback() != null).toList();
        if (!controllers.isEmpty()) {
            Map blockTickets = ForcedChunkManager.gatherTicketsById(blockForcedChunks, false, true);
            Map entityTickets = ForcedChunkManager.gatherTicketsById(entityForcedChunks, false, true);
            controllers.forEach(value -> {
                boolean hasBlockTicket = blockTickets.containsKey(value.getKey());
                boolean hasEntityTicket = entityTickets.containsKey(value.getKey());
                if (hasBlockTicket || hasEntityTicket) {
                    Map<BlockPos, TicketSet> ownedBlockTickets = hasBlockTicket ? Collections.unmodifiableMap((Map)blockTickets.get(value.getKey())) : Collections.emptyMap();
                    Map<UUID, TicketSet> ownedEntityTickets = hasEntityTicket ? Collections.unmodifiableMap((Map)entityTickets.get(value.getKey())) : Collections.emptyMap();
                    ((TicketController)value.getValue()).callback().validateTickets(level, new TicketHelper(saveData, (ResourceLocation)value.getKey(), ownedBlockTickets, ownedEntityTickets));
                }
            });
        }
        blockForcedChunks.activateAllDeactivatedSources();
        entityForcedChunks.activateAllDeactivatedSources();
    }

    private static <T extends Comparable<? super T>> Map<ResourceLocation, Map<T, TicketSet>> gatherTicketsById(TicketTracker<T> tickets, boolean includeLoaded, boolean includeDeactivated) {
        HashMap<ResourceLocation, Map<T, TicketSet>> modSortedOwnedChunks = new HashMap<ResourceLocation, Map<T, TicketSet>>();
        if (includeLoaded) {
            ForcedChunkManager.gatherTicketsById(tickets.sourcesLoading, TicketSet::normal, modSortedOwnedChunks);
            ForcedChunkManager.gatherTicketsById(tickets.sourcesLoadingNaturalSpawning, TicketSet::naturalSpawning, modSortedOwnedChunks);
        }
        if (includeDeactivated) {
            ForcedChunkManager.gatherTicketsById(tickets.deactivatedSourcesLoading, TicketSet::normal, modSortedOwnedChunks);
            ForcedChunkManager.gatherTicketsById(tickets.deactivatedSourcesLoadingNaturalSpawning, TicketSet::naturalSpawning, modSortedOwnedChunks);
        }
        return modSortedOwnedChunks;
    }

    private static <T extends Comparable<? super T>> void gatherTicketsById(Long2ObjectMap<Set<TicketOwner<T>>> tickets, Function<TicketSet, LongSet> typeGetter, Map<ResourceLocation, Map<T, TicketSet>> modSortedOwnedChunks) {
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(tickets)) {
            long chunk = entry.getLongKey();
            Set owners = (Set)entry.getValue();
            for (TicketOwner owner : owners) {
                TicketSet pair = modSortedOwnedChunks.computeIfAbsent(owner.id, modId -> new HashMap()).computeIfAbsent(owner.owner, o -> new TicketSet((LongSet)new LongOpenHashSet(), (LongSet)new LongOpenHashSet()));
                typeGetter.apply(pair).add(chunk);
            }
        }
    }

    @ApiStatus.Internal
    public static App<RecordCodecBuilder.Mu<TicketStorage>, List<OwnedChunks>> defineExtraStorageParams() {
        return OwnedChunks.CODEC.listOf().optionalFieldOf("neo_ticket_data", List.of()).forGetter(storage -> {
            ResourceLocation controllerId;
            Map blockTickets = ForcedChunkManager.gatherTicketsById(storage.getBlockForcedChunks(), true, true);
            Map entityTickets = ForcedChunkManager.gatherTicketsById(storage.getEntityForcedChunks(), true, true);
            HashMap<ResourceLocation, OwnedChunks> ownedChunks = new HashMap<ResourceLocation, OwnedChunks>();
            for (Map.Entry entry : blockTickets.entrySet()) {
                controllerId = entry.getKey();
                ownedChunks.put(controllerId, new OwnedChunks(controllerId, entry.getValue(), new HashMap<UUID, TicketSet>()));
            }
            for (Map.Entry entry : entityTickets.entrySet()) {
                controllerId = entry.getKey();
                OwnedChunks owned = (OwnedChunks)ownedChunks.get(controllerId);
                if (owned == null) {
                    ownedChunks.put(controllerId, new OwnedChunks(controllerId, new HashMap<BlockPos, TicketSet>(), entry.getValue()));
                    continue;
                }
                owned.entityChunks().putAll(entry.getValue());
            }
            return List.copyOf(ownedChunks.values());
        });
    }

    @ApiStatus.Internal
    public static TicketStorage readStoredTickets(Function<List<Pair<ChunkPos, Ticket>>, TicketStorage> vanillaInitializer, List<Pair<ChunkPos, Ticket>> tickets, List<OwnedChunks> ownedChunks) {
        TicketStorage ticketStorage = vanillaInitializer.apply(tickets);
        TicketTracker blockForcedChunks = ticketStorage.getBlockForcedChunks();
        TicketTracker entityForcedChunks = ticketStorage.getEntityForcedChunks();
        for (OwnedChunks ownedChunk : ownedChunks) {
            ResourceLocation controllerId = ownedChunk.controller();
            if (controllers.containsKey(controllerId)) {
                for (Map.Entry<BlockPos, TicketSet> entry : ownedChunk.blockChunks().entrySet()) {
                    blockForcedChunks.inheritDeactivated(new TicketOwner<BlockPos>(controllerId, entry.getKey()), entry.getValue());
                }
                for (Map.Entry<Object, TicketSet> entry : ownedChunk.entityChunks().entrySet()) {
                    entityForcedChunks.inheritDeactivated(new TicketOwner<UUID>(controllerId, (UUID)entry.getKey()), entry.getValue());
                }
                continue;
            }
            LOGGER.warn("Found chunk loading data for controller id {} which is currently not available or active - it will be removed from the level save.", (Object)controllerId);
        }
        return ticketStorage;
    }

    public static class TicketTracker<T extends Comparable<? super T>> {
        private final Long2ObjectMap<Set<TicketOwner<T>>> sourcesLoading = new Long2ObjectOpenHashMap();
        private final Long2ObjectMap<Set<TicketOwner<T>>> sourcesLoadingNaturalSpawning = new Long2ObjectOpenHashMap();
        private final Long2ObjectMap<Set<TicketOwner<T>>> deactivatedSourcesLoading = new Long2ObjectOpenHashMap();
        private final Long2ObjectMap<Set<TicketOwner<T>>> deactivatedSourcesLoadingNaturalSpawning = new Long2ObjectOpenHashMap();
        private final Holder<TicketType> naturalSpawningTicketType;
        private final Holder<TicketType> ticketType;
        private final TicketStorage ticketStorage;

        public TicketTracker(TicketStorage ticketStorage, Holder<TicketType> ticketType, Holder<TicketType> naturalSpawningTicketType) {
            this.ticketStorage = ticketStorage;
            this.ticketType = ticketType;
            this.naturalSpawningTicketType = naturalSpawningTicketType;
        }

        public void deactivateTicketsOnClosing() {
            this.inheritSources(null, this.sourcesLoading, this.deactivatedSourcesLoading);
            this.inheritSources(null, this.sourcesLoadingNaturalSpawning, this.deactivatedSourcesLoadingNaturalSpawning);
        }

        private void inheritDeactivated(TicketOwner<T> owner, TicketSet ticketSet) {
            long chunk;
            LongIterator longIterator = ticketSet.normal().iterator();
            while (longIterator.hasNext()) {
                chunk = (Long)longIterator.next();
                ((Set)this.deactivatedSourcesLoading.computeIfAbsent(chunk, c -> new HashSet())).add(owner);
            }
            longIterator = ticketSet.naturalSpawning().iterator();
            while (longIterator.hasNext()) {
                chunk = (Long)longIterator.next();
                ((Set)this.deactivatedSourcesLoadingNaturalSpawning.computeIfAbsent(chunk, c -> new HashSet())).add(owner);
            }
        }

        private void activateAllDeactivatedSources() {
            this.inheritSources(this.ticketType, this.deactivatedSourcesLoading, this.sourcesLoading);
            this.inheritSources(this.naturalSpawningTicketType, this.deactivatedSourcesLoadingNaturalSpawning, this.sourcesLoadingNaturalSpawning);
        }

        private void inheritSources(@Nullable Holder<TicketType> ticketType, Long2ObjectMap<Set<TicketOwner<T>>> fromSource, Long2ObjectMap<Set<TicketOwner<T>>> toSource) {
            Ticket ticket = ticketType == null ? null : new Ticket((TicketType)ticketType.value(), ChunkMap.FORCED_TICKET_LEVEL);
            for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(fromSource)) {
                long chunk = entry.getLongKey();
                if (ticket != null) {
                    this.ticketStorage.addTicket(entry.getLongKey(), ticket);
                }
                ((Set)toSource.computeIfAbsent(chunk, c -> new HashSet())).addAll((Collection)entry.getValue());
            }
            fromSource.clear();
        }

        public boolean hasNoDeactivatedTickets() {
            return this.deactivatedSourcesLoading.isEmpty() && this.deactivatedSourcesLoadingNaturalSpawning.isEmpty();
        }

        public boolean isEmpty() {
            return this.sourcesLoading.isEmpty() && this.sourcesLoadingNaturalSpawning.isEmpty();
        }

        private Long2ObjectMap<Set<TicketOwner<T>>> getSourcesLoading(boolean forceNaturalSpawning, boolean targetDeactivated) {
            if (targetDeactivated) {
                return forceNaturalSpawning ? this.deactivatedSourcesLoadingNaturalSpawning : this.deactivatedSourcesLoading;
            }
            return forceNaturalSpawning ? this.sourcesLoadingNaturalSpawning : this.sourcesLoading;
        }

        private Ticket makeTicket(boolean forceNaturalSpawning) {
            Holder<TicketType> type = forceNaturalSpawning ? this.naturalSpawningTicketType : this.ticketType;
            return new Ticket((TicketType)type.value(), ChunkMap.FORCED_TICKET_LEVEL);
        }

        public boolean remove(TicketOwner<T> owner, long chunk, boolean forceNaturalSpawning, boolean targetDeactivated) {
            Long2ObjectMap<Set<TicketOwner<T>>> sourcesLoading = this.getSourcesLoading(forceNaturalSpawning, targetDeactivated);
            Set sources = (Set)sourcesLoading.get(chunk);
            if (sources != null && sources.remove(owner)) {
                if (sources.isEmpty()) {
                    sourcesLoading.remove(chunk);
                    if (!targetDeactivated) {
                        this.ticketStorage.removeTicket(chunk, this.makeTicket(forceNaturalSpawning));
                    }
                }
                this.ticketStorage.setDirty();
                return true;
            }
            return false;
        }

        private boolean add(TicketOwner<T> owner, long chunk, boolean forceNaturalSpawning) {
            Long2ObjectMap<Set<TicketOwner<T>>> sourcesLoading = this.getSourcesLoading(forceNaturalSpawning, false);
            Set sources = (Set)sourcesLoading.computeIfAbsent(chunk, c -> new HashSet());
            if (sources.isEmpty()) {
                this.ticketStorage.addTicket(chunk, this.makeTicket(forceNaturalSpawning));
            }
            if (sources.add(owner)) {
                this.ticketStorage.setDirty();
                return true;
            }
            return false;
        }
    }

    static class TicketOwner<T extends Comparable<? super T>>
    implements Comparable<TicketOwner<T>> {
        private final ResourceLocation id;
        private final T owner;

        TicketOwner(ResourceLocation id, T owner) {
            this.id = id;
            this.owner = owner;
        }

        @Override
        public int compareTo(TicketOwner<T> other) {
            int res = this.id.compareTo(other.id);
            return res == 0 ? this.owner.compareTo(other.owner) : res;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TicketOwner that = (TicketOwner)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.owner, that.owner);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.owner);
        }
    }

    public record OwnedChunks(ResourceLocation controller, Map<BlockPos, TicketSet> blockChunks, Map<UUID, TicketSet> entityChunks) {
        private static final Codec<Map<BlockPos, TicketSet>> BLOCK_CHUNK_CODEC = Codec.unboundedMap((Codec)BlockPos.CODEC, TicketSet.CODEC);
        private static final Codec<Map<UUID, TicketSet>> ENTITY_CHUNK_CODEC = Codec.unboundedMap((Codec)UUIDUtil.CODEC, TicketSet.CODEC);
        public static final Codec<OwnedChunks> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("controller").forGetter(OwnedChunks::controller), (App)BLOCK_CHUNK_CODEC.optionalFieldOf("block_chunks", Map.of()).forGetter(OwnedChunks::blockChunks), (App)ENTITY_CHUNK_CODEC.optionalFieldOf("entity_chunks", Map.of()).forGetter(OwnedChunks::entityChunks)).apply((Applicative)instance, OwnedChunks::new));
    }
}

