/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class SelfTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfTest.class);

    private SelfTest() {
    }

    public static void initCommon() {
        String serverSelfTestDestination = System.getenv("NEOFORGE_DEDICATED_SERVER_SELFTEST");
        if (serverSelfTestDestination != null) {
            if (FMLLoader.getDist() != Dist.DEDICATED_SERVER) {
                LOGGER.error("The server self-test ran with a dist of {} instead of dedicated server!", (Object)FMLLoader.getDist());
                System.exit(1);
            }
            NeoForge.EVENT_BUS.addListener(e -> {
                if (e.getServer().isRunning()) {
                    SelfTest.writeSelfTestReport(serverSelfTestDestination);
                    e.getServer().halt(false);
                }
            });
        }
    }

    public static void writeSelfTestReport(String path) {
        try {
            Files.createFile(Paths.get(path, new String[0]), new FileAttribute[0]);
            LOGGER.info("Wrote self-test report to '{}'", (Object)path);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write self-test to '{}'", (Object)path, (Object)e);
            System.exit(1);
        }
    }
}

