/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.generators.template;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Quadrant;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Map;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.client.model.ExtraFaceData;
import net.neoforged.neoforge.client.model.generators.template.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.template.ElementBuilder;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplateBuilder;
import net.neoforged.neoforge.client.model.generators.template.RootTransformsBuilder;
import net.neoforged.neoforge.client.model.generators.template.TransformVecBuilder;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public final class ExtendedModelTemplate
extends ModelTemplate {
    final Map<ItemDisplayContext, TransformVecBuilder> transforms;
    final List<ElementBuilder> elements;
    @Nullable
    final CustomLoaderBuilder customLoader;
    final RootTransformsBuilder rootTransforms;
    @Nullable
    final ResourceLocation renderType;
    @Nullable
    final Boolean ambientOcclusion;
    @Nullable
    final UnbakedModel.GuiLight guiLight;

    ExtendedModelTemplate(ExtendedModelTemplateBuilder builder) {
        super(builder.parent, builder.suffix, (TextureSlot[])builder.requiredSlots.toArray(TextureSlot[]::new));
        this.transforms = Map.copyOf(builder.transforms);
        this.elements = List.copyOf(builder.elements);
        this.customLoader = builder.customLoader;
        this.rootTransforms = builder.rootTransforms;
        this.renderType = builder.renderType;
        this.ambientOcclusion = builder.ambientOcclusion;
        this.guiLight = builder.guiLight;
    }

    public JsonObject createBaseTemplate(ResourceLocation modelPath, Map<TextureSlot, ResourceLocation> textureMap) {
        JsonObject transform;
        JsonObject root = super.createBaseTemplate(modelPath, textureMap);
        if (this.ambientOcclusion != null) {
            root.addProperty("ambientocclusion", this.ambientOcclusion);
        }
        if (this.guiLight != null) {
            root.addProperty("gui_light", this.guiLight.getSerializedName());
        }
        if (this.renderType != null) {
            root.addProperty("render_type", this.renderType.toString());
        }
        if (!this.transforms.isEmpty()) {
            JsonObject display = new JsonObject();
            for (Map.Entry<ItemDisplayContext, TransformVecBuilder> e : this.transforms.entrySet()) {
                boolean hasRightRotation;
                JsonObject transform2 = new JsonObject();
                ItemTransform vec = e.getValue().build();
                if (vec.equals((Object)ItemTransform.NO_TRANSFORM)) continue;
                boolean bl = hasRightRotation = !vec.rightRotation().equals((Object)ItemTransform.Deserializer.DEFAULT_ROTATION);
                if (!vec.translation().equals((Object)ItemTransform.Deserializer.DEFAULT_TRANSLATION)) {
                    transform2.add("translation", (JsonElement)ExtendedModelTemplate.serializeVector3f(vec.translation()));
                }
                if (!vec.rotation().equals((Object)ItemTransform.Deserializer.DEFAULT_ROTATION)) {
                    transform2.add(hasRightRotation ? "left_rotation" : "rotation", (JsonElement)ExtendedModelTemplate.serializeVector3f(vec.rotation()));
                }
                if (!vec.scale().equals((Object)ItemTransform.Deserializer.DEFAULT_SCALE)) {
                    transform2.add("scale", (JsonElement)ExtendedModelTemplate.serializeVector3f(vec.scale()));
                }
                if (hasRightRotation) {
                    transform2.add("right_rotation", (JsonElement)ExtendedModelTemplate.serializeVector3f(vec.rightRotation()));
                }
                display.add(e.getKey().getSerializedName(), (JsonElement)transform2);
            }
            root.add("display", (JsonElement)display);
        }
        if (!this.elements.isEmpty()) {
            JsonArray elements = new JsonArray();
            this.elements.stream().map(ElementBuilder::build).forEach(part -> {
                JsonObject partObj = new JsonObject();
                partObj.add("from", (JsonElement)ExtendedModelTemplate.serializeVector3f(part.from()));
                partObj.add("to", (JsonElement)ExtendedModelTemplate.serializeVector3f(part.to()));
                if (part.rotation() != null) {
                    JsonObject rotation = new JsonObject();
                    rotation.add("origin", (JsonElement)ExtendedModelTemplate.serializeVector3f((Vector3fc)part.rotation().origin()));
                    rotation.addProperty("axis", part.rotation().axis().getSerializedName());
                    rotation.addProperty("angle", (Number)Float.valueOf(part.rotation().angle()));
                    if (part.rotation().rescale()) {
                        rotation.addProperty("rescale", Boolean.valueOf(true));
                    }
                    partObj.add("rotation", (JsonElement)rotation);
                }
                if (!part.shade()) {
                    partObj.addProperty("shade", Boolean.valueOf(false));
                }
                if (part.lightEmission() != 0) {
                    partObj.addProperty("light_emission", (Number)part.lightEmission());
                }
                if (!part.faceData().equals(ExtraFaceData.DEFAULT)) {
                    partObj.add("neoforge_data", (JsonElement)ExtraFaceData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)part.faceData()).result().get());
                }
                JsonObject faces = new JsonObject();
                for (Direction dir : Direction.values()) {
                    BlockElementFace face = (BlockElementFace)part.faces().get(dir);
                    if (face == null) continue;
                    JsonObject faceObj = new JsonObject();
                    faceObj.addProperty("texture", ExtendedModelTemplate.serializeLocOrKey(face.texture()));
                    BlockElementFace.UVs uvs = face.uvs();
                    if (uvs != null && !uvs.equals((Object)FaceBakery.defaultFaceUV((Vector3fc)part.from(), (Vector3fc)part.to(), (Direction)dir))) {
                        JsonArray uvArr = new JsonArray();
                        uvArr.add((Number)Float.valueOf(uvs.minU()));
                        uvArr.add((Number)Float.valueOf(uvs.minV()));
                        uvArr.add((Number)Float.valueOf(uvs.maxU()));
                        uvArr.add((Number)Float.valueOf(uvs.maxV()));
                        faceObj.add("uv", (JsonElement)uvArr);
                    }
                    if (face.cullForDirection() != null) {
                        faceObj.addProperty("cullface", face.cullForDirection().getSerializedName());
                    }
                    if (face.rotation() != Quadrant.R0) {
                        faceObj.addProperty("rotation", (Number)(face.rotation().shift * 90));
                    }
                    if (face.tintIndex() != -1) {
                        faceObj.addProperty("tintindex", (Number)face.tintIndex());
                    }
                    if (!face.faceData().equals(ExtraFaceData.DEFAULT)) {
                        faceObj.add("neoforge_data", (JsonElement)ExtraFaceData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)face.faceData()).result().orElseThrow());
                    }
                    faces.add(dir.getSerializedName(), (JsonElement)faceObj);
                }
                if (!part.faces().isEmpty()) {
                    partObj.add("faces", (JsonElement)faces);
                }
                elements.add((JsonElement)partObj);
            });
            root.add("elements", (JsonElement)elements);
        }
        if (!(transform = this.rootTransforms.toJson()).isEmpty()) {
            root.add("transform", (JsonElement)transform);
        }
        if (this.customLoader != null) {
            return this.customLoader.toJson(root);
        }
        return root;
    }

    private static String serializeLocOrKey(String tex) {
        if (tex.charAt(0) == '#') {
            return tex;
        }
        return ResourceLocation.parse((String)tex).toString();
    }

    private static JsonArray serializeVector3f(Vector3fc vec) {
        JsonArray ret = new JsonArray();
        ret.add(ExtendedModelTemplate.serializeFloat(vec.x()));
        ret.add(ExtendedModelTemplate.serializeFloat(vec.y()));
        ret.add(ExtendedModelTemplate.serializeFloat(vec.z()));
        return ret;
    }

    private static Number serializeFloat(float f) {
        if ((float)((int)f) == f) {
            return (int)f;
        }
        return Float.valueOf(f);
    }
}

