/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;

public class AddSectionGeometryEvent
extends Event {
    private final List<AdditionalSectionRenderer> additionalRenderers = new ArrayList<AdditionalSectionRenderer>();
    private final BlockPos sectionOrigin;
    private final Level level;

    public AddSectionGeometryEvent(BlockPos sectionOrigin, Level level) {
        this.sectionOrigin = sectionOrigin;
        this.level = level;
    }

    public void addRenderer(AdditionalSectionRenderer renderer) {
        this.additionalRenderers.add(renderer);
    }

    public List<AdditionalSectionRenderer> getAdditionalRenderers() {
        return this.additionalRenderers;
    }

    public BlockPos getSectionOrigin() {
        return this.sectionOrigin;
    }

    public Level getLevel() {
        Preconditions.checkState((boolean)Minecraft.getInstance().isSameThread());
        return this.level;
    }

    public static final class SectionRenderingContext {
        private final Function<RenderType, VertexConsumer> getOrCreateLayer;
        private final BlockAndTintGetter region;
        private final PoseStack poseStack;

        public SectionRenderingContext(Function<RenderType, VertexConsumer> getOrCreateLayer, BlockAndTintGetter region, PoseStack poseStack) {
            this.getOrCreateLayer = getOrCreateLayer;
            this.region = region;
            this.poseStack = poseStack;
        }

        public VertexConsumer getOrCreateChunkBuffer(RenderType type) {
            Preconditions.checkArgument((type.getChunkLayerId() != -1 ? 1 : 0) != 0, (Object)"Cannot create a chunk render buffer for a non-chunk render type");
            return this.getOrCreateLayer.apply(type);
        }

        public PoseStack getPoseStack() {
            return this.poseStack;
        }

        public BlockAndTintGetter getRegion() {
            return this.region;
        }
    }

    @FunctionalInterface
    public static interface AdditionalSectionRenderer {
        public void render(SectionRenderingContext var1);
    }
}

