/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data.internal;

import java.util.Locale;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.apache.commons.lang3.StringUtils;

public final class NeoForgeLanguageProvider
extends LanguageProvider {
    public NeoForgeLanguageProvider(PackOutput gen) {
        super(gen, "c", "en_us");
    }

    @Override
    protected void addTranslations() {
        this.addDimension((ResourceKey<Level>)Level.OVERWORLD, "Overworld");
        this.addDimension((ResourceKey<Level>)Level.NETHER, "The Nether");
        this.addDimension((ResourceKey<Level>)Level.END, "The End");
        this.add(Tags.Blocks.BARRELS, "Barrels");
        this.add(Tags.Blocks.BARRELS_WOODEN, "Wooden Barrels");
        this.add(Tags.Blocks.BOOKSHELVES, "Bookshelves");
        this.add(Tags.Blocks.BUDDING_BLOCKS, "Budding Blocks");
        this.add(Tags.Blocks.BUDS, "Buds");
        this.add(Tags.Blocks.CHAINS, "Chains");
        this.add(Tags.Blocks.CHESTS, "Chests");
        this.add(Tags.Blocks.CHESTS_ENDER, "Ender Chests");
        this.add(Tags.Blocks.CHESTS_TRAPPED, "Trapped Chests");
        this.add(Tags.Blocks.CHESTS_WOODEN, "Wooden Chests");
        this.add(Tags.Blocks.CLUSTERS, "Clusters");
        this.add(Tags.Blocks.COBBLESTONES, "Cobblestones");
        this.add(Tags.Blocks.COBBLESTONES_NORMAL, "Normal Cobblestones");
        this.add(Tags.Blocks.COBBLESTONES_INFESTED, "Infested Cobblestones");
        this.add(Tags.Blocks.COBBLESTONES_MOSSY, "Mossy Cobblestones");
        this.add(Tags.Blocks.COBBLESTONES_DEEPSLATE, "Deepslate Cobblestones");
        this.add(Tags.Blocks.CONCRETES, "Concretes");
        this.add(Tags.Blocks.DYED, "Dyed Blocks");
        this.addColored(Tags.Blocks.DYED, "{color} Dyed Blocks");
        this.add(Tags.Blocks.END_STONES, "End Stones");
        this.add(Tags.Blocks.ENDERMAN_PLACE_ON_BLACKLIST, "Enderman Place On Blacklist");
        this.add(Tags.Blocks.FENCE_GATES, "Fence Gates");
        this.add(Tags.Blocks.FENCE_GATES_WOODEN, "Wooden Fence Gates");
        this.add(Tags.Blocks.FENCES, "Fences");
        this.add(Tags.Blocks.FENCES_NETHER_BRICK, "Nether Brick Fences");
        this.add(Tags.Blocks.FENCES_WOODEN, "Wooden Fences");
        this.add(Tags.Blocks.FLOWERS_SMALL, "Small Flowers");
        this.add(Tags.Blocks.FLOWERS_TALL, "Tall Flowers");
        this.add(Tags.Blocks.FLOWERS, "Flowers");
        this.add(Tags.Blocks.GLASS_BLOCKS, "Glass Blocks");
        this.add(Tags.Blocks.GLASS_BLOCKS_COLORLESS, "Colorless Glass Blocks");
        this.add(Tags.Blocks.GLASS_BLOCKS_CHEAP, "Silica Glass Blocks");
        this.add(Tags.Blocks.GLASS_BLOCKS_TINTED, "Tinted Glass Blocks");
        this.add(Tags.Blocks.GLASS_PANES, "Glass Panes");
        this.add(Tags.Blocks.GLASS_PANES_COLORLESS, "Colorless Glass Panes");
        this.add(Tags.Blocks.GLAZED_TERRACOTTAS, "Glazed Terracottas");
        this.add(Tags.Blocks.GRAVELS, "Gravels");
        this.add(Tags.Blocks.SKULLS, "Skulls");
        this.add(Tags.Blocks.HIDDEN_FROM_RECIPE_VIEWERS, "Hidden From Recipe Viewers");
        this.add(Tags.Blocks.NETHERRACKS, "Netherracks");
        this.add(Tags.Blocks.NEEDS_WOOD_TOOL, "Needs Wooden Tools");
        this.add(Tags.Blocks.NEEDS_GOLD_TOOL, "Needs Gold Tools");
        this.add(Tags.Blocks.NEEDS_NETHERITE_TOOL, "Needs Netherite Tools");
        this.add(Tags.Blocks.OBSIDIANS, "Obsidians");
        this.add(Tags.Blocks.OBSIDIANS_NORMAL, "Normal Obsidians");
        this.add(Tags.Blocks.OBSIDIANS_CRYING, "Crying Obsidians");
        this.add(Tags.Blocks.ORE_BEARING_GROUND_DEEPSLATE, "Deepslate Ore Bearing Ground");
        this.add(Tags.Blocks.ORE_BEARING_GROUND_NETHERRACK, "Netherrack Ore Bearing Ground");
        this.add(Tags.Blocks.ORE_BEARING_GROUND_STONE, "Stone Ore Bearing Ground");
        this.add(Tags.Blocks.ORE_RATES_DENSE, "Dense Ore Rates");
        this.add(Tags.Blocks.ORE_RATES_SINGULAR, "Singular Ore Rates");
        this.add(Tags.Blocks.ORE_RATES_SPARSE, "Sparse Ore Rates");
        this.add(Tags.Blocks.ORES, "Ores");
        this.add(Tags.Blocks.ORES_COAL, "Coal Ores");
        this.add(Tags.Blocks.ORES_COPPER, "Copper Ores");
        this.add(Tags.Blocks.ORES_DIAMOND, "Diamond Ores");
        this.add(Tags.Blocks.ORES_EMERALD, "Emerald Ores");
        this.add(Tags.Blocks.ORES_GOLD, "Gold Ores");
        this.add(Tags.Blocks.ORES_IRON, "Iron Ores");
        this.add(Tags.Blocks.ORES_LAPIS, "Lapis Ores");
        this.add(Tags.Blocks.ORES_QUARTZ, "Quartz Ores");
        this.add(Tags.Blocks.ORES_REDSTONE, "Redstone Ores");
        this.add(Tags.Blocks.ORES_NETHERITE_SCRAP, "Netherite Scrap Ores");
        this.add(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE, "Deepslate Ores In Ground");
        this.add(Tags.Blocks.ORES_IN_GROUND_NETHERRACK, "Netherrack Ores In Ground");
        this.add(Tags.Blocks.ORES_IN_GROUND_STONE, "Stone Ores In Ground");
        this.add(Tags.Blocks.PLAYER_WORKSTATIONS_CRAFTING_TABLES, "Crafting Tables");
        this.add(Tags.Blocks.PLAYER_WORKSTATIONS_FURNACES, "Furnaces");
        this.add(Tags.Blocks.RELOCATION_NOT_SUPPORTED, "Relocation Not Supported");
        this.add(Tags.Blocks.ROPES, "Ropes");
        this.add(Tags.Blocks.SANDS, "Sands");
        this.add(Tags.Blocks.SANDS_COLORLESS, "Colorless Sands");
        this.add(Tags.Blocks.SANDS_RED, "Red Sands");
        this.add(Tags.Blocks.SANDSTONE_BLOCKS, "Sandstone Blocks");
        this.add(Tags.Blocks.SANDSTONE_SLABS, "Sandstone Slabs");
        this.add(Tags.Blocks.SANDSTONE_STAIRS, "Sandstone Stairs");
        this.add(Tags.Blocks.SANDSTONE_RED_BLOCKS, "Red Sandstone Blocks");
        this.add(Tags.Blocks.SANDSTONE_RED_SLABS, "Red Sandstone Slabs");
        this.add(Tags.Blocks.SANDSTONE_RED_STAIRS, "Red Sandstone Stairs");
        this.add(Tags.Blocks.SANDSTONE_UNCOLORED_BLOCKS, "Uncolored Sandstone Blocks");
        this.add(Tags.Blocks.SANDSTONE_UNCOLORED_SLABS, "Uncolored Sandstone Slabs");
        this.add(Tags.Blocks.SANDSTONE_UNCOLORED_STAIRS, "Uncolored Sandstone Stairs");
        this.add(Tags.Blocks.STONES, "Stones");
        this.add(Tags.Blocks.STORAGE_BLOCKS, "Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_BONE_MEAL, "Bone Meal Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_COAL, "Coal Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_COPPER, "Copper Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_DIAMOND, "Diamond Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_DRIED_KELP, "Dried Kelp Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_EMERALD, "Emerald Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_GOLD, "Gold Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_IRON, "Iron Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_LAPIS, "Lapis Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_NETHERITE, "Netherite Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_RAW_COPPER, "Raw Copper Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_RAW_GOLD, "Raw Gold Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_RAW_IRON, "Raw Iron Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_REDSTONE, "Redstone Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_RESIN, "Resin Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_SLIME, "Slime Storage Blocks");
        this.add(Tags.Blocks.STORAGE_BLOCKS_WHEAT, "Wheat Storage Blocks");
        this.add(Tags.Blocks.STRIPPED_LOGS, "Stripped Logs");
        this.add(Tags.Blocks.STRIPPED_WOODS, "Stripped Woods");
        this.add(Tags.Blocks.VILLAGER_JOB_SITES, "Villager Job Sites");
        this.add(Tags.Blocks.VILLAGER_FARMLANDS, "Villager Farmlands");
        this.add(Tags.Items.BARRELS, "Barrels");
        this.add(Tags.Items.BARRELS_WOODEN, "Wooden Barrels");
        this.add(Tags.Items.BONES, "Bones");
        this.add(Tags.Items.BOOKSHELVES, "Bookshelves");
        this.add(Tags.Items.BRICKS, "Bricks");
        this.add(Tags.Items.BRICKS_NORMAL, "Normal Bricks");
        this.add(Tags.Items.BRICKS_NETHER, "Nether Bricks");
        this.add(Tags.Items.BRICKS_RESIN, "Resin Bricks");
        this.add(Tags.Items.BUCKETS, "Buckets");
        this.add(Tags.Items.BUCKETS_EMPTY, "Empty Buckets");
        this.add(Tags.Items.BUCKETS_WATER, "Water Buckets");
        this.add(Tags.Items.BUCKETS_LAVA, "Lava Buckets");
        this.add(Tags.Items.BUCKETS_MILK, "Milk Buckets");
        this.add(Tags.Items.BUCKETS_POWDER_SNOW, "Powder Snow Buckets");
        this.add(Tags.Items.BUCKETS_ENTITY_WATER, "Water Entity Buckets");
        this.add(Tags.Items.BUDDING_BLOCKS, "Budding Blocks");
        this.add(Tags.Items.BUDS, "Buds");
        this.add(Tags.Items.CHAINS, "Chains");
        this.add(Tags.Items.CHESTS, "Chests");
        this.add(Tags.Items.CHESTS_ENDER, "Ender Chests");
        this.add(Tags.Items.CHESTS_TRAPPED, "Trapped Chests");
        this.add(Tags.Items.CHESTS_WOODEN, "Wooden Chests");
        this.add(Tags.Items.CLUSTERS, "Clusters");
        this.add(Tags.Items.CLUMPS, "Clumps");
        this.add(Tags.Items.CLUMPS_RESIN, "Resin Clumps");
        this.add(Tags.Items.COBBLESTONES, "Cobblestones");
        this.add(Tags.Items.COBBLESTONES_NORMAL, "Normal Cobblestones");
        this.add(Tags.Items.COBBLESTONES_INFESTED, "Infested Cobblestones");
        this.add(Tags.Items.COBBLESTONES_MOSSY, "Mossy Cobblestones");
        this.add(Tags.Items.COBBLESTONES_DEEPSLATE, "Deepslate Cobblestones");
        this.add(Tags.Items.CONCRETES, "Concretes");
        this.add(Tags.Items.CONCRETE_POWDERS, "Concrete Powders");
        this.add(Tags.Items.CROPS, "Crops");
        this.add(Tags.Items.CROPS_BEETROOT, "Beetroot Crops");
        this.add(Tags.Items.CROPS_CACTUS, "Cactus Crops");
        this.add(Tags.Items.CROPS_CARROT, "Carrot Crops");
        this.add(Tags.Items.CROPS_COCOA_BEAN, "Cocoa Bean Crops");
        this.add(Tags.Items.CROPS_MELON, "Melon Crops");
        this.add(Tags.Items.CROPS_NETHER_WART, "Nether Wart Crops");
        this.add(Tags.Items.CROPS_POTATO, "Potato Crops");
        this.add(Tags.Items.CROPS_PUMPKIN, "Pumpkin Crops");
        this.add(Tags.Items.CROPS_SUGAR_CANE, "Sugar Cane Crops");
        this.add(Tags.Items.CROPS_WHEAT, "Wheat Crops");
        this.add(Tags.Items.DUSTS, "Dusts");
        this.add(Tags.Items.DUSTS_GLOWSTONE, "Glowstone Dusts");
        this.add(Tags.Items.DUSTS_REDSTONE, "Redstone Dusts");
        this.add(Tags.Items.DYED, "Dyed Items");
        this.addColored(Tags.Items.DYED, "{color} Dyed Items");
        this.add(Tags.Items.DYES, "Dyes");
        this.add(Tags.Items.DYES_BLACK, "Black Dyes");
        this.add(Tags.Items.DYES_RED, "Red Dyes");
        this.add(Tags.Items.DYES_GREEN, "Green Dyes");
        this.add(Tags.Items.DYES_BROWN, "Brown Dyes");
        this.add(Tags.Items.DYES_BLUE, "Blue Dyes");
        this.add(Tags.Items.DYES_PURPLE, "Purple Dyes");
        this.add(Tags.Items.DYES_CYAN, "Cyan Dyes");
        this.add(Tags.Items.DYES_LIGHT_GRAY, "Light Gray Dyes");
        this.add(Tags.Items.DYES_GRAY, "Gray Dyes");
        this.add(Tags.Items.DYES_PINK, "Pink Dyes");
        this.add(Tags.Items.DYES_LIME, "Lime Dyes");
        this.add(Tags.Items.DYES_YELLOW, "Yellow Dyes");
        this.add(Tags.Items.DYES_LIGHT_BLUE, "Light Blue Dyes");
        this.add(Tags.Items.DYES_MAGENTA, "Magenta Dyes");
        this.add(Tags.Items.DYES_ORANGE, "Orange Dyes");
        this.add(Tags.Items.DYES_WHITE, "White Dyes");
        this.add(Tags.Items.EGGS, "Eggs");
        this.add(Tags.Items.ENCHANTING_FUELS, "Enchanting Fuels");
        this.add(Tags.Items.END_STONES, "End Stones");
        this.add(Tags.Items.ENDER_PEARLS, "Ender Pearls");
        this.add(Tags.Items.FEATHERS, "Feathers");
        this.add(Tags.Items.FENCE_GATES, "Fence Gates");
        this.add(Tags.Items.FENCE_GATES_WOODEN, "Wooden Fence Gates");
        this.add(Tags.Items.FENCES, "Fences");
        this.add(Tags.Items.FENCES_NETHER_BRICK, "Nether Brick Fences");
        this.add(Tags.Items.FENCES_WOODEN, "Wooden Fences");
        this.add(Tags.Items.FERTILIZERS, "Fertilizers");
        this.add(Tags.Items.FLOWERS_SMALL, "Small Flowers");
        this.add(Tags.Items.FLOWERS_TALL, "Tall Flowers");
        this.add(Tags.Items.FLOWERS, "Flowers");
        this.add(Tags.Items.FOODS, "Foods");
        this.add(Tags.Items.FOODS_BERRY, "Berries");
        this.add(Tags.Items.FOODS_BREAD, "Breads");
        this.add(Tags.Items.FOODS_CANDY, "Candies");
        this.add(Tags.Items.FOODS_PIE, "Pies");
        this.add(Tags.Items.FOODS_COOKED_FISH, "Cooked Fishes");
        this.add(Tags.Items.FOODS_COOKED_MEAT, "Cooked Meats");
        this.add(Tags.Items.FOODS_COOKIE, "Cookies");
        this.add(Tags.Items.FOODS_EDIBLE_WHEN_PLACED, "Edible When Placed");
        this.add(Tags.Items.FOODS_FOOD_POISONING, "Food Poisoning Foods");
        this.add(Tags.Items.FOODS_FRUIT, "Fruits");
        this.add(Tags.Items.FOODS_GOLDEN, "Golden Foods");
        this.add(Tags.Items.FOODS_RAW_FISH, "Raw Fishes");
        this.add(Tags.Items.FOODS_RAW_MEAT, "Raw Meats");
        this.add(Tags.Items.FOODS_SOUP, "Soups");
        this.add(Tags.Items.FOODS_VEGETABLE, "Vegetables");
        this.add(Tags.Items.ANIMAL_FOODS, "Animal Foods");
        this.add(Tags.Items.GEMS, "Gems");
        this.add(Tags.Items.GEMS_AMETHYST, "Amethyst Gems");
        this.add(Tags.Items.GEMS_DIAMOND, "Diamond Gems");
        this.add(Tags.Items.GEMS_EMERALD, "Emerald Gems");
        this.add(Tags.Items.GEMS_LAPIS, "Lapis Gems");
        this.add(Tags.Items.GEMS_PRISMARINE, "Prismarine Gems");
        this.add(Tags.Items.GEMS_QUARTZ, "Quartz Gems");
        this.add(Tags.Items.GLASS_BLOCKS, "Glass Blocks");
        this.add(Tags.Items.GLASS_BLOCKS_TINTED, "Tinted Glass Blocks");
        this.add(Tags.Items.GLASS_BLOCKS_CHEAP, "Cheap Glass Blocks");
        this.add(Tags.Items.GLASS_BLOCKS_COLORLESS, "Colorless Glass Blocks");
        this.add(Tags.Items.GLASS_PANES, "Glass Panes");
        this.add(Tags.Items.GLASS_PANES_COLORLESS, "Colorless Glass Panes");
        this.add(Tags.Items.GLAZED_TERRACOTTAS, "Glazed Terracottas");
        this.add(Tags.Items.GRAVELS, "Gravels");
        this.add(Tags.Items.GUNPOWDERS, "Gunpowders");
        this.add(Tags.Items.HIDDEN_FROM_RECIPE_VIEWERS, "Hidden From Recipe Viewers");
        this.add(Tags.Items.INGOTS, "Ingots");
        this.add(Tags.Items.INGOTS_COPPER, "Copper Ingots");
        this.add(Tags.Items.INGOTS_GOLD, "Gold Ingots");
        this.add(Tags.Items.INGOTS_IRON, "Iron Ingots");
        this.add(Tags.Items.INGOTS_NETHERITE, "Netherite Ingots");
        this.add(Tags.Items.LEATHERS, "Leathers");
        this.add(Tags.Items.MUSIC_DISCS, "Music Discs");
        this.add(Tags.Items.MUSHROOMS, "Mushrooms");
        this.add(Tags.Items.NETHER_STARS, "Nether Stars");
        this.add(Tags.Items.NETHERRACKS, "Netherracks");
        this.add(Tags.Items.NUGGETS, "Nuggets");
        this.add(Tags.Items.NUGGETS_IRON, "Iron Nuggets");
        this.add(Tags.Items.NUGGETS_GOLD, "Gold Nuggets");
        this.add(Tags.Items.OBSIDIANS, "Obsidians");
        this.add(Tags.Items.OBSIDIANS_NORMAL, "Normal Obsidians");
        this.add(Tags.Items.OBSIDIANS_CRYING, "Crying Obsidians");
        this.add(Tags.Items.ORE_BEARING_GROUND_DEEPSLATE, "Deepslate Ore Bearing Ground");
        this.add(Tags.Items.ORE_BEARING_GROUND_NETHERRACK, "Netherrack Ore Bearing Ground");
        this.add(Tags.Items.ORE_BEARING_GROUND_STONE, "Stone Ore Bearing Ground");
        this.add(Tags.Items.ORE_RATES_DENSE, "Dense Ore Rates");
        this.add(Tags.Items.ORE_RATES_SINGULAR, "Singular Ore Rates");
        this.add(Tags.Items.ORE_RATES_SPARSE, "Sparse Ore Rates");
        this.add(Tags.Items.ORES, "Ores");
        this.add(Tags.Items.ORES_COAL, "Coal Ores");
        this.add(Tags.Items.ORES_COPPER, "Copper Ores");
        this.add(Tags.Items.ORES_DIAMOND, "Diamond Ores");
        this.add(Tags.Items.ORES_EMERALD, "Emerald Ores");
        this.add(Tags.Items.ORES_GOLD, "Gold Ores");
        this.add(Tags.Items.ORES_IRON, "Iron Ores");
        this.add(Tags.Items.ORES_LAPIS, "Lapis Ores");
        this.add(Tags.Items.ORES_QUARTZ, "Quartz Ores");
        this.add(Tags.Items.ORES_REDSTONE, "Redstone Ores");
        this.add(Tags.Items.ORES_NETHERITE_SCRAP, "Netherite Scrap Ores");
        this.add(Tags.Items.ORES_IN_GROUND_DEEPSLATE, "Deepslate Ores In Ground");
        this.add(Tags.Items.ORES_IN_GROUND_NETHERRACK, "Netherrack Ores In Ground");
        this.add(Tags.Items.ORES_IN_GROUND_STONE, "Stone Ores In Ground");
        this.add(Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES, "Crafting Tables");
        this.add(Tags.Items.PLAYER_WORKSTATIONS_FURNACES, "Furnaces");
        this.add(Tags.Items.POTIONS, "Potions");
        this.add(Tags.Items.POTIONS_BOTTLE, "Bottled Potions");
        this.add(Tags.Items.RAW_MATERIALS, "Raw Materials");
        this.add(Tags.Items.RAW_MATERIALS_COPPER, "Copper Raw Materials");
        this.add(Tags.Items.RAW_MATERIALS_GOLD, "Gold Raw Materials");
        this.add(Tags.Items.RAW_MATERIALS_IRON, "Iron Raw Materials");
        this.add(Tags.Items.RODS, "Rods");
        this.add(Tags.Items.RODS_BLAZE, "Blaze Rods");
        this.add(Tags.Items.RODS_BREEZE, "Breeze Rods");
        this.add(Tags.Items.RODS_WOODEN, "Wooden Rods");
        this.add(Tags.Items.ROPES, "Ropes");
        this.add(Tags.Items.SANDS, "Sands");
        this.add(Tags.Items.SANDS_COLORLESS, "Colorless Sands");
        this.add(Tags.Items.SANDS_RED, "Red Sands");
        this.add(Tags.Items.SANDSTONE_BLOCKS, "Sandstone Blocks");
        this.add(Tags.Items.SANDSTONE_SLABS, "Sandstone Slabs");
        this.add(Tags.Items.SANDSTONE_STAIRS, "Sandstone Stairs");
        this.add(Tags.Items.SANDSTONE_RED_BLOCKS, "Red Sandstone Blocks");
        this.add(Tags.Items.SANDSTONE_RED_SLABS, "Red Sandstone Slabs");
        this.add(Tags.Items.SANDSTONE_RED_STAIRS, "Red Sandstone Stairs");
        this.add(Tags.Items.SANDSTONE_UNCOLORED_BLOCKS, "Uncolored Sandstone Blocks");
        this.add(Tags.Items.SANDSTONE_UNCOLORED_SLABS, "Uncolored Sandstone Slabs");
        this.add(Tags.Items.SANDSTONE_UNCOLORED_STAIRS, "Uncolored Sandstone Stairs");
        this.add(Tags.Items.SEEDS, "Seeds");
        this.add(Tags.Items.SEEDS_BEETROOT, "Beetroot Seeds");
        this.add(Tags.Items.SEEDS_MELON, "Melon Seeds");
        this.add(Tags.Items.SEEDS_PUMPKIN, "Pumpkin Seeds");
        this.add(Tags.Items.SEEDS_TORCHFLOWER, "Torchflower Seeds");
        this.add(Tags.Items.SEEDS_PITCHER_PLANT, "Pitcher Plant Seeds");
        this.add(Tags.Items.SEEDS_WHEAT, "Wheat Seeds");
        this.add(Tags.Items.SHULKER_BOXES, "Shulker Boxes");
        this.add(Tags.Items.SLIME_BALLS, "Slimeballs");
        this.add(Tags.Items.STONES, "Stones");
        this.add(Tags.Items.STORAGE_BLOCKS, "Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_BONE_MEAL, "Bone Meal Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_COAL, "Coal Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_COPPER, "Copper Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_DIAMOND, "Diamond Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_DRIED_KELP, "Dried Kelp Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_EMERALD, "Emerald Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_GOLD, "Gold Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_IRON, "Iron Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_LAPIS, "Lapis Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_NETHERITE, "Netherite Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_RAW_COPPER, "Raw Copper Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_RAW_GOLD, "Raw Gold Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_RAW_IRON, "Raw Iron Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_REDSTONE, "Redstone Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_RESIN, "Resin Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_SLIME, "Slime Storage Blocks");
        this.add(Tags.Items.STORAGE_BLOCKS_WHEAT, "Wheat Storage Blocks");
        this.add(Tags.Items.STRINGS, "Strings");
        this.add(Tags.Items.STRIPPED_LOGS, "Stripped Log Blocks");
        this.add(Tags.Items.STRIPPED_WOODS, "Stripped Wood Blocks");
        this.add(Tags.Items.VILLAGER_JOB_SITES, "Villager Job Sites");
        this.add(Tags.Items.TOOLS_SHEAR, "Shears");
        this.add(Tags.Items.TOOLS_SHIELD, "Shields");
        this.add(Tags.Items.TOOLS_BOW, "Bows");
        this.add(Tags.Items.TOOLS_CROSSBOW, "Crossbows");
        this.add(Tags.Items.TOOLS_FISHING_ROD, "Fishing Rods");
        this.add(Tags.Items.TOOLS_BRUSH, "Brushes");
        this.add(Tags.Items.TOOLS_MACE, "Maces");
        this.add(Tags.Items.TOOLS_SPEAR, "Spears");
        this.add(Tags.Items.TOOLS_IGNITER, "Igniters");
        this.add(Tags.Items.TOOLS_WRENCH, "Wrenches");
        this.add(Tags.Items.MELEE_WEAPON_TOOLS, "Melee Weapons");
        this.add(Tags.Items.RANGED_WEAPON_TOOLS, "Ranged Weapons");
        this.add(Tags.Items.MINING_TOOL_TOOLS, "Mining Tools");
        this.add(Tags.Items.TOOLS, "Tools");
        this.add(Tags.Items.ARMORS, "Armors");
        this.add(Tags.Items.ENCHANTABLES, "Enchantables");
        this.add(Tags.Fluids.WATER, "Water");
        this.add(Tags.Fluids.LAVA, "Lava");
        this.add(Tags.Fluids.MILK, "Milk");
        this.add(Tags.Fluids.GASEOUS, "Gaseous");
        this.add(Tags.Fluids.HONEY, "Honey");
        this.add(Tags.Fluids.EXPERIENCE, "Experience");
        this.add(Tags.Fluids.POTION, "Potion");
        this.add(Tags.Fluids.SUSPICIOUS_STEW, "Suspicious Stew");
        this.add(Tags.Fluids.MUSHROOM_STEW, "Mushroom Stew");
        this.add(Tags.Fluids.RABBIT_STEW, "Rabbit Stew");
        this.add(Tags.Fluids.BEETROOT_SOUP, "Beetroot Soup");
        this.add(Tags.Fluids.HIDDEN_FROM_RECIPE_VIEWERS, "Hidden From Recipe Viewers");
        this.add(Tags.EntityTypes.BOSSES, "Bosses");
        this.add(Tags.EntityTypes.MINECARTS, "Minecarts");
        this.add(Tags.EntityTypes.BOATS, "Boats");
        this.add(Tags.EntityTypes.CAPTURING_NOT_SUPPORTED, "Capturing Not Supported");
        this.add(Tags.EntityTypes.TELEPORTING_NOT_SUPPORTED, "Teleporting Not Supported");
        this.add(Tags.Enchantments.INCREASE_BLOCK_DROPS, "Increase Block Drops");
        this.add(Tags.Enchantments.INCREASE_ENTITY_DROPS, "Increase Entity Drops");
        this.add(Tags.Enchantments.WEAPON_DAMAGE_ENHANCEMENTS, "Weapon Damage Enhancements");
        this.add(Tags.Enchantments.ENTITY_SPEED_ENHANCEMENTS, "Entity Speed Enhancements");
        this.add(Tags.Enchantments.ENTITY_AUXILIARY_MOVEMENT_ENHANCEMENTS, "Entity Auxiliary Movement Enhancements");
        this.add(Tags.Enchantments.ENTITY_DEFENSE_ENHANCEMENTS, "Entity Defense Enhancements");
        this.add(Tags.Biomes.NO_DEFAULT_MONSTERS, "No Default Monsters");
        this.add(Tags.Biomes.HIDDEN_FROM_LOCATOR_SELECTION, "Hidden From Locator's Selection");
        this.add(Tags.Biomes.IS_VOID, "Voids");
        this.add(Tags.Biomes.IS_END, "Is End");
        this.add(Tags.Biomes.IS_NETHER, "Is Nether");
        this.add(Tags.Biomes.IS_OVERWORLD, "Is Overworld");
        this.add(Tags.Biomes.IS_HOT, "Hot");
        this.add(Tags.Biomes.IS_HOT_OVERWORLD, "Hot Overworld");
        this.add(Tags.Biomes.IS_HOT_NETHER, "Hot Nether");
        this.add(Tags.Biomes.IS_HOT_END, "Hot End");
        this.add(Tags.Biomes.IS_COLD, "Cold");
        this.add(Tags.Biomes.IS_COLD_OVERWORLD, "Cold Overworld");
        this.add(Tags.Biomes.IS_COLD_NETHER, "Cold Nether");
        this.add(Tags.Biomes.IS_COLD_END, "Cold End");
        this.add(Tags.Biomes.IS_TEMPERATE, "Temperate");
        this.add(Tags.Biomes.IS_TEMPERATE_OVERWORLD, "Temperate Overworld");
        this.add(Tags.Biomes.IS_TEMPERATE_NETHER, "Temperate Nether");
        this.add(Tags.Biomes.IS_TEMPERATE_END, "Temperate End");
        this.add(Tags.Biomes.IS_SPARSE_VEGETATION, "Sparse Vegetation");
        this.add(Tags.Biomes.IS_SPARSE_VEGETATION_OVERWORLD, "Sparse Overworld Vegetation");
        this.add(Tags.Biomes.IS_SPARSE_VEGETATION_NETHER, "Sparse Nether Vegetation");
        this.add(Tags.Biomes.IS_SPARSE_VEGETATION_END, "Sparse End Vegetation");
        this.add(Tags.Biomes.IS_DENSE_VEGETATION, "Dense Vegetation");
        this.add(Tags.Biomes.IS_DENSE_VEGETATION_OVERWORLD, "Dense Overworld Vegetation");
        this.add(Tags.Biomes.IS_DENSE_VEGETATION_NETHER, "Dense Nether Vegetation");
        this.add(Tags.Biomes.IS_DENSE_VEGETATION_END, "Dense End Vegetation");
        this.add(Tags.Biomes.IS_WET, "Wet");
        this.add(Tags.Biomes.IS_WET_OVERWORLD, "Wet Overworld");
        this.add(Tags.Biomes.IS_WET_NETHER, "Wet Nether");
        this.add(Tags.Biomes.IS_WET_END, "Wet End");
        this.add(Tags.Biomes.IS_DRY, "Dry");
        this.add(Tags.Biomes.IS_DRY_OVERWORLD, "Dry Overworld");
        this.add(Tags.Biomes.IS_DRY_NETHER, "Dry Nether");
        this.add(Tags.Biomes.IS_DRY_END, "Dry End");
        this.add(Tags.Biomes.IS_CONIFEROUS_TREE, "Coniferous Trees");
        this.add(Tags.Biomes.IS_SAVANNA_TREE, "Savanna Trees");
        this.add(Tags.Biomes.IS_JUNGLE_TREE, "Jungle Trees");
        this.add(Tags.Biomes.IS_DECIDUOUS_TREE, "Deciduous Trees");
        this.add(Tags.Biomes.IS_MOUNTAIN, "Mountains");
        this.add(Tags.Biomes.IS_MOUNTAIN_PEAK, "Peaks");
        this.add(Tags.Biomes.IS_MOUNTAIN_SLOPE, "Slopes");
        this.add(Tags.Biomes.IS_PLAINS, "Plains");
        this.add(Tags.Biomes.IS_SNOWY_PLAINS, "Snowy Plains");
        this.add(Tags.Biomes.IS_FOREST, "Forest");
        this.add(Tags.Biomes.IS_BIRCH_FOREST, "Birch Forest");
        this.add(Tags.Biomes.IS_FLOWER_FOREST, "Flower Forest");
        this.add(Tags.Biomes.IS_TAIGA, "Taiga");
        this.add(Tags.Biomes.IS_HILL, "Hills");
        this.add(Tags.Biomes.IS_WINDSWEPT, "Windswept");
        this.add(Tags.Biomes.IS_JUNGLE, "Jungle");
        this.add(Tags.Biomes.IS_FLORAL, "Floral");
        this.add(Tags.Biomes.IS_BEACH, "Beach");
        this.add(Tags.Biomes.IS_STONY_SHORES, "Stony Shores");
        this.add(Tags.Biomes.IS_SHALLOW_OCEAN, "Shallow Ocean");
        this.add(Tags.Biomes.IS_OCEAN, "Ocean");
        this.add(Tags.Biomes.IS_DEEP_OCEAN, "Deep Ocean");
        this.add(Tags.Biomes.IS_RIVER, "River");
        this.add(Tags.Biomes.IS_BADLANDS, "Badlands");
        this.add(Tags.Biomes.IS_SNOWY, "Snowy");
        this.add(Tags.Biomes.IS_ICY, "Icy");
        this.add(Tags.Biomes.IS_AQUATIC_ICY, "Aquatic Icy");
        this.add(Tags.Biomes.IS_SPOOKY, "Spooky");
        this.add(Tags.Biomes.IS_DEAD, "Dead");
        this.add(Tags.Biomes.IS_LUSH, "Lush");
        this.add(Tags.Biomes.IS_MUSHROOM, "Mushrooms");
        this.add(Tags.Biomes.IS_MAGICAL, "Magical");
        this.add(Tags.Biomes.IS_RARE, "Rare");
        this.add(Tags.Biomes.IS_PLATEAU, "Plateau");
        this.add(Tags.Biomes.IS_MODIFIED, "Modified");
        this.add(Tags.Biomes.IS_OLD_GROWTH, "Old Growth");
        this.add(Tags.Biomes.IS_AQUATIC, "Aquatic");
        this.add(Tags.Biomes.IS_DESERT, "Deserts");
        this.add(Tags.Biomes.IS_SAVANNA, "Savanna");
        this.add(Tags.Biomes.IS_SWAMP, "Swamps");
        this.add(Tags.Biomes.IS_SANDY, "Sandy");
        this.add(Tags.Biomes.IS_WASTELAND, "Wastelands");
        this.add(Tags.Biomes.IS_UNDERGROUND, "Underground");
        this.add(Tags.Biomes.IS_CAVE, "Caves");
        this.add(Tags.Biomes.IS_NETHER_FOREST, "Nether Forest");
        this.add(Tags.Biomes.IS_OUTER_END_ISLAND, "Outer End Island");
        this.add(Tags.Structures.HIDDEN_FROM_DISPLAYERS, "Hidden From Displayers");
        this.add(Tags.Structures.HIDDEN_FROM_LOCATOR_SELECTION, "Hidden From Locator's Selection");
    }

    private <T> void addColored(TagKey<T> baseTagKey, String pattern) {
        for (DyeColor color : DyeColor.values()) {
            TagKey coloredTag = TagKey.create((ResourceKey)baseTagKey.registry(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)baseTagKey.location().getNamespace(), (String)(baseTagKey.location().getPath() + "/" + color.name().toLowerCase(Locale.ROOT))));
            this.add(coloredTag, pattern.replace("{color}", StringUtils.capitalize((String)color.getName())));
        }
    }

    @Override
    public String getName() {
        return "Forge Translations";
    }
}

