/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.generators.loaders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.template.CustomLoaderBuilder;

public class CompositeModelBuilder
extends CustomLoaderBuilder {
    private final Map<String, Either<ResourceLocation, InlineChild>> childModels = new LinkedHashMap<String, Either<ResourceLocation, InlineChild>>();
    private final List<String> itemRenderOrder = new ArrayList<String>();

    public CompositeModelBuilder() {
        super(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"composite"), false);
    }

    public CompositeModelBuilder child(String name, ResourceLocation model) {
        Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
        Preconditions.checkNotNull((Object)model, (Object)"model must not be null");
        this.childModels.put(name, (Either<ResourceLocation, InlineChild>)Either.left((Object)model));
        this.itemRenderOrder.add(name);
        return this;
    }

    public CompositeModelBuilder inlineChild(String name, ModelTemplate template, TextureMapping textures) {
        Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
        Preconditions.checkNotNull((Object)template, (Object)"model template must not be null");
        Preconditions.checkNotNull((Object)textures, (Object)"textures must not be null");
        this.childModels.put(name, (Either<ResourceLocation, InlineChild>)Either.right((Object)new InlineChild(template, textures)));
        this.itemRenderOrder.add(name);
        return this;
    }

    public CompositeModelBuilder itemRenderOrder(String ... names) {
        Preconditions.checkNotNull((Object)names, (Object)"names must not be null");
        Preconditions.checkArgument((names.length > 0 ? 1 : 0) != 0, (Object)"names must contain at least one element");
        for (String name : names) {
            if (this.childModels.containsKey(name)) continue;
            throw new IllegalArgumentException("names contains \"" + name + "\", which is not a child of this model");
        }
        this.itemRenderOrder.clear();
        this.itemRenderOrder.addAll(Arrays.asList(names));
        return this;
    }

    @Override
    protected CustomLoaderBuilder copyInternal() {
        CompositeModelBuilder builder = new CompositeModelBuilder();
        builder.childModels.putAll(this.childModels);
        builder.itemRenderOrder.addAll(this.itemRenderOrder);
        return builder;
    }

    @Override
    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        JsonObject children = new JsonObject();
        for (Map.Entry<String, Either<ResourceLocation, InlineChild>> entry : this.childModels.entrySet()) {
            entry.getValue().ifLeft(reference -> children.addProperty((String)entry.getKey(), reference.toString())).ifRight(inline -> CompositeModelBuilder.serializeNestedTemplate(inline.template, inline.textures, inlineJson -> children.add((String)entry.getKey(), inlineJson)));
        }
        json.add("children", (JsonElement)children);
        JsonArray itemRenderOrder = new JsonArray();
        for (String name : this.itemRenderOrder) {
            itemRenderOrder.add(name);
        }
        json.add("item_render_order", (JsonElement)itemRenderOrder);
        return json;
    }

    private record InlineChild(ModelTemplate template, TextureMapping textures) {
    }
}

