/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.conditions;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.neoforged.neoforge.common.conditions.AlwaysCondition;
import net.neoforged.neoforge.common.conditions.AndCondition;
import net.neoforged.neoforge.common.conditions.FeatureFlagsEnabledCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NeverCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.OrCondition;
import net.neoforged.neoforge.common.conditions.RegisteredCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import org.apache.commons.lang3.ArrayUtils;

public final class NeoForgeConditions {
    public static ICondition and(ICondition ... values) {
        return new AndCondition(List.of(values));
    }

    public static ICondition never() {
        return NeverCondition.INSTANCE;
    }

    public static ICondition always() {
        return AlwaysCondition.INSTANCE;
    }

    public static ICondition not(ICondition value) {
        return new NotCondition(value);
    }

    public static ICondition or(ICondition ... values) {
        return new OrCondition(List.of(values));
    }

    public static <TRegistry> ICondition registered(ResourceKey<TRegistry> registryKey) {
        return new RegisteredCondition<TRegistry>(registryKey);
    }

    public static <TRegistry> ICondition registered(ResourceKey<? extends Registry<TRegistry>> registryType, ResourceLocation registryName) {
        return NeoForgeConditions.registered(ResourceKey.create(registryType, (ResourceLocation)registryName));
    }

    public static ICondition registered(ResourceLocation registryTypeName, ResourceLocation registryName) {
        return NeoForgeConditions.registered(ResourceKey.createRegistryKey((ResourceLocation)registryTypeName), registryName);
    }

    public static ICondition itemRegistered(ResourceLocation itemName) {
        return NeoForgeConditions.registered(Registries.ITEM, itemName);
    }

    public static ICondition itemRegistered(String namespace, String path) {
        return NeoForgeConditions.itemRegistered(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public static ICondition itemRegistered(String itemName) {
        return NeoForgeConditions.itemRegistered(ResourceLocation.parse((String)itemName));
    }

    public static ICondition modLoaded(String modid) {
        return new ModLoadedCondition(modid);
    }

    public static <TRegistry> ICondition tagEmpty(TagKey<TRegistry> tag) {
        return new TagEmptyCondition<TRegistry>(tag);
    }

    public static <TRegistry> ICondition tagEmpty(ResourceKey<? extends Registry<TRegistry>> tagType, ResourceLocation tagName) {
        return NeoForgeConditions.tagEmpty(TagKey.create(tagType, (ResourceLocation)tagName));
    }

    public static ICondition itemTagEmpty(ResourceLocation tagName) {
        return NeoForgeConditions.tagEmpty(Registries.ITEM, tagName);
    }

    public static ICondition itemTagEmpty(String namespace, String tagPath) {
        return NeoForgeConditions.itemTagEmpty(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)tagPath));
    }

    public static ICondition itemTagEmpty(String tagName) {
        return NeoForgeConditions.itemTagEmpty(ResourceLocation.parse((String)tagName));
    }

    public static ICondition featureFlagsEnabled(FeatureFlagSet requiredFeatures) {
        return new FeatureFlagsEnabledCondition(requiredFeatures);
    }

    public static ICondition featureFlagsEnabled(FeatureFlag ... requiredFlags) {
        if (requiredFlags.length == 0) {
            throw new IllegalArgumentException("FeatureFlagsEnabledCondition requires at least one feature flag.");
        }
        if (requiredFlags.length == 1) {
            return new FeatureFlagsEnabledCondition(FeatureFlagSet.of((FeatureFlag)requiredFlags[0]));
        }
        return new FeatureFlagsEnabledCondition(FeatureFlagSet.of((FeatureFlag)requiredFlags[0], (FeatureFlag[])((FeatureFlag[])ArrayUtils.remove((Object[])requiredFlags, (int)0))));
    }

    private NeoForgeConditions() {
    }
}

