/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.AbstractUnbakedModel;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.IModelBuilder;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;
import net.neoforged.neoforge.client.model.StandardModelParameters;
import net.neoforged.neoforge.client.model.UnbakedElementsHelper;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.util.ConcatenatedListView;
import org.jetbrains.annotations.Nullable;

public class UnbakedCompositeModel
extends AbstractUnbakedModel {
    private final ImmutableMap<String, ResourceLocation> children;
    private final ImmutableList<String> itemPasses;

    public UnbakedCompositeModel(ImmutableMap<String, ResourceLocation> children, ImmutableList<String> itemPasses, StandardModelParameters parameters) {
        super(parameters);
        this.children = children;
        this.itemPasses = itemPasses;
    }

    @Override
    public BakedModel bake(TextureSlots slots, ModelBaker baker, ModelState state, boolean useAmbientOcclusion, boolean usesBlockLight, ItemTransforms transforms, ContextMap additionalProperties) {
        TextureAtlasSprite particle = baker.findSprite(slots, TextureSlot.PARTICLE.getId());
        Transformation rootTransform = (Transformation)additionalProperties.getOrDefault(NeoForgeModelProperties.TRANSFORM, (Object)Transformation.identity());
        if (!rootTransform.isIdentity()) {
            state = UnbakedElementsHelper.composeRootTransformIntoModelState(state, rootTransform);
        }
        Map partVisibility = (Map)additionalProperties.getOrDefault(NeoForgeModelProperties.PART_VISIBILITY, Map.of());
        ImmutableMap.Builder bakedPartsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.children.entrySet()) {
            String name = (String)entry.getKey();
            if (!partVisibility.getOrDefault(name, true).booleanValue()) continue;
            ResourceLocation model = (ResourceLocation)entry.getValue();
            bakedPartsBuilder.put((Object)name, (Object)baker.bake(model, state));
        }
        ImmutableMap bakedParts = bakedPartsBuilder.build();
        ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
        for (String name : this.itemPasses) {
            BakedModel model = (BakedModel)bakedParts.get((Object)name);
            if (model == null) {
                throw new IllegalStateException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
            }
            itemPassesBuilder.add((Object)model);
        }
        return new Baked(usesBlockLight, useAmbientOcclusion, particle, transforms, (ImmutableMap<String, BakedModel>)bakedParts, (ImmutableList<BakedModel>)itemPassesBuilder.build());
    }

    @Override
    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        for (ResourceLocation path : this.children.values()) {
            resolver.resolve(path);
        }
    }

    public static class Baked
    implements IDynamicBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final ItemTransforms transforms;
        private final ImmutableMap<String, BakedModel> children;
        private final ImmutableList<BakedModel> itemPasses;

        public Baked(boolean isSideLit, boolean isAmbientOcclusion, TextureAtlasSprite particle, ItemTransforms transforms, ImmutableMap<String, BakedModel> children, ImmutableList<BakedModel> itemPasses) {
            this.children = children;
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.transforms = transforms;
            this.itemPasses = itemPasses;
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
            ArrayList<List> quadLists = new ArrayList<List>();
            for (Map.Entry entry : this.children.entrySet()) {
                if (renderType != null && (state == null || !((BakedModel)entry.getValue()).getRenderTypes(state, rand, data).contains(renderType))) continue;
                quadLists.add(((BakedModel)entry.getValue()).getQuads(state, side, rand, Data.resolve(data, (String)entry.getKey()), renderType));
            }
            return ConcatenatedListView.of(quadLists);
        }

        public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
            Data.Builder builder = Data.builder();
            for (Map.Entry entry : this.children.entrySet()) {
                builder.with((String)entry.getKey(), ((BakedModel)entry.getValue()).getModelData(level, pos, state, Data.resolve(modelData, (String)entry.getKey())));
            }
            return modelData.derive().with(Data.PROPERTY, builder.build()).build();
        }

        public boolean useAmbientOcclusion() {
            return this.isAmbientOcclusion;
        }

        public boolean isGui3d() {
            return true;
        }

        public boolean usesBlockLight() {
            return this.isSideLit;
        }

        public TextureAtlasSprite getParticleIcon() {
            return this.particle;
        }

        public ItemTransforms getTransforms() {
            return this.transforms;
        }

        public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
            ArrayList<ChunkRenderTypeSet> sets = new ArrayList<ChunkRenderTypeSet>();
            for (Map.Entry entry : this.children.entrySet()) {
                sets.add(((BakedModel)entry.getValue()).getRenderTypes(state, rand, Data.resolve(data, (String)entry.getKey())));
            }
            return ChunkRenderTypeSet.union(sets);
        }

        public List<BakedModel> getRenderPasses(ItemStack itemStack) {
            return this.itemPasses;
        }

        @Nullable
        public BakedModel getPart(String name) {
            return (BakedModel)this.children.get((Object)name);
        }

        public static Builder builder(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemTransforms cameraTransforms) {
            return new Builder(isAmbientOcclusion, isGui3d, isSideLit, particle, cameraTransforms);
        }

        public static class Builder {
            private final boolean isAmbientOcclusion;
            private final boolean isGui3d;
            private final boolean isSideLit;
            private final List<BakedModel> children = new ArrayList<BakedModel>();
            private final List<BakedQuad> quads = new ArrayList<BakedQuad>();
            private final ItemTransforms transforms;
            private TextureAtlasSprite particle;
            private RenderTypeGroup lastRenderTypes = RenderTypeGroup.EMPTY;

            private Builder(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemTransforms transforms) {
                this.isAmbientOcclusion = isAmbientOcclusion;
                this.isGui3d = isGui3d;
                this.isSideLit = isSideLit;
                this.particle = particle;
                this.transforms = transforms;
            }

            public void addLayer(BakedModel model) {
                this.flushQuads(null);
                this.children.add(model);
            }

            private void addLayer(RenderTypeGroup renderTypes, List<BakedQuad> quads) {
                IModelBuilder<?> modelBuilder = IModelBuilder.of(this.isAmbientOcclusion, this.isSideLit, this.isGui3d, this.transforms, this.particle, renderTypes);
                quads.forEach(modelBuilder::addUnculledFace);
                this.children.add(modelBuilder.build());
            }

            private void flushQuads(@Nullable RenderTypeGroup renderTypes) {
                if (!Objects.equals(renderTypes, this.lastRenderTypes)) {
                    if (!this.quads.isEmpty()) {
                        this.addLayer(this.lastRenderTypes, this.quads);
                        this.quads.clear();
                    }
                    this.lastRenderTypes = renderTypes;
                }
            }

            public Builder setParticle(TextureAtlasSprite particleSprite) {
                this.particle = particleSprite;
                return this;
            }

            public Builder addQuads(RenderTypeGroup renderTypes, BakedQuad ... quadsToAdd) {
                this.flushQuads(renderTypes);
                Collections.addAll(this.quads, quadsToAdd);
                return this;
            }

            public Builder addQuads(RenderTypeGroup renderTypes, Collection<BakedQuad> quadsToAdd) {
                this.flushQuads(renderTypes);
                this.quads.addAll(quadsToAdd);
                return this;
            }

            public BakedModel build() {
                if (!this.quads.isEmpty()) {
                    this.addLayer(this.lastRenderTypes, this.quads);
                }
                ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
                ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
                int i = 0;
                for (BakedModel model : this.children) {
                    childrenBuilder.put((Object)("model_" + i++), (Object)model);
                    itemPassesBuilder.add((Object)model);
                }
                return new Baked(this.isSideLit, this.isAmbientOcclusion, this.particle, this.transforms, (ImmutableMap<String, BakedModel>)childrenBuilder.build(), (ImmutableList<BakedModel>)itemPassesBuilder.build());
            }
        }
    }

    public static final class Loader
    implements UnbakedModelLoader<UnbakedCompositeModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public UnbakedCompositeModel read(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            ArrayList<String> itemPasses = new ArrayList<String>();
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            this.readChildren(jsonObject, "children", (ImmutableMap.Builder<String, ResourceLocation>)childrenBuilder, itemPasses);
            ImmutableMap children = childrenBuilder.build();
            if (children.isEmpty()) {
                throw new JsonParseException("Composite model requires a \"children\" element with at least one element.");
            }
            if (jsonObject.has("item_render_order")) {
                itemPasses.clear();
                for (JsonElement element : jsonObject.getAsJsonArray("item_render_order")) {
                    String name = element.getAsString();
                    if (!children.containsKey((Object)name)) {
                        throw new JsonParseException("Specified \"" + name + "\" in \"item_render_order\", but that is not a child of this model.");
                    }
                    itemPasses.add(name);
                }
            }
            StandardModelParameters parameters = StandardModelParameters.parse(jsonObject, jsonDeserializationContext);
            return new UnbakedCompositeModel((ImmutableMap<String, ResourceLocation>)children, (ImmutableList<String>)ImmutableList.copyOf(itemPasses), parameters);
        }

        private void readChildren(JsonObject jsonObject, String name, ImmutableMap.Builder<String, ResourceLocation> children, List<String> itemPasses) {
            if (!jsonObject.has(name)) {
                return;
            }
            JsonObject childrenJsonObject = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : childrenJsonObject.entrySet()) {
                ResourceLocation location = ResourceLocation.parse((String)((JsonElement)entry.getValue()).getAsString());
                children.put((Object)((String)entry.getKey()), (Object)location);
                itemPasses.add((String)entry.getKey());
            }
        }
    }

    public static class Data {
        public static final ModelProperty<Data> PROPERTY = new ModelProperty();
        private final Map<String, ModelData> partData;

        private Data(Map<String, ModelData> partData) {
            this.partData = partData;
        }

        @Nullable
        public ModelData get(String name) {
            return this.partData.get(name);
        }

        public static ModelData resolve(ModelData modelData, String name) {
            Data compositeData = modelData.get(PROPERTY);
            if (compositeData == null) {
                return modelData;
            }
            ModelData partData = compositeData.get(name);
            return partData != null ? partData : modelData;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private final Map<String, ModelData> partData = new IdentityHashMap<String, ModelData>();

            public Builder with(String name, ModelData data) {
                this.partData.put(name, data);
                return this;
            }

            public Data build() {
                return new Data(this.partData);
            }
        }
    }
}

