/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.extensions.common;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.ClientExtensionsManager;
import org.jetbrains.annotations.Nullable;

public interface IClientItemExtensions {
    public static final IClientItemExtensions DEFAULT = new IClientItemExtensions(){};

    public static IClientItemExtensions of(ItemStack stack) {
        return IClientItemExtensions.of(stack.getItem());
    }

    public static IClientItemExtensions of(Item item) {
        return ClientExtensionsManager.ITEM_EXTENSIONS.getOrDefault(item, DEFAULT);
    }

    @Nullable
    default public Font getFont(ItemStack stack, FontContext context) {
        return null;
    }

    @Nullable
    default public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
        return null;
    }

    default public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
        return false;
    }

    default public Model getHumanoidArmorModel(ItemStack itemStack, EquipmentClientInfo.LayerType layerType, Model original) {
        return original;
    }

    default public Model getGenericArmorModel(ItemStack itemStack, EquipmentClientInfo.LayerType layerType, Model original) {
        Model replacement = this.getHumanoidArmorModel(itemStack, layerType, original);
        if (replacement != original) {
            if (original instanceof HumanoidModel) {
                HumanoidModel originalHumanoid = (HumanoidModel)original;
                if (replacement instanceof HumanoidModel) {
                    HumanoidModel replacementHumanoid = (HumanoidModel)replacement;
                    ClientHooks.copyModelProperties(originalHumanoid, replacementHumanoid);
                }
            }
            return replacement;
        }
        return original;
    }

    default public void setupModelAnimations(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, Model model, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    default public void renderHelmetOverlay(ItemStack stack, Player player, int width, int height, float partialTick) {
    }

    default public boolean shouldBobAsEntity(ItemStack stack) {
        return true;
    }

    default public boolean shouldSpreadAsEntity(ItemStack stack) {
        return true;
    }

    default public int getArmorLayerTintColor(ItemStack stack, EquipmentClientInfo.Layer layer, int layerIdx, int fallbackColor) {
        return EquipmentLayerRenderer.getColorForLayer((EquipmentClientInfo.Layer)layer, (int)fallbackColor);
    }

    default public int getDefaultDyeColor(ItemStack stack) {
        return stack.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)stack, (int)0) : 0;
    }

    @Nullable
    default public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
        return null;
    }

    public static enum FontContext {
        ITEM_COUNT,
        TOOLTIP,
        SELECTED_ITEM_NAME;

    }
}

