/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.conditions;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.ApiStatus;

public class ConditionContext
implements ICondition.IContext {
    private final Map<ResourceKey<? extends Registry<?>>, HolderLookup.RegistryLookup<?>> pendingTags = new IdentityHashMap();
    private final FeatureFlagSet enabledFeatures;

    public ConditionContext(List<Registry.PendingTags<?>> pendingTags, FeatureFlagSet enabledFeatures) {
        this.enabledFeatures = enabledFeatures;
        for (Registry.PendingTags<?> tags : pendingTags) {
            this.pendingTags.put(tags.key(), tags.lookup());
        }
    }

    @Deprecated(forRemoval=true, since="1.21.3")
    @ApiStatus.ScheduledForRemoval(inVersion="1.21.4")
    public ConditionContext(List<Registry.PendingTags<?>> pendingTags) {
        this(pendingTags, FeatureFlags.VANILLA_SET);
    }

    public void clear() {
        this.pendingTags.clear();
    }

    @Override
    public <T> boolean isTagLoaded(TagKey<T> key) {
        HolderLookup.RegistryLookup<?> lookup = this.pendingTags.get(key.registry());
        return lookup != null && lookup.get(key).isPresent();
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.enabledFeatures;
    }
}

