/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.renderstate;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.MapRenderState;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.client.renderstate.MapDecorationRenderStateModifier;
import net.neoforged.neoforge.client.renderstate.RenderStateExtensions;
import org.jetbrains.annotations.ApiStatus;

public class RegisterRenderStateModifiersEvent
extends Event
implements IModBusEvent {
    @ApiStatus.Internal
    public RegisterRenderStateModifiersEvent() {
    }

    public <E extends Entity, S extends EntityRenderState> void registerEntityModifier(TypeToken<? extends EntityRenderer<? extends E, ? extends S>> baseRenderer, BiConsumer<E, S> modifier) {
        RegisterRenderStateModifiersEvent.ensureParametersMatchBounds(baseRenderer);
        RenderStateExtensions.registerEntity(baseRenderer.getRawType(), modifier);
    }

    public <E extends Entity, S extends EntityRenderState> void registerEntityModifier(Class<? extends EntityRenderer<? extends E, ? extends S>> baseRenderer, BiConsumer<E, S> modifier) {
        RegisterRenderStateModifiersEvent.ensureParametersMatchBounds((TypeToken<? extends EntityRenderer<? extends Entity, ? extends EntityRenderState>>)TypeToken.of(baseRenderer));
        RenderStateExtensions.registerEntity(baseRenderer, modifier);
    }

    public void registerMapModifier(BiConsumer<MapItemSavedData, MapRenderState> modifier) {
        RenderStateExtensions.registerMap(modifier);
    }

    public void registerMapDecorationModifier(ResourceKey<MapDecorationType> mapDecorationTypeKey, MapDecorationRenderStateModifier modifier) {
        RenderStateExtensions.registerMapDecoration(mapDecorationTypeKey, modifier);
    }

    private static void ensureParametersMatchBounds(TypeToken<? extends EntityRenderer<? extends Entity, ? extends EntityRenderState>> baseRenderer) {
        Type type = baseRenderer.getType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class<?> bound = baseRenderer.getRawType();
            ParameterizedType parameterized = parameterizedType;
            do {
                ParameterizedType parameterizedOwner;
                Type[] userArgs = parameterized.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeArgs = bound.getTypeParameters();
                for (int i = 0; i < userArgs.length; ++i) {
                    Type userArg = userArgs[i];
                    TypeToken userToken = Container.of(TypeToken.of((Type)userArg));
                    TypeVariable typeArg = typeArgs[i];
                    for (Type singleBound : typeArg.getBounds()) {
                        TypeToken token = Container.of(TypeToken.of((Type)singleBound));
                        if (token.isSubtypeOf(userToken)) continue;
                        throw new IllegalArgumentException("%s does not match expected type parameter %s".formatted(userArg, singleBound));
                    }
                }
                Type type2 = parameterized.getOwnerType();
                if (!(type2 instanceof ParameterizedType)) break;
                parameterized = parameterizedOwner = (ParameterizedType)type2;
            } while ((bound = bound.getEnclosingClass()) != null);
        }
    }

    private record Container<X>() {
        private static <Z> TypeToken<Container<Z>> of(TypeToken<Z> parameter) {
            return new TypeToken<Container<Z>>(){}.where(new TypeParameter<Z>(){}, parameter);
        }
    }
}

