/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import com.mojang.logging.LogUtils;
import io.netty.util.AttributeKey;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.network.configuration.RegistryDataMapNegotiation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.payload.FrozenRegistryPayload;
import net.neoforged.neoforge.network.payload.KnownRegistryDataMapsReplyPayload;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.ModifyRegistriesEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistrySnapshot;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ApiStatus.Internal
public class RegistryManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Marker REGISTRIES = MarkerFactory.getMarker((String)"REGISTRIES");
    private static Set<ResourceLocation> pendingModdedRegistries = new HashSet<ResourceLocation>();
    private static Set<ResourceLocation> vanillaRegistryKeys = Set.of();
    private static Map<ResourceLocation, RegistrySnapshot> vanillaSnapshot = null;
    private static Map<ResourceLocation, RegistrySnapshot> frozenSnapshot = null;
    private static Map<ResourceKey<Registry<?>>, Map<ResourceLocation, DataMapType<?, ?>>> dataMaps = Map.of();
    public static final AttributeKey<Map<ResourceKey<? extends Registry<?>>, Collection<ResourceLocation>>> ATTRIBUTE_KNOWN_DATA_MAPS = AttributeKey.valueOf((String)"neoforge:known_data_maps");

    static synchronized void trackModdedRegistry(ResourceLocation registry) {
        Objects.requireNonNull(registry);
        if (pendingModdedRegistries == null) {
            throw new IllegalStateException("Attempting to instantiate registry with name " + String.valueOf(registry) + " after NewRegistryEvent was fired!");
        }
        if (!pendingModdedRegistries.add(registry)) {
            throw new IllegalStateException("Registry with name " + String.valueOf(registry) + " was already instantiated once, cannot instantiate it again!");
        }
    }

    @Nullable
    public static <R> DataMapType<R, ?> getDataMap(ResourceKey<? extends Registry<R>> registry, ResourceLocation key) {
        Map<ResourceLocation, DataMapType<?, ?>> map = dataMaps.get(registry);
        return map == null ? null : map.get(key);
    }

    public static Map<ResourceKey<Registry<?>>, Map<ResourceLocation, DataMapType<?, ?>>> getDataMaps() {
        return dataMaps;
    }

    public static void postNewRegistryEvent() {
        NewRegistryEvent event = new NewRegistryEvent();
        DataPackRegistryEvent.NewRegistry dataPackEvent = new DataPackRegistryEvent.NewRegistry();
        vanillaRegistryKeys = Set.copyOf(BuiltInRegistries.REGISTRY.keySet());
        ModLoader.postEventWrapContainerInModOrder((Event)event);
        ModLoader.postEventWrapContainerInModOrder((Event)dataPackEvent);
        event.fill();
        dataPackEvent.process();
        ModLoader.postEvent((Event)new ModifyRegistriesEvent());
        pendingModdedRegistries.removeIf(arg_0 -> ((Registry)BuiltInRegistries.REGISTRY).containsKey(arg_0));
        if (!pendingModdedRegistries.isEmpty()) {
            throw new IllegalStateException("The following registries were created but not registered to NewRegistryEvent:" + pendingModdedRegistries.stream().map(ResourceLocation::toString).collect(Collectors.joining("\n\t - ", "\n\t - ", "")));
        }
        pendingModdedRegistries = null;
    }

    public static void initDataMaps() {
        HashMap dataMapTypes = new HashMap();
        ModLoader.postEvent((Event)new RegisterDataMapTypesEvent(dataMapTypes));
        dataMaps = new IdentityHashMap();
        dataMapTypes.forEach((key, values) -> dataMaps.put((ResourceKey<Registry<?>>)key, Collections.unmodifiableMap(values)));
        dataMaps = Collections.unmodifiableMap(dataMapTypes);
    }

    static void takeVanillaSnapshot() {
        vanillaSnapshot = RegistryManager.takeSnapshot(SnapshotType.FULL);
    }

    static void takeFrozenSnapshot() {
        frozenSnapshot = RegistryManager.takeSnapshot(SnapshotType.SYNC_TO_CLIENT);
    }

    public static void revertToVanilla() {
        RegistryManager.applySnapshot(vanillaSnapshot, false, true);
    }

    public static void revertToFrozen() {
        RegistryManager.applySnapshot(frozenSnapshot, false, true);
    }

    public static Set<ResourceKey<?>> applySnapshot(Map<ResourceLocation, RegistrySnapshot> snapshots, boolean allowMissing, boolean isLocalWorld) {
        StringBuilder builder;
        ArrayList missingRegistries = allowMissing ? new ArrayList() : null;
        HashSet missingEntries = new HashSet();
        snapshots.forEach((registryName, snapshot) -> {
            if (!BuiltInRegistries.REGISTRY.containsKey(registryName)) {
                if (!allowMissing) {
                    throw new IllegalStateException("Tried to applied snapshot with registry name " + String.valueOf(registryName) + " but was not found");
                }
                missingRegistries.add(registryName);
                return;
            }
            MappedRegistry registry = (MappedRegistry)BuiltInRegistries.REGISTRY.getValue(registryName);
            RegistryManager.applySnapshot(registry, snapshot, missingEntries);
        });
        if (missingRegistries != null && !missingRegistries.isEmpty() && LOGGER.isWarnEnabled(REGISTRIES)) {
            builder = new StringBuilder("NeoForge detected missing/unknown registries.\n\n").append("There are ").append(missingRegistries.size()).append(" missing registries.\n");
            if (isLocalWorld) {
                builder.append("These missing registries will be deleted from the save file on next save.\n");
            }
            builder.append("Missing Registries:\n");
            for (ResourceLocation registryName2 : missingRegistries) {
                builder.append(registryName2).append("\n");
            }
            LOGGER.warn(REGISTRIES, builder.toString());
        }
        if (missingEntries.isEmpty()) {
            return Set.of();
        }
        LOGGER.debug(REGISTRIES, "There are {} mappings missing", (Object)missingEntries.size());
        if (isLocalWorld && LOGGER.isWarnEnabled(REGISTRIES)) {
            builder = new StringBuilder("NeoForge detected missing registry entries.\n\n").append("There are ").append(missingEntries.size()).append(" missing entries in this save.\n").append("These missing entries will be deleted from the save file on next save.");
            missingEntries.forEach(key -> builder.append("Missing ").append(key).append('\n'));
            LOGGER.warn(REGISTRIES, builder.toString());
        }
        return Set.copyOf(missingEntries);
    }

    private static <T> void applySnapshot(MappedRegistry<T> registry, RegistrySnapshot snapshot, Set<ResourceKey<?>> missing) {
        MappedRegistry<T> forgeRegistry = registry;
        ResourceKey registryKey = registry.key();
        Registry backup = snapshot.getFullBackup();
        forgeRegistry.unfreeze(false);
        if (backup == null) {
            forgeRegistry.clear(false);
            for (Int2ObjectMap.Entry entry : snapshot.getIds().int2ObjectEntrySet()) {
                ResourceKey key = ResourceKey.create((ResourceKey)registryKey, (ResourceLocation)((ResourceLocation)entry.getValue()));
                if (!registry.containsKey(key)) {
                    missing.add(key);
                    continue;
                }
                forgeRegistry.registerIdMapping(key, entry.getIntKey());
            }
        } else {
            forgeRegistry.clear(true);
            for (Map.Entry entry : backup.entrySet()) {
                ResourceKey key = (ResourceKey)entry.getKey();
                Object value = entry.getValue();
                registry.register(backup.getId(key), key, value, backup.registrationInfo(key).orElse(RegistrationInfo.BUILT_IN));
            }
        }
        snapshot.getAliases().forEach((arg_0, arg_1) -> registry.addAlias(arg_0, arg_1));
        forgeRegistry.freeze();
    }

    public static Map<ResourceLocation, RegistrySnapshot> takeSnapshot(SnapshotType snapshotType) {
        HashMap<ResourceLocation, RegistrySnapshot> map = new HashMap<ResourceLocation, RegistrySnapshot>();
        boolean full = snapshotType == SnapshotType.FULL;
        for (Registry registry : BuiltInRegistries.REGISTRY) {
            if (snapshotType == SnapshotType.SYNC_TO_CLIENT && !registry.doesSync()) continue;
            map.put(registry.key().location(), new RegistrySnapshot(registry, full));
        }
        return map;
    }

    public static List<FrozenRegistryPayload> generateRegistryPackets(boolean isLocal) {
        if (isLocal) {
            return List.of();
        }
        return RegistryManager.takeSnapshot(SnapshotType.SYNC_TO_CLIENT).entrySet().stream().map(e -> new FrozenRegistryPayload((ResourceLocation)e.getKey(), (RegistrySnapshot)e.getValue())).toList();
    }

    public static List<ResourceLocation> getRegistryNamesForSyncToClient() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        BuiltInRegistries.REGISTRY.entrySet().forEach(e -> {
            if (((Registry)e.getValue()).doesSync()) {
                list.add(((ResourceKey)e.getKey()).location());
            }
        });
        return list;
    }

    public static Set<ResourceLocation> getVanillaRegistryKeys() {
        return vanillaRegistryKeys;
    }

    @ApiStatus.Internal
    public static void handleKnownDataMapsReply(KnownRegistryDataMapsReplyPayload payload, IPayloadContext context) {
        context.channelHandlerContext().attr(ATTRIBUTE_KNOWN_DATA_MAPS).set(payload.dataMaps());
        context.finishCurrentTask(RegistryDataMapNegotiation.TYPE);
    }

    public static boolean isNonSyncedBuiltInRegistry(Registry<?> registry) {
        if (!BuiltInRegistries.REGISTRY.containsKey(registry.key())) {
            return false;
        }
        return !registry.doesSync();
    }

    public static enum SnapshotType {
        SYNC_TO_CLIENT,
        FULL;

    }
}

