/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.fluids.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredientType;
import net.neoforged.neoforge.fluids.crafting.display.FluidStackSlotDisplay;

public class DataComponentFluidIngredient
extends FluidIngredient {
    public static final MapCodec<DataComponentFluidIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.create((ResourceKey)Registries.FLUID, (Codec)BuiltInRegistries.FLUID.holderByNameCodec(), (boolean)false).fieldOf("fluids").forGetter(DataComponentFluidIngredient::fluidSet), (App)DataComponentPredicate.CODEC.fieldOf("components").forGetter(DataComponentFluidIngredient::components), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(DataComponentFluidIngredient::isStrict)).apply((Applicative)builder, DataComponentFluidIngredient::new));
    private final HolderSet<Fluid> fluids;
    private final DataComponentPredicate components;
    private final boolean strict;
    private final FluidStack[] stacks;

    public DataComponentFluidIngredient(HolderSet<Fluid> fluids, DataComponentPredicate components, boolean strict) {
        this.fluids = fluids;
        this.components = components;
        this.strict = strict;
        this.stacks = (FluidStack[])fluids.stream().map(i -> new FluidStack((Holder<Fluid>)i, 1000, components.asPatch())).toArray(FluidStack[]::new);
    }

    @Override
    public boolean test(FluidStack stack) {
        if (this.strict) {
            for (FluidStack stack2 : this.stacks) {
                if (!FluidStack.isSameFluidSameComponents(stack, stack2)) continue;
                return true;
            }
            return false;
        }
        return this.fluids.contains(stack.getFluidHolder()) && this.components.test((DataComponentHolder)stack);
    }

    @Override
    public Stream<Holder<Fluid>> generateFluids() {
        return this.fluids.stream();
    }

    @Override
    public SlotDisplay display() {
        return new SlotDisplay.Composite(Stream.of(this.stacks).map(stack -> new FluidStackSlotDisplay((FluidStack)stack)).toList());
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public FluidIngredientType<?> getType() {
        return NeoForgeMod.DATA_COMPONENT_FLUID_INGREDIENT_TYPE.get();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluids, this.components, this.strict);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataComponentFluidIngredient)) {
            return false;
        }
        DataComponentFluidIngredient other = (DataComponentFluidIngredient)obj;
        return other.fluids.equals(this.fluids) && other.components.equals((Object)this.components) && other.strict == this.strict;
    }

    public HolderSet<Fluid> fluidSet() {
        return this.fluids;
    }

    public DataComponentPredicate components() {
        return this.components;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static FluidIngredient of(boolean strict, FluidStack stack) {
        return DataComponentFluidIngredient.of(strict, (DataComponentMap)stack.getComponents(), stack.getFluid());
    }

    public static <T> FluidIngredient of(boolean strict, DataComponentType<? super T> type, T value, Fluid ... fluids) {
        return DataComponentFluidIngredient.of(strict, DataComponentPredicate.builder().expect(type, value).build(), fluids);
    }

    public static <T> FluidIngredient of(boolean strict, Supplier<? extends DataComponentType<? super T>> type, T value, Fluid ... fluids) {
        return DataComponentFluidIngredient.of(strict, type.get(), value, fluids);
    }

    public static FluidIngredient of(boolean strict, DataComponentMap map, Fluid ... fluids) {
        return DataComponentFluidIngredient.of(strict, DataComponentPredicate.allOf((DataComponentMap)map), fluids);
    }

    @SafeVarargs
    public static FluidIngredient of(boolean strict, DataComponentMap map, Holder<Fluid> ... fluids) {
        return DataComponentFluidIngredient.of(strict, DataComponentPredicate.allOf((DataComponentMap)map), fluids);
    }

    public static FluidIngredient of(boolean strict, DataComponentMap map, HolderSet<Fluid> fluids) {
        return DataComponentFluidIngredient.of(strict, DataComponentPredicate.allOf((DataComponentMap)map), fluids);
    }

    @SafeVarargs
    public static FluidIngredient of(boolean strict, DataComponentPredicate predicate, Holder<Fluid> ... fluids) {
        return DataComponentFluidIngredient.of(strict, predicate, (HolderSet<Fluid>)HolderSet.direct(fluids));
    }

    public static FluidIngredient of(boolean strict, DataComponentPredicate predicate, Fluid ... fluids) {
        return DataComponentFluidIngredient.of(strict, predicate, (HolderSet<Fluid>)HolderSet.direct(Arrays.stream(fluids).map(Fluid::builtInRegistryHolder).toList()));
    }

    public static FluidIngredient of(boolean strict, DataComponentPredicate predicate, HolderSet<Fluid> fluids) {
        return new DataComponentFluidIngredient(fluids, predicate, strict);
    }
}

