/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.extensions;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.NeoForgeConfig;
import net.neoforged.neoforge.common.util.AttributeUtil;
import org.jetbrains.annotations.Nullable;

public interface IAttributeExtension {
    public static final DecimalFormat FORMAT = (DecimalFormat)Util.make((Object)new DecimalFormat("#.##"), fmt -> fmt.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    default public MutableComponent toValueComponent(@Nullable AttributeModifier.Operation op, double value, TooltipFlag flag) {
        if (IAttributeExtension.isNullOrAddition(op)) {
            return Component.translatable((String)"neoforge.value.flat", (Object[])new Object[]{FORMAT.format(value)});
        }
        return Component.translatable((String)"neoforge.value.percent", (Object[])new Object[]{FORMAT.format(value * 100.0)});
    }

    default public MutableComponent toComponent(AttributeModifier modif, TooltipFlag flag) {
        Attribute attr = this.self();
        double value = modif.amount();
        String key = value > 0.0 ? "neoforge.modifier.plus" : "neoforge.modifier.take";
        ChatFormatting color = attr.getStyle(value > 0.0);
        MutableComponent attrDesc = Component.translatable((String)attr.getDescriptionId());
        MutableComponent valueComp = this.toValueComponent(modif.operation(), value, flag);
        MutableComponent comp = Component.translatable((String)key, (Object[])new Object[]{valueComp, attrDesc}).withStyle(color);
        return comp.append(this.getDebugInfo(modif, flag));
    }

    default public Component getDebugInfo(AttributeModifier modif, TooltipFlag flag) {
        Component debugInfo = CommonComponents.EMPTY;
        if (flag.isAdvanced() && ((Boolean)NeoForgeConfig.COMMON.attributeAdvancedTooltipDebugInfo.get()).booleanValue()) {
            double advValue = (double)(modif.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? 1 : 0) + modif.amount();
            String valueStr = FORMAT.format(advValue);
            String txt = switch (modif.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> String.format(Locale.ROOT, advValue > 0.0 ? "[+%s]" : "[%s]", valueStr);
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> String.format(Locale.ROOT, advValue > 0.0 ? "[+%sx]" : "[%sx]", valueStr);
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> String.format(Locale.ROOT, "[x%s]", valueStr);
            };
            debugInfo = Component.literal((String)" ").append((Component)Component.literal((String)txt).withStyle(ChatFormatting.GRAY));
        }
        return debugInfo;
    }

    @Nullable
    default public ResourceLocation getBaseId() {
        if (this == Attributes.ATTACK_DAMAGE.value()) {
            return AttributeUtil.BASE_ATTACK_DAMAGE_ID;
        }
        if (this == Attributes.ATTACK_SPEED.value()) {
            return AttributeUtil.BASE_ATTACK_SPEED_ID;
        }
        if (this == Attributes.ENTITY_INTERACTION_RANGE.value()) {
            return AttributeUtil.BASE_ENTITY_REACH_ID;
        }
        return null;
    }

    default public MutableComponent toBaseComponent(double value, double entityBase, boolean merged, TooltipFlag flag) {
        Attribute attr = this.self();
        MutableComponent comp = Component.translatable((String)"attribute.modifier.equals.0", (Object[])new Object[]{FORMAT.format(value), Component.translatable((String)attr.getDescriptionId())});
        if (flag.isAdvanced() && !merged && ((Boolean)NeoForgeConfig.COMMON.attributeAdvancedTooltipDebugInfo.get()).booleanValue()) {
            double baseBonus = value - entityBase;
            String baseBonusText = String.format(Locale.ROOT, baseBonus > 0.0 ? " + %s" : " - %s", FORMAT.format(Math.abs(baseBonus)));
            MutableComponent debugInfo = Component.translatable((String)"neoforge.attribute.debug.base", (Object[])new Object[]{FORMAT.format(entityBase), baseBonusText}).withStyle(ChatFormatting.GRAY);
            comp.append(CommonComponents.SPACE).append((Component)debugInfo);
        }
        return comp;
    }

    public TextColor getMergedStyle(boolean var1);

    public static boolean isNullOrAddition(@Nullable AttributeModifier.Operation op) {
        return op == null || op == AttributeModifier.Operation.ADD_VALUE;
    }

    private Attribute self() {
        return (Attribute)this;
    }
}

