/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.color.item.Constant;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.color.item.FluidContentsTint;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.UnbakedCompositeModel;
import net.neoforged.neoforge.client.model.UnbakedElementsHelper;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DynamicFluidContainerModel
implements ItemModel {
    private static final Transformation FLUID_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.002f), new Quaternionf());
    private static final Transformation COVER_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.004f), new Quaternionf());
    private final Unbaked unbakedModel;
    private final ItemModel.BakingContext bakingContext;
    private final ItemTransforms itemTransforms;
    private final Map<Fluid, ItemModel> cache = new IdentityHashMap<Fluid, ItemModel>();

    private static RenderTypeGroup getLayerRenderTypes(boolean unlit) {
        return new RenderTypeGroup(RenderType.translucent(), unlit ? NeoForgeRenderTypes.ITEM_UNSORTED_UNLIT_TRANSLUCENT.get() : NeoForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    private DynamicFluidContainerModel(Unbaked unbakedModel, ItemModel.BakingContext bakingContext) {
        this.unbakedModel = unbakedModel;
        this.bakingContext = bakingContext;
        UnbakedModel baseItemModel = bakingContext.blockModelBaker().getModel(ResourceLocation.withDefaultNamespace((String)"item/generated"));
        if (baseItemModel == null) {
            throw new IllegalStateException("Failed to access item/generated model");
        }
        this.itemTransforms = baseItemModel.getTransforms();
    }

    private ItemModel bakeModelForFluid(Fluid fluid) {
        List<BakedQuad> quads;
        List<BlockElement> unbaked;
        SimpleModelState transformedState;
        TextureAtlasSprite particleSprite;
        SpriteGetter sprites = this.bakingContext.blockModelBaker().sprites();
        Material particleLocation = this.unbakedModel.textures.particle.map(ClientHooks::getBlockMaterial).orElse(null);
        Material baseLocation = this.unbakedModel.textures.base.map(ClientHooks::getBlockMaterial).orElse(null);
        Material fluidMaskLocation = this.unbakedModel.textures.fluid.map(ClientHooks::getBlockMaterial).orElse(null);
        Material coverLocation = this.unbakedModel.textures.cover.map(ClientHooks::getBlockMaterial).orElse(null);
        TextureAtlasSprite baseSprite = baseLocation != null ? sprites.get(baseLocation) : null;
        TextureAtlasSprite fluidSprite = fluid != Fluids.EMPTY ? sprites.get(ClientHooks.getBlockMaterial(IClientFluidTypeExtensions.of(fluid).getStillTexture())) : null;
        TextureAtlasSprite coverSprite = coverLocation != null && (!this.unbakedModel.coverIsMask || baseLocation != null) ? sprites.get(coverLocation) : null;
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? sprites.get(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null && !this.unbakedModel.coverIsMask) {
            particleSprite = coverSprite;
        }
        Object state = BlockModelRotation.X0_Y0;
        if (this.unbakedModel.flipGas && fluid != Fluids.EMPTY && fluid.getFluidType().isLighterThanAir()) {
            state = new SimpleModelState(state.getRotation().compose(new Transformation(null, new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        UnbakedCompositeModel.Baked.Builder modelBuilder = UnbakedCompositeModel.Baked.builder(true, false, false, particleSprite, this.itemTransforms);
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes(false);
        if (baseLocation != null) {
            List<BlockElement> unbaked2 = UnbakedElementsHelper.createUnbakedItemElements(0, baseSprite);
            List<BakedQuad> quads2 = UnbakedElementsHelper.bakeElements(unbaked2, $ -> baseSprite, (ModelState)state);
            modelBuilder.addQuads(normalRenderTypes, quads2);
        }
        if (fluidMaskLocation != null && fluidSprite != null) {
            TextureAtlasSprite templateSprite = sprites.get(fluidMaskLocation);
            transformedState = new SimpleModelState(state.getRotation().compose(FLUID_TRANSFORM), state.isUvLocked());
            unbaked = UnbakedElementsHelper.createUnbakedItemMaskElements(1, templateSprite);
            quads = UnbakedElementsHelper.bakeElements(unbaked, $ -> fluidSprite, transformedState);
            boolean emissive = this.unbakedModel.applyFluidLuminosity && fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = DynamicFluidContainerModel.getLayerRenderTypes(emissive);
            if (emissive) {
                QuadTransformers.settingMaxEmissivity().processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, quads);
        }
        if (coverSprite != null) {
            TextureAtlasSprite sprite = this.unbakedModel.coverIsMask ? baseSprite : coverSprite;
            transformedState = new SimpleModelState(state.getRotation().compose(COVER_TRANSFORM), state.isUvLocked());
            unbaked = UnbakedElementsHelper.createUnbakedItemMaskElements(2, coverSprite);
            quads = UnbakedElementsHelper.bakeElements(unbaked, $ -> sprite, transformedState);
            modelBuilder.addQuads(normalRenderTypes, quads);
        }
        modelBuilder.setParticle(particleSprite);
        return new BlockModelWrapper(modelBuilder.build(), List.of(new Constant(-1), FluidContentsTint.INSTANCE));
    }

    public void update(ItemStackRenderState renderState, ItemStack stack, ItemModelResolver modelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable LivingEntity entity, int p_387820_) {
        Fluid fluid = FluidUtil.getFluidContained(stack).map(FluidStack::getFluid).orElse(this.unbakedModel.fluid);
        this.cache.computeIfAbsent(fluid, this::bakeModelForFluid).update(renderState, stack, modelResolver, displayContext, level, entity, p_387820_);
    }

    public record Unbaked(Textures textures, Fluid fluid, boolean flipGas, boolean coverIsMask, boolean applyFluidLuminosity) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Textures.CODEC.fieldOf("textures").forGetter(Unbaked::textures), (App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("fluid").forGetter(Unbaked::fluid), (App)Codec.BOOL.optionalFieldOf("flip_gas", (Object)false).forGetter(Unbaked::flipGas), (App)Codec.BOOL.optionalFieldOf("cover_is_mask", (Object)true).forGetter(Unbaked::coverIsMask), (App)Codec.BOOL.optionalFieldOf("apply_fluid_luminosity", (Object)true).forGetter(Unbaked::applyFluidLuminosity)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<? extends ItemModel.Unbaked> type() {
            return MAP_CODEC;
        }

        public ItemModel bake(ItemModel.BakingContext bakingContext) {
            return new DynamicFluidContainerModel(this, bakingContext);
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
        }
    }

    public record Textures(Optional<ResourceLocation> particle, Optional<ResourceLocation> base, Optional<ResourceLocation> fluid, Optional<ResourceLocation> cover) {
        public static final Codec<Textures> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("particle").forGetter(Textures::particle), (App)ResourceLocation.CODEC.optionalFieldOf("base").forGetter(Textures::base), (App)ResourceLocation.CODEC.optionalFieldOf("fluid").forGetter(Textures::fluid), (App)ResourceLocation.CODEC.optionalFieldOf("cover").forGetter(Textures::cover)).apply((Applicative)instance, Textures::new)).validate(textures -> {
            if (textures.particle.isPresent() || textures.base.isPresent() || textures.fluid.isPresent() || textures.cover.isPresent()) {
                return DataResult.success((Object)textures);
            }
            return DataResult.error(() -> "Dynamic fluid container model requires at least one particle, base, fluid or cover texture.");
        });
    }
}

