/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.generators.template;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.client.model.ExtraFaceData;
import net.neoforged.neoforge.client.model.generators.template.FaceRotation;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public final class FaceBuilder {
    @Nullable
    private Direction cullface;
    private int tintindex = -1;
    @Nullable
    private TextureSlot texture = null;
    private float @Nullable [] uvs;
    private FaceRotation rotation = FaceRotation.ZERO;
    private int color = -1;
    private int blockLight = 0;
    private int skyLight = 0;
    private boolean hasAmbientOcclusion = true;

    public FaceBuilder cullface(@Nullable Direction dir) {
        this.cullface = dir;
        return this;
    }

    public FaceBuilder tintindex(int index) {
        this.tintindex = index;
        return this;
    }

    public FaceBuilder texture(TextureSlot texture) {
        Preconditions.checkNotNull((Object)texture, (Object)"Texture must not be null");
        this.texture = texture;
        return this;
    }

    public FaceBuilder uvs(float u1, float v1, float u2, float v2) {
        this.uvs = new float[]{u1, v1, u2, v2};
        return this;
    }

    public FaceBuilder rotation(FaceRotation rot) {
        Preconditions.checkNotNull((Object)((Object)rot), (Object)"Rotation must not be null");
        this.rotation = rot;
        return this;
    }

    public FaceBuilder emissivity(int blockLight, int skyLight) {
        this.blockLight = blockLight;
        this.skyLight = skyLight;
        return this;
    }

    public FaceBuilder color(int color) {
        this.color = color;
        return this;
    }

    public FaceBuilder ambientOcclusion(boolean ambientOcclusion) {
        this.hasAmbientOcclusion = ambientOcclusion;
        return this;
    }

    BlockElementFace build() {
        if (this.texture == null) {
            throw new IllegalStateException("A model face must have a texture");
        }
        return new BlockElementFace(this.cullface, this.tintindex, this.texture.toString(), new BlockFaceUV(this.uvs, this.rotation.rotation), new ExtraFaceData(this.color, this.blockLight, this.skyLight, this.hasAmbientOcclusion), new MutableObject());
    }

    FaceBuilder copy() {
        FaceBuilder builder = new FaceBuilder();
        builder.texture = this.texture;
        builder.color = this.color;
        builder.cullface = this.cullface;
        builder.tintindex = this.tintindex;
        builder.uvs = this.uvs != null ? Arrays.copyOf(this.uvs, this.uvs.length) : null;
        builder.rotation = this.rotation;
        builder.blockLight = this.blockLight;
        builder.skyLight = this.skyLight;
        builder.hasAmbientOcclusion = this.hasAmbientOcclusion;
        return builder;
    }
}

