/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model;

import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.util.context.ContextMap;
import net.neoforged.neoforge.client.model.ExtendedUnbakedModel;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;
import net.neoforged.neoforge.client.model.StandardModelParameters;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractUnbakedModel
implements ExtendedUnbakedModel {
    protected final StandardModelParameters parameters;
    private UnbakedModel parent;

    protected AbstractUnbakedModel(StandardModelParameters parameters) {
        this.parameters = parameters;
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        if (this.parameters.parent() != null) {
            this.parent = resolver.resolve(this.parameters.parent());
        }
    }

    @Nullable
    public Boolean getAmbientOcclusion() {
        return this.parameters.ambientOcclusion();
    }

    @Nullable
    public UnbakedModel.GuiLight getGuiLight() {
        return this.parameters.guiLight();
    }

    @Nullable
    public ItemTransforms getTransforms() {
        return this.parameters.itemTransforms();
    }

    public TextureSlots.Data getTextureSlots() {
        return this.parameters.textures();
    }

    @Nullable
    public UnbakedModel getParent() {
        return this.parent;
    }

    public void fillAdditionalProperties(ContextMap.Builder propertiesBuilder) {
        NeoForgeModelProperties.fillRootTransformProperty(propertiesBuilder, this.parameters.rootTransform());
        NeoForgeModelProperties.fillRenderTypeProperty(propertiesBuilder, this.parameters.renderTypeGroup());
        NeoForgeModelProperties.fillPartVisibilityProperty(propertiesBuilder, this.parameters.partVisibility());
    }
}

