/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.gui;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.i18n.FMLTranslations;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LoadingErrorScreen
extends ErrorScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path modsDir;
    private final Path logFile;
    private final List<FormattedIssue> modLoadErrors;
    private final List<FormattedIssue> modLoadWarnings;
    @Nullable
    private final Path dumpedLocation;
    private final Runnable nextScreenTask;
    private LoadingEntryList entryList;
    private Component errorHeader;
    private Component warningHeader;

    public LoadingErrorScreen(List<ModLoadingIssue> issues, @Nullable File dumpedLocation, Runnable nextScreenTask) {
        super((Component)Component.literal((String)"Loading Error"), null);
        this.modLoadWarnings = issues.stream().filter(issue -> issue.severity() == ModLoadingIssue.Severity.WARNING).map(FormattedIssue::of).toList();
        this.modLoadErrors = issues.stream().filter(issue -> issue.severity() == ModLoadingIssue.Severity.ERROR).map(FormattedIssue::of).toList();
        this.modsDir = FMLPaths.MODSDIR.get();
        this.logFile = FMLPaths.GAMEDIR.get().resolve(Paths.get("logs", "latest.log"));
        this.dumpedLocation = dumpedLocation != null ? dumpedLocation.toPath() : null;
        this.nextScreenTask = nextScreenTask;
    }

    public void init() {
        super.init();
        this.clearWidgets();
        this.errorHeader = Component.literal((String)(String.valueOf(ChatFormatting.RED) + FMLTranslations.parseMessage((String)"fml.loadingerrorscreen.errorheader", (Object[])new Object[]{this.modLoadErrors.size()}) + String.valueOf(ChatFormatting.RESET)));
        this.warningHeader = Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + FMLTranslations.parseMessage((String)"fml.loadingerrorscreen.warningheader", (Object[])new Object[]{this.modLoadWarnings.size()}) + String.valueOf(ChatFormatting.RESET)));
        int yOffset = 46;
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(50, this.height - yOffset, this.width / 2 - 55, 20, (Component)Component.literal((String)FMLTranslations.parseMessage((String)"fml.button.open.mods.folder", (Object[])new Object[0])), b -> Util.getPlatform().openFile(this.modsDir.toFile())));
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 + 5, this.height - yOffset, this.width / 2 - 55, 20, (Component)Component.literal((String)FMLTranslations.parseMessage((String)"fml.button.open.log", (Object[])new Object[0])), b -> Util.getPlatform().openFile(this.logFile.toFile())));
        if (this.modLoadErrors.isEmpty()) {
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(50, this.height - 24, this.width / 2 - 55, 20, (Component)Component.literal((String)FMLTranslations.parseMessage((String)"fml.button.continue.launch", (Object[])new Object[0])), b -> this.nextScreenTask.run()));
        } else {
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(50, this.height - 24, this.width / 2 - 55, 20, (Component)Component.literal((String)FMLTranslations.parseMessage((String)"fml.button.open.crashreport", (Object[])new Object[0])), b -> Util.getPlatform().openFile(this.dumpedLocation.toFile())));
        }
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 + 5, this.height - 24, this.width / 2 - 55, 20, (Component)Component.translatable((String)"menu.quit"), b -> this.minecraft.stop()));
        this.entryList = new LoadingEntryList(this, this.modLoadErrors, this.modLoadWarnings);
        this.addWidget((GuiEventListener)this.entryList);
        this.setFocused((GuiEventListener)this.entryList);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.entryList.render(guiGraphics, mouseX, mouseY, partialTick);
        this.drawMultiLineCenteredString(guiGraphics, this.font, this.modLoadErrors.isEmpty() ? this.warningHeader : this.errorHeader, this.width / 2, 10);
        this.renderables.forEach(button -> button.render(guiGraphics, mouseX, mouseY, partialTick));
    }

    private void drawMultiLineCenteredString(GuiGraphics guiGraphics, Font fr, Component str, int x, int y) {
        for (FormattedCharSequence s : fr.split((FormattedText)str, this.width)) {
            guiGraphics.drawString(fr, s, (float)((double)x - (double)fr.width(s) / 2.0), (float)y, 0xFFFFFF, true);
            Objects.requireNonNull(fr);
            y += 9;
        }
    }

    public static class LoadingEntryList
    extends ObjectSelectionList<LoadingMessageEntry> {
        LoadingEntryList(LoadingErrorScreen parent, List<FormattedIssue> errors, List<FormattedIssue> warnings) {
            boolean both;
            int n = parent.width;
            int n2 = parent.height - 85;
            int n3 = Math.max(errors.stream().mapToInt(error -> parent.font.split((FormattedText)error.text, parent.width - 20).size()).max().orElse(0), warnings.stream().mapToInt(warning -> parent.font.split((FormattedText)warning.text, parent.width - 20).size()).max().orElse(0));
            Objects.requireNonNull(((LoadingErrorScreen)parent).minecraft.font);
            super(Objects.requireNonNull(parent.minecraft), n, n2, 35, n3 * 9 + 8);
            boolean bl = both = !errors.isEmpty() && !warnings.isEmpty();
            if (both) {
                this.addEntry((AbstractSelectionList.Entry)new LoadingMessageEntry(parent.errorHeader, true));
            }
            errors.forEach(e -> this.addEntry((AbstractSelectionList.Entry)new LoadingMessageEntry(e.text)));
            if (both) {
                this.addEntry((AbstractSelectionList.Entry)new LoadingMessageEntry(parent.warningHeader, true));
            }
            warnings.forEach(w -> this.addEntry((AbstractSelectionList.Entry)new LoadingMessageEntry(w.text)));
        }

        protected int scrollBarX() {
            return this.getRight() - 6;
        }

        public int getRowWidth() {
            return this.width - 15;
        }

        public class LoadingMessageEntry
        extends ObjectSelectionList.Entry<LoadingMessageEntry> {
            private final Component message;
            private final boolean center;

            LoadingMessageEntry(Component message) {
                this(message, false);
            }

            LoadingMessageEntry(Component message, boolean center) {
                this.message = Objects.requireNonNull(message);
                this.center = center;
            }

            public Component getNarration() {
                return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.message});
            }

            public void render(GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTick) {
                Font font = Minecraft.getInstance().font;
                List strings = font.split((FormattedText)this.message, LoadingEntryList.this.width - 20);
                int y = top + 2;
                for (FormattedCharSequence string : strings) {
                    if (this.center) {
                        guiGraphics.drawString(font, string, (float)left + (float)(LoadingEntryList.this.width - font.width(string)) / 2.0f, (float)y, 0xFFFFFF, false);
                    } else {
                        guiGraphics.drawString(font, string, left + 5, y, 0xFFFFFF, false);
                    }
                    Objects.requireNonNull(font);
                    y += 9;
                }
            }
        }
    }

    private record FormattedIssue(Component text, ModLoadingIssue issue) {
        public static FormattedIssue of(ModLoadingIssue issue) {
            return new FormattedIssue((Component)Component.literal((String)FMLTranslations.translateIssue((ModLoadingIssue)issue)), issue);
        }
    }
}

