/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.world;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import net.neoforged.neoforge.network.payload.AuxiliaryLightDataPayload;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LevelChunkAuxiliaryLightManager
implements AuxiliaryLightManager,
INBTSerializable<ListTag> {
    public static final String LIGHT_NBT_KEY = "neoforge:aux_lights";
    private final LevelChunk owner;
    private final Map<BlockPos, Byte> lights = new ConcurrentHashMap<BlockPos, Byte>();

    public LevelChunkAuxiliaryLightManager(LevelChunk owner) {
        this.owner = owner;
    }

    @Override
    public void setLightAt(BlockPos pos, int value) {
        pos = pos.immutable();
        Byte oldValue = (value = Mth.clamp((int)value, (int)0, (int)15)) > 0 ? this.lights.put(pos, (byte)value) : this.lights.remove(pos);
        if (Objects.requireNonNullElse(oldValue, (byte)0) != value) {
            this.owner.getLevel().getChunkSource().getLightEngine().checkBlock(pos);
            this.owner.markUnsaved();
        }
    }

    @Override
    public int getLightAt(BlockPos pos) {
        return this.lights.getOrDefault(pos, (byte)0).byteValue();
    }

    @Override
    @Nullable
    public ListTag serializeNBT(HolderLookup.Provider provider) {
        if (this.lights.isEmpty()) {
            return null;
        }
        ListTag list = new ListTag();
        this.lights.forEach((pos, light) -> {
            CompoundTag tag = new CompoundTag();
            tag.putLong("pos", pos.asLong());
            tag.putByte("level", light.byteValue());
            list.add((Object)tag);
        });
        return list;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.getCompound(i);
            this.lights.put(BlockPos.of((long)tag.getLong("pos")), tag.getByte("level"));
        }
    }

    public Packet<?> sendLightDataTo(ClientboundLevelChunkWithLightPacket chunkPacket) {
        return new ClientboundBundlePacket(List.of(chunkPacket, new ClientboundCustomPayloadPacket((CustomPacketPayload)new AuxiliaryLightDataPayload(this.owner.getPos(), Map.copyOf(this.lights)))));
    }

    public void handleLightDataSync(Map<BlockPos, Byte> lights) {
        this.lights.clear();
        this.lights.putAll(lights);
    }
}

