/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class DataComponentIngredient
implements ICustomIngredient {
    public static final MapCodec<DataComponentIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.create((ResourceKey)Registries.ITEM, (Codec)BuiltInRegistries.ITEM.holderByNameCodec(), (boolean)false).fieldOf("items").forGetter(DataComponentIngredient::itemSet), (App)DataComponentPredicate.CODEC.fieldOf("components").forGetter(DataComponentIngredient::components), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(DataComponentIngredient::isStrict)).apply((Applicative)builder, DataComponentIngredient::new));
    private final HolderSet<Item> items;
    private final DataComponentPredicate components;
    private final boolean strict;
    private final ItemStack[] stacks;

    public DataComponentIngredient(HolderSet<Item> items, DataComponentPredicate components, boolean strict) {
        this.items = items;
        this.components = components;
        this.strict = strict;
        this.stacks = (ItemStack[])items.stream().map(i -> new ItemStack(i, 1, components.asPatch())).toArray(ItemStack[]::new);
    }

    @Override
    public boolean test(ItemStack stack) {
        if (this.strict) {
            for (ItemStack stack2 : this.stacks) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stack2)) continue;
                return true;
            }
            return false;
        }
        return this.items.contains(stack.getItemHolder()) && this.components.test((DataComponentHolder)stack);
    }

    @Override
    public Stream<Holder<Item>> items() {
        return this.items.stream();
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public IngredientType<?> getType() {
        return NeoForgeMod.DATA_COMPONENT_INGREDIENT_TYPE.get();
    }

    @Override
    public SlotDisplay display() {
        return new SlotDisplay.Composite(Stream.of(this.stacks).map(stack -> {
            SlotDisplay.ItemStackSlotDisplay display = new SlotDisplay.ItemStackSlotDisplay(stack);
            ItemStack remainder = stack.getCraftingRemainder();
            if (!remainder.isEmpty()) {
                SlotDisplay.ItemStackSlotDisplay remainderDisplay = new SlotDisplay.ItemStackSlotDisplay(remainder);
                return new SlotDisplay.WithRemainder((SlotDisplay)display, (SlotDisplay)remainderDisplay);
            }
            return display;
        }).toList());
    }

    public HolderSet<Item> itemSet() {
        return this.items;
    }

    public DataComponentPredicate components() {
        return this.components;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static Ingredient of(boolean strict, ItemStack stack) {
        return DataComponentIngredient.of(strict, stack.getComponents(), new ItemLike[]{stack.getItem()});
    }

    public static <T> Ingredient of(boolean strict, DataComponentType<? super T> type, T value, ItemLike ... items) {
        return DataComponentIngredient.of(strict, DataComponentPredicate.builder().expect(type, value).build(), items);
    }

    public static <T> Ingredient of(boolean strict, Supplier<? extends DataComponentType<? super T>> type, T value, ItemLike ... items) {
        return DataComponentIngredient.of(strict, type.get(), value, items);
    }

    public static Ingredient of(boolean strict, DataComponentMap map, ItemLike ... items) {
        return DataComponentIngredient.of(strict, DataComponentPredicate.allOf((DataComponentMap)map), items);
    }

    @SafeVarargs
    public static Ingredient of(boolean strict, DataComponentMap map, Holder<Item> ... items) {
        return DataComponentIngredient.of(strict, DataComponentPredicate.allOf((DataComponentMap)map), items);
    }

    public static Ingredient of(boolean strict, DataComponentMap map, HolderSet<Item> items) {
        return DataComponentIngredient.of(strict, DataComponentPredicate.allOf((DataComponentMap)map), items);
    }

    @SafeVarargs
    public static Ingredient of(boolean strict, DataComponentPredicate predicate, Holder<Item> ... items) {
        return DataComponentIngredient.of(strict, predicate, (HolderSet<Item>)HolderSet.direct(items));
    }

    public static Ingredient of(boolean strict, DataComponentPredicate predicate, ItemLike ... items) {
        return DataComponentIngredient.of(strict, predicate, (HolderSet<Item>)HolderSet.direct(Arrays.stream(items).map(ItemLike::asItem).map(Item::builtInRegistryHolder).toList()));
    }

    public static Ingredient of(boolean strict, DataComponentPredicate predicate, HolderSet<Item> items) {
        return new DataComponentIngredient(items, predicate, strict).toVanilla();
    }
}

