/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model;

import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.model.ExtraFaceData;
import net.neoforged.neoforge.client.model.IModelBuilder;
import net.neoforged.neoforge.client.model.SimpleModelState;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public final class UnbakedElementsHelper {
    private static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();

    private UnbakedElementsHelper() {
    }

    public static List<BlockElement> createUnbakedItemElements(int layerIndex, TextureAtlasSprite sprite) {
        return UnbakedElementsHelper.createUnbakedItemElements(layerIndex, sprite, null);
    }

    public static List<BlockElement> createUnbakedItemElements(int layerIndex, TextureAtlasSprite sprite, @Nullable ExtraFaceData faceData) {
        List elements = ITEM_MODEL_GENERATOR.processFrames(layerIndex, "layer" + layerIndex, sprite.contents());
        ClientHooks.fixItemModelSeams(elements, sprite);
        if (faceData != null) {
            elements.forEach(element -> element.setFaceData(faceData));
        }
        return elements;
    }

    public static List<BlockElement> createUnbakedItemMaskElements(int layerIndex, TextureAtlasSprite sprite) {
        return UnbakedElementsHelper.createUnbakedItemMaskElements(layerIndex, sprite, null);
    }

    public static List<BlockElement> createUnbakedItemMaskElements(int layerIndex, TextureAtlasSprite sprite, @Nullable ExtraFaceData faceData) {
        List<BlockElement> elements = UnbakedElementsHelper.createUnbakedItemElements(layerIndex, sprite, faceData);
        elements.removeFirst();
        float expand = -sprite.uvShrinkRatio();
        SpriteContents spriteContents = sprite.contents();
        int width = spriteContents.width();
        int height = spriteContents.height();
        BitSet bits = new BitSet(width * height);
        spriteContents.getUniqueFrames().forEach(frame -> {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (spriteContents.isTransparent(frame, x, y)) continue;
                    bits.set(x + y * width);
                }
            }
        });
        for (int y = 0; y < height; ++y) {
            int xStart = -1;
            for (int x = 0; x < width; ++x) {
                int yEnd;
                boolean opaque = bits.get(x + y * width);
                if (opaque != (xStart == -1)) continue;
                if (xStart == -1) {
                    xStart = x;
                    continue;
                }
                block2: for (yEnd = y + 1; yEnd < height; ++yEnd) {
                    for (int x2 = xStart; x2 <= x; ++x2) {
                        if (!bits.get(x2 + yEnd * width)) break block2;
                    }
                }
                for (int i = xStart; i < x; ++i) {
                    for (int j = y; j < yEnd; ++j) {
                        bits.clear(i + j * width);
                    }
                }
                BlockElement element = new BlockElement(new Vector3f((float)(16 * xStart) / (float)width, 16.0f - (float)(16 * yEnd) / (float)height, 7.5f), new Vector3f((float)(16 * x) / (float)width, 16.0f - (float)(16 * y) / (float)height, 8.5f), Map.of(Direction.NORTH, new BlockElementFace(null, layerIndex, "layer" + layerIndex, new BlockFaceUV(null, 0)), Direction.SOUTH, new BlockElementFace(null, layerIndex, "layer" + layerIndex, new BlockFaceUV(null, 0))), null, true, 0);
                element.from.x = Mth.clamp((float)Mth.lerp((float)expand, (float)element.from.x, (float)8.0f), (float)0.0f, (float)16.0f);
                element.from.y = Mth.clamp((float)Mth.lerp((float)expand, (float)element.from.y, (float)8.0f), (float)0.0f, (float)16.0f);
                element.to.x = Mth.clamp((float)Mth.lerp((float)expand, (float)element.to.x, (float)8.0f), (float)0.0f, (float)16.0f);
                element.to.y = Mth.clamp((float)Mth.lerp((float)expand, (float)element.to.y, (float)8.0f), (float)0.0f, (float)16.0f);
                element.faces.forEach((dir, face) -> {
                    float[] uv = face.uv().uvs;
                    float centerU = (uv[0] + uv[0] + uv[2] + uv[2]) / 4.0f;
                    uv[0] = Mth.clamp((float)Mth.lerp((float)expand, (float)uv[0], (float)centerU), (float)0.0f, (float)16.0f);
                    uv[2] = Mth.clamp((float)Mth.lerp((float)expand, (float)uv[2], (float)centerU), (float)0.0f, (float)16.0f);
                    float centerV = (uv[1] + uv[1] + uv[3] + uv[3]) / 4.0f;
                    uv[1] = Mth.clamp((float)Mth.lerp((float)expand, (float)uv[1], (float)centerV), (float)0.0f, (float)16.0f);
                    uv[3] = Mth.clamp((float)Mth.lerp((float)expand, (float)uv[3], (float)centerV), (float)0.0f, (float)16.0f);
                });
                elements.add(element);
                xStart = -1;
            }
        }
        return elements;
    }

    public static void bakeElements(IModelBuilder<?> builder, List<BlockElement> elements, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState) {
        for (BlockElement element : elements) {
            element.faces.forEach((side, face) -> {
                TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.parse((String)face.texture())));
                BakedQuad quad = SimpleBakedModel.bakeFace((BlockElement)element, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)side, (ModelState)modelState);
                if (face.cullForDirection() == null) {
                    builder.addUnculledFace(quad);
                } else {
                    builder.addCulledFace(Direction.rotate((Matrix4f)modelState.getRotation().getMatrix(), (Direction)face.cullForDirection()), quad);
                }
            });
        }
    }

    public static List<BakedQuad> bakeElements(List<BlockElement> elements, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState) {
        if (elements.isEmpty()) {
            return List.of();
        }
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        UnbakedElementsHelper.bakeElements(IModelBuilder.collecting(list), elements, spriteGetter, modelState);
        return list;
    }

    public static ModelState composeRootTransformIntoModelState(ModelState modelState, Transformation rootTransform) {
        rootTransform = rootTransform.applyOrigin(new Vector3f(-0.5f, -0.5f, -0.5f));
        return new SimpleModelState(modelState.getRotation().compose(rootTransform), modelState.isUvLocked());
    }
}

