/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.loading;

import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.DataPackConfig;
import net.neoforged.fml.Logging;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.ModWorkManager;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.loading.ImmediateWindowHandler;
import net.neoforged.neoforge.client.gui.LoadingErrorScreen;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeConfig;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.internal.CommonModLoader;
import net.neoforged.neoforge.logging.CrashReportExtender;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforge.server.LanguageHook;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ClientModLoader
extends CommonModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean loading;
    private static Minecraft mc;
    private static boolean loadingComplete;
    @Nullable
    private static ModLoadingException error;

    public static void begin(Minecraft minecraft) {
        Runtime.getRuntime().addShutdownHook(new Thread(LogManager::shutdown));
        ImmediateWindowHandler.updateProgress((String)"Loading mods");
        loading = true;
        mc = minecraft;
        LogicalSidedProvider.setClient(() -> minecraft);
        LanguageHook.loadBuiltinLanguages();
        try {
            ClientModLoader.begin(ImmediateWindowHandler::renderTick, false);
        }
        catch (ModLoadingException e) {
            error = e;
        }
    }

    public static void finish(PackRepository defaultResourcePacks, ReloadableResourceManager mcResourceManager) {
        if (error == null) {
            ResourcePackLoader.populatePackRepository(defaultResourcePacks, PackType.CLIENT_RESOURCES, false);
            DataPackConfig.DEFAULT.addModPacks(ResourcePackLoader.getPackNames(PackType.SERVER_DATA));
        }
    }

    public static CompletableFuture<Void> onResourceReload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, Executor asyncExecutor, Executor syncExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(() -> ClientModLoader.startModLoading(syncExecutor, asyncExecutor), ModWorkManager.parallelExecutor()).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenRunAsync(() -> ClientModLoader.finishModLoading(syncExecutor, asyncExecutor), ModWorkManager.parallelExecutor());
    }

    private static void catchLoadingException(Runnable r) {
        block4: {
            if (loadingComplete) {
                return;
            }
            if (ModLoader.hasErrors()) {
                return;
            }
            try {
                r.run();
            }
            catch (ModLoadingException e) {
                if (error != null) break block4;
                error = e;
            }
        }
    }

    private static void startModLoading(Executor syncExecutor, Executor parallelExecutor) {
        ClientModLoader.catchLoadingException(() -> ClientModLoader.load(syncExecutor, parallelExecutor));
    }

    private static void finishModLoading(Executor syncExecutor, Executor parallelExecutor) {
        ClientModLoader.catchLoadingException(() -> ClientModLoader.finish(syncExecutor, parallelExecutor));
        loading = false;
        loadingComplete = true;
        syncExecutor.execute(() -> ClientModLoader.mc.options.load(true));
    }

    public static VersionChecker.Status checkForUpdates() {
        boolean anyOutdated = ModList.get().getMods().stream().map(VersionChecker::getResult).map(result -> result.status()).anyMatch(status -> status == VersionChecker.Status.OUTDATED || status == VersionChecker.Status.BETA_OUTDATED);
        return anyOutdated ? VersionChecker.Status.OUTDATED : null;
    }

    public static Runnable completeModLoading(Runnable initialScreensTask) {
        List warnings = ModLoader.getLoadingIssues();
        boolean showWarnings = true;
        try {
            showWarnings = (Boolean)NeoForgeConfig.CLIENT.showLoadWarnings.get();
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (error != null) {
            LanguageHook.loadBuiltinLanguages();
            File dumpedLocation = CrashReportExtender.dumpModLoadingCrashReport(LOGGER, error.getIssues(), ClientModLoader.mc.gameDirectory);
            return () -> mc.setScreen((Screen)new LoadingErrorScreen(error.getIssues(), dumpedLocation, () -> {}));
        }
        NeoForge.EVENT_BUS.start();
        if (!warnings.isEmpty()) {
            if (showWarnings) {
                return () -> mc.setScreen((Screen)new LoadingErrorScreen(warnings, null, initialScreensTask));
            }
            LOGGER.warn(Logging.LOADING, "Mods loaded with {} warning(s)", (Object)warnings.size());
            for (ModLoadingIssue warning : warnings) {
                LOGGER.warn(Logging.LOADING, "{} [{}]", (Object)warning.translationKey(), (Object)warning.translationArgs());
            }
        }
        return initialScreensTask;
    }

    public static boolean isLoading() {
        return loading;
    }
}

