/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.neoforged.neoforge.common.conditions.ICondition;

public record FeatureFlagsEnabledCondition(FeatureFlagSet flags) implements ICondition
{
    public static final MapCodec<FeatureFlagsEnabledCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FeatureFlags.CODEC.fieldOf("flags").forGetter(condition -> condition.flags)).apply((Applicative)instance, FeatureFlagsEnabledCondition::new));

    public FeatureFlagsEnabledCondition {
        if (flags.isEmpty()) {
            throw new IllegalArgumentException("FeatureFlagsEnabledCondition requires a non-empty feature flag set");
        }
    }

    @Override
    public boolean test(ICondition.IContext context) {
        return this.flags.isSubsetOf(context.enabledFeatures());
    }

    @Override
    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }
}

