/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.event;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.resource.ContextAwareReloadListener;

public class AddReloadListenerEvent
extends Event {
    private final List<PreparableReloadListener> listeners = new ArrayList<PreparableReloadListener>();
    private final ReloadableServerResources serverResources;
    private final RegistryAccess registryAccess;

    public AddReloadListenerEvent(ReloadableServerResources serverResources, RegistryAccess registryAccess) {
        this.serverResources = serverResources;
        this.registryAccess = registryAccess;
    }

    public void addListener(PreparableReloadListener listener) {
        this.listeners.add(new WrappedStateAwareListener(listener));
    }

    public List<PreparableReloadListener> getListeners() {
        return ImmutableList.copyOf(this.listeners);
    }

    public ReloadableServerResources getServerResources() {
        return this.serverResources;
    }

    public ICondition.IContext getConditionContext() {
        return this.serverResources.getConditionContext();
    }

    public RegistryAccess getRegistryAccess() {
        return this.registryAccess;
    }

    private static class WrappedStateAwareListener
    extends ContextAwareReloadListener
    implements PreparableReloadListener {
        private final PreparableReloadListener wrapped;

        private WrappedStateAwareListener(PreparableReloadListener wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void injectContext(ICondition.IContext context, HolderLookup.Provider registryLookup) {
            PreparableReloadListener preparableReloadListener = this.wrapped;
            if (preparableReloadListener instanceof ContextAwareReloadListener) {
                ContextAwareReloadListener contextAwareListener = (ContextAwareReloadListener)preparableReloadListener;
                contextAwareListener.injectContext(context, registryLookup);
            }
        }

        public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
            if (!ModLoader.hasErrors()) {
                return this.wrapped.reload(stage, resourceManager, backgroundExecutor, gameExecutor);
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

