/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.geometry;

import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.IModelBuilder;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public abstract class SimpleUnbakedGeometry<T extends SimpleUnbakedGeometry<T>>
implements IUnbakedGeometry<T> {
    @Override
    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, List<ItemOverride> overrides) {
        TextureAtlasSprite particle = spriteGetter.apply(context.getMaterial("particle"));
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        RenderTypeGroup renderTypes = renderTypeHint != null ? context.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
        IModelBuilder<?> builder = IModelBuilder.of(context.useAmbientOcclusion(), context.useBlockLight(), context.isGui3d(), context.getTransforms(), particle, renderTypes);
        this.addQuads(context, builder, baker, spriteGetter, modelState);
        return builder.build();
    }

    protected abstract void addQuads(IGeometryBakingContext var1, IModelBuilder<?> var2, ModelBaker var3, Function<Material, TextureAtlasSprite> var4, ModelState var5);
}

