/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME, modid="neoforge")
public final class BlockEntityRenderBoundsDebugRenderer {
    private static boolean enabled = false;

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (!enabled || event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        LevelRenderer levelRenderer = Minecraft.getInstance().levelRenderer;
        PoseStack poseStack = event.getPoseStack();
        Vec3 camera = event.getCamera().getPosition();
        VertexConsumer consumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines());
        levelRenderer.iterateVisibleBlockEntities(be -> BlockEntityRenderBoundsDebugRenderer.drawRenderBoundingBox(poseStack, consumer, camera, be));
    }

    private static void drawRenderBoundingBox(PoseStack poseStack, VertexConsumer consumer, Vec3 camera, BlockEntity be) {
        BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(be);
        if (renderer != null) {
            BlockPos pos = be.getBlockPos();
            AABB aabb = renderer.getRenderBoundingBox(be).move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
            Vec3 offset = Vec3.atLowerCornerOf((Vec3i)pos).subtract(camera);
            poseStack.pushPose();
            poseStack.translate(offset.x, offset.y, offset.z);
            ShapeRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)aabb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            poseStack.popPose();
        }
    }

    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"neoforge").then(((LiteralArgumentBuilder)Commands.literal((String)"debug_blockentity_renderbounds").requires(src -> src.hasPermission(3))).then(Commands.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            enabled = BoolArgumentType.getBool((CommandContext)ctx, (String)"enable");
            return 1;
        }))));
    }

    private BlockEntityRenderBoundsDebugRenderer() {
    }
}

