/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.ApiStatus;

public abstract class RenderNameTagEvent
extends Event {
    private final EntityRenderState renderState;
    protected final Component originalContent;
    private final EntityRenderer<?, ?> entityRenderer;
    private final float partialTick;

    @ApiStatus.Internal
    public RenderNameTagEvent(EntityRenderState renderState, Component content, EntityRenderer<?, ?> entityRenderer, float partialTick) {
        this.renderState = renderState;
        this.originalContent = content;
        this.entityRenderer = entityRenderer;
        this.partialTick = partialTick;
    }

    public EntityRenderState getEntityRenderState() {
        return this.renderState;
    }

    public EntityRenderer<?, ?> getEntityRenderer() {
        return this.entityRenderer;
    }

    public float getPartialTick() {
        return this.partialTick;
    }

    public static class DoRender
    extends RenderNameTagEvent
    implements ICancellableEvent {
        private final PoseStack poseStack;
        private final MultiBufferSource multiBufferSource;
        private final int packedLight;

        public DoRender(EntityRenderState renderState, Component content, EntityRenderer<?, ?> entityRenderer, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, float partialTick) {
            super(renderState, content, entityRenderer, partialTick);
            this.poseStack = poseStack;
            this.multiBufferSource = multiBufferSource;
            this.packedLight = packedLight;
        }

        public Component getContent() {
            return this.originalContent;
        }

        public PoseStack getPoseStack() {
            return this.poseStack;
        }

        public MultiBufferSource getMultiBufferSource() {
            return this.multiBufferSource;
        }

        public int getPackedLight() {
            return this.packedLight;
        }
    }

    public static class CanRender
    extends RenderNameTagEvent {
        private final Entity entity;
        private Component content;
        private TriState canRender = TriState.DEFAULT;

        public CanRender(Entity entity, EntityRenderState renderState, Component content, EntityRenderer<?, ?> entityRenderer, float partialTick) {
            super(renderState, content, entityRenderer, partialTick);
            this.entity = entity;
            this.content = content;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Component getOriginalContent() {
            return this.originalContent;
        }

        public void setCanRender(TriState canRender) {
            this.canRender = canRender;
        }

        public TriState canRender() {
            return this.canRender;
        }

        public void setContent(Component contents) {
            this.content = contents;
        }

        public Component getContent() {
            return this.content;
        }
    }
}

