/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedOverrides;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ItemModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.CompositeModel;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DynamicFluidContainerModel
implements IUnbakedGeometry<DynamicFluidContainerModel> {
    private static final Transformation FLUID_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.002f), new Quaternionf());
    private static final Transformation COVER_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.004f), new Quaternionf());
    private final Fluid fluid;
    private final boolean flipGas;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;

    private DynamicFluidContainerModel(Fluid fluid, boolean flipGas, boolean coverIsMask, boolean applyFluidLuminosity) {
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
    }

    public static RenderTypeGroup getLayerRenderTypes(boolean unlit) {
        return new RenderTypeGroup(RenderType.translucent(), unlit ? NeoForgeRenderTypes.ITEM_UNSORTED_UNLIT_TRANSLUCENT.get() : NeoForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    public DynamicFluidContainerModel withFluid(Fluid newFluid) {
        return new DynamicFluidContainerModel(newFluid, this.flipGas, this.coverIsMask, this.applyFluidLuminosity);
    }

    @Override
    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, List<ItemOverride> overrides) {
        List<BakedQuad> quads;
        List<BlockElement> unbaked;
        SimpleModelState transformedState;
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite particleSprite;
        Material particleLocation = context.hasMaterial("particle") ? context.getMaterial("particle") : null;
        Material baseLocation = context.hasMaterial("base") ? context.getMaterial("base") : null;
        Material fluidMaskLocation = context.hasMaterial("fluid") ? context.getMaterial("fluid") : null;
        Material coverLocation = context.hasMaterial("cover") ? context.getMaterial("cover") : null;
        TextureAtlasSprite baseSprite = baseLocation != null ? spriteGetter.apply(baseLocation) : null;
        TextureAtlasSprite fluidSprite = this.fluid != Fluids.EMPTY ? spriteGetter.apply(ClientHooks.getBlockMaterial(IClientFluidTypeExtensions.of(this.fluid).getStillTexture())) : null;
        TextureAtlasSprite coverSprite = coverLocation != null && (!this.coverIsMask || baseLocation != null) ? spriteGetter.apply(coverLocation) : null;
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null && !this.coverIsMask) {
            particleSprite = coverSprite;
        }
        if (this.flipGas && this.fluid != Fluids.EMPTY && this.fluid.getFluidType().isLighterThanAir()) {
            modelState = new SimpleModelState(modelState.getRotation().compose(new Transformation(null, new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder(context).withGui3d(false).withUseBlockLight(false).build(ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"dynamic_fluid_container"));
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder(itemContext, particleSprite, context.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes(false);
        if (baseLocation != null && baseSprite != null) {
            List<BlockElement> unbaked2 = UnbakedGeometryHelper.createUnbakedItemElements(0, baseSprite);
            List<BakedQuad> quads2 = UnbakedGeometryHelper.bakeElements(unbaked2, $ -> baseSprite, modelState);
            modelBuilder.addQuads(normalRenderTypes, quads2);
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            transformedState = new SimpleModelState(modelState.getRotation().compose(FLUID_TRANSFORM), modelState.isUvLocked());
            unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements(1, templateSprite);
            quads = UnbakedGeometryHelper.bakeElements(unbaked, $ -> fluidSprite, transformedState);
            boolean emissive = this.applyFluidLuminosity && this.fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = DynamicFluidContainerModel.getLayerRenderTypes(emissive);
            if (emissive) {
                QuadTransformers.settingMaxEmissivity().processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, quads);
        }
        if (coverSprite != null) {
            TextureAtlasSprite sprite;
            TextureAtlasSprite textureAtlasSprite2 = sprite = this.coverIsMask ? baseSprite : coverSprite;
            if (sprite != null) {
                transformedState = new SimpleModelState(modelState.getRotation().compose(COVER_TRANSFORM), modelState.isUvLocked());
                unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements(2, coverSprite);
                quads = UnbakedGeometryHelper.bakeElements(unbaked, $ -> sprite, transformedState);
                modelBuilder.addQuads(normalRenderTypes, quads);
            }
        }
        modelBuilder.setParticle(particleSprite);
        BakedModel bakedModel = modelBuilder.build();
        ContainedFluidOverrideHandler bakedOverrides = new ContainedFluidOverrideHandler(new BakedOverrides(baker, overrides, spriteGetter), bakedModel, baker, itemContext, this);
        return new ItemModel.BakedModelWithOverrides(bakedModel, (BakedOverrides)bakedOverrides);
    }

    private static final class ContainedFluidOverrideHandler
    extends BakedOverrides {
        private final Map<String, BakedModel> cache = Maps.newHashMap();
        private final BakedOverrides nested;
        private final BakedModel baseModel;
        private final ModelBaker baker;
        private final IGeometryBakingContext owner;
        private final DynamicFluidContainerModel parent;

        private ContainedFluidOverrideHandler(BakedOverrides nested, BakedModel baseModel, ModelBaker baker, IGeometryBakingContext owner, DynamicFluidContainerModel parent) {
            this.nested = nested;
            this.baseModel = baseModel;
            this.baker = baker;
            this.owner = owner;
            this.parent = parent;
        }

        @Nullable
        public BakedModel findOverride(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            BakedModel overridden = this.nested.findOverride(stack, level, entity, seed);
            if (overridden != null) {
                return overridden;
            }
            return FluidUtil.getFluidContained(stack).map(fluidStack -> {
                Fluid fluid = fluidStack.getFluid();
                String name = BuiltInRegistries.FLUID.getKey((Object)fluid).toString();
                if (!this.cache.containsKey(name)) {
                    DynamicFluidContainerModel unbaked = this.parent.withFluid(fluid);
                    BakedModel bakedModel = unbaked.bake(this.owner, this.baker, Material::sprite, (ModelState)BlockModelRotation.X0_Y0, List.of());
                    this.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return this.cache.get(name);
            }).orElse(this.baseModel);
        }
    }

    public static class Colors
    implements ItemColor {
        public int getColor(ItemStack stack, int tintIndex) {
            if (tintIndex != 1) {
                return -1;
            }
            return FluidUtil.getFluidContained(stack).map(fluidStack -> IClientFluidTypeExtensions.of(fluidStack.getFluid()).getTintColor((FluidStack)fluidStack)).orElse(-1);
        }
    }

    public static final class Loader
    implements IGeometryLoader<DynamicFluidContainerModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public DynamicFluidContainerModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            if (!jsonObject.has("fluid")) {
                throw new RuntimeException("Bucket model requires 'fluid' value.");
            }
            ResourceLocation fluidName = ResourceLocation.parse((String)jsonObject.get("fluid").getAsString());
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.getValue(fluidName);
            boolean flip = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"flip_gas", (boolean)false);
            boolean coverIsMask = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"cover_is_mask", (boolean)true);
            boolean applyFluidLuminosity = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"apply_fluid_luminosity", (boolean)true);
            return new DynamicFluidContainerModel(fluid, flip, coverIsMask, applyFluidLuminosity);
        }
    }
}

