/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.DynamicBlockStateModel;
import net.neoforged.neoforge.client.model.block.CustomUnbakedBlockStateModel;
import org.jspecify.annotations.Nullable;

public class CompositeBlockModel
implements DynamicBlockStateModel {
    private final List<BlockStateModel> models;
    private final TextureAtlasSprite particleIcon;

    public CompositeBlockModel(List<BlockStateModel> models) {
        this.models = models;
        this.particleIcon = models.getFirst().particleIcon();
    }

    public @Nullable Object createGeometryKey(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random) {
        long seed = random.nextLong();
        if (this.models.size() == 1) {
            random.setSeed(seed);
            return this.models.getFirst().createGeometryKey(level, pos, state, random);
        }
        ArrayList<Object> subKeys = new ArrayList<Object>(this.models.size());
        for (BlockStateModel model : this.models) {
            random.setSeed(seed);
            Object subKey = model.createGeometryKey(level, pos, state, random);
            if (subKey == null) {
                return null;
            }
            subKeys.add(subKey);
        }
        return new GeometryKey(subKeys, this);
    }

    @Override
    public void collectParts(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        long seed = random.nextLong();
        for (BlockStateModel model : this.models) {
            random.setSeed(seed);
            model.collectParts(level, pos, state, random, parts);
        }
    }

    public TextureAtlasSprite particleIcon() {
        return this.particleIcon;
    }

    private record GeometryKey(List<Object> subKeys, CompositeBlockModel composite) {
    }

    public record Unbaked(List<BlockStateModel.Unbaked> models) implements CustomUnbakedBlockStateModel
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStateModel.Unbaked.CODEC.listOf(1, Integer.MAX_VALUE).fieldOf("models").forGetter(Unbaked::models)).apply((Applicative)instance, Unbaked::new));

        public Unbaked {
            if (models.isEmpty()) {
                throw new IllegalArgumentException("Composite model requires at least one submodel");
            }
        }

        public BlockStateModel bake(ModelBaker baker) {
            return new CompositeBlockModel(this.models.stream().map(m -> m.bake(baker)).toList());
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            for (BlockStateModel.Unbaked model : this.models) {
                model.resolveDependencies(resolver);
            }
        }

        @Override
        public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
            return MAP_CODEC;
        }
    }
}

