/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.resources.Identifier;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.event.RegisterNamedRenderTypesEvent;
import org.jetbrains.annotations.ApiStatus;

public final class NamedRenderTypeManager {
    private static ImmutableMap<Identifier, RenderTypeGroup> RENDER_TYPES;

    public static RenderTypeGroup get(Identifier name) {
        return (RenderTypeGroup)RENDER_TYPES.getOrDefault((Object)name, (Object)RenderTypeGroup.EMPTY);
    }

    @ApiStatus.Internal
    public static void init() {
        HashMap<Identifier, RenderTypeGroup> renderTypes = new HashMap<Identifier, RenderTypeGroup>();
        NamedRenderTypeManager.preRegisterVanillaRenderTypes(renderTypes);
        RegisterNamedRenderTypesEvent event = new RegisterNamedRenderTypesEvent(renderTypes);
        ModLoader.postEventWrapContainerInModOrder((Event)event);
        RENDER_TYPES = ImmutableMap.copyOf(renderTypes);
    }

    private static void preRegisterVanillaRenderTypes(Map<Identifier, RenderTypeGroup> blockRenderTypes) {
        blockRenderTypes.put(Identifier.withDefaultNamespace((String)"solid"), new RenderTypeGroup(ChunkSectionLayer.SOLID, NeoForgeRenderTypes::getItemLayeredSolid));
        blockRenderTypes.put(Identifier.withDefaultNamespace((String)"cutout"), new RenderTypeGroup(ChunkSectionLayer.CUTOUT, NeoForgeRenderTypes::getItemLayeredCutout));
        blockRenderTypes.put(Identifier.withDefaultNamespace((String)"translucent"), new RenderTypeGroup(ChunkSectionLayer.TRANSLUCENT, NeoForgeRenderTypes::getItemLayeredTranslucent));
        blockRenderTypes.put(Identifier.withDefaultNamespace((String)"tripwire"), new RenderTypeGroup(ChunkSectionLayer.TRIPWIRE, NeoForgeRenderTypes::getItemLayeredTranslucent));
    }

    private NamedRenderTypeManager() {
    }
}

