/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.random.Weighted;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.event.RegisterBlockStateModels;
import net.neoforged.neoforge.client.model.block.CustomBlockModelDefinition;
import net.neoforged.neoforge.client.model.block.CustomUnbakedBlockStateModel;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class BlockStateModelHooks {
    static final ExtraCodecs.LateBoundIdMapper<Identifier, MapCodec<? extends CustomUnbakedBlockStateModel>> BLOCK_STATE_MODEL_IDS = new ExtraCodecs.LateBoundIdMapper();
    static final ExtraCodecs.LateBoundIdMapper<Identifier, MapCodec<? extends CustomBlockModelDefinition>> BLOCK_MODEL_DEFINITION_IDS = new ExtraCodecs.LateBoundIdMapper();

    public static void init() {
        ModLoader.postEvent((Event)new RegisterBlockStateModels(BLOCK_STATE_MODEL_IDS, BLOCK_MODEL_DEFINITION_IDS));
    }

    public static MapCodec<Either<CustomUnbakedBlockStateModel, SingleVariant.Unbaked>> makeSingleModelCodec() {
        return NeoForgeExtraCodecs.dispatchMapOrElse(BLOCK_STATE_MODEL_IDS.codec(Identifier.CODEC), CustomUnbakedBlockStateModel::codec, c -> c, SingleVariant.Unbaked.MAP_CODEC);
    }

    public static Codec<Weighted<Either<CustomUnbakedBlockStateModel, SingleVariant.Unbaked>>> makeElementCodec() {
        MapCodec<Either<CustomUnbakedBlockStateModel, SingleVariant.Unbaked>> singleModelCodec = BlockStateModelHooks.makeSingleModelCodec();
        return RecordCodecBuilder.create(instance -> instance.group((App)singleModelCodec.forGetter(Weighted::value), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("weight", (Object)1).forGetter(Weighted::weight)).apply((Applicative)instance, Weighted::new));
    }

    public static Codec<BlockModelDefinition> makeDefinitionCodec() {
        return NeoForgeExtraCodecs.dispatchMapOrElse("neoforge:definition_type", BLOCK_MODEL_DEFINITION_IDS.codec(Identifier.CODEC), CustomBlockModelDefinition::codec, Function.identity(), BlockModelDefinition.VANILLA_CODEC).xmap(BlockStateModelHooks::packDefinition, BlockStateModelHooks::unpackDefinition).codec();
    }

    private static BlockModelDefinition packDefinition(Either<CustomBlockModelDefinition, BlockModelDefinition> definition) {
        return (BlockModelDefinition)definition.map(def -> new BlockModelDefinition(Optional.empty(), Optional.empty(), Optional.of(def)), Function.identity());
    }

    private static Either<CustomBlockModelDefinition, BlockModelDefinition> unpackDefinition(BlockModelDefinition definition) {
        return definition.customDefinition().isPresent() ? Either.left((Object)((CustomBlockModelDefinition)definition.customDefinition().get())) : Either.right((Object)definition);
    }

    private BlockStateModelHooks() {
    }
}

