/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.CustomCloudsRenderer;
import net.neoforged.neoforge.client.CustomSkyboxRenderer;
import net.neoforged.neoforge.client.CustomWeatherEffectRenderer;
import net.neoforged.neoforge.client.event.RegisterCustomEnvironmentEffectRendererEvent;
import net.neoforged.neoforge.common.world.NeoForgeEnvironmentAttributes;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public final class CustomEnvironmentEffectsRendererManager {
    private static @Nullable Map<Identifier, CustomCloudsRenderer> CUSTOM_CLOUD_RENDERERS;
    private static @Nullable Map<Identifier, CustomSkyboxRenderer> CUSTOM_SKYBOX_RENDERERS;
    private static @Nullable Map<Identifier, CustomWeatherEffectRenderer> CUSTOM_WEATHER_EFFECT_RENDERERS;

    public static @Nullable CustomCloudsRenderer getCustomCloudsRenderer(Identifier id) {
        if (NeoForgeEnvironmentAttributes.DEFAULT_CUSTOM_CLOUDS.equals((Object)id)) {
            return null;
        }
        return Objects.requireNonNull(CUSTOM_CLOUD_RENDERERS).get(id);
    }

    public static @Nullable CustomCloudsRenderer getCustomCloudsRenderer(Level level, Vec3 position) {
        Identifier id = (Identifier)level.environmentAttributes().getValue(NeoForgeEnvironmentAttributes.CUSTOM_CLOUDS, position);
        return CustomEnvironmentEffectsRendererManager.getCustomCloudsRenderer(id);
    }

    public static @Nullable CustomSkyboxRenderer getCustomSkyboxRenderer(Identifier id) {
        if (NeoForgeEnvironmentAttributes.DEFAULT_CUSTOM_SKYBOX.equals((Object)id)) {
            return null;
        }
        return Objects.requireNonNull(CUSTOM_SKYBOX_RENDERERS).get(id);
    }

    public static @Nullable CustomSkyboxRenderer getCustomSkyboxRenderer(Level level, Vec3 position) {
        Identifier id = (Identifier)level.environmentAttributes().getValue(NeoForgeEnvironmentAttributes.CUSTOM_SKYBOX, position);
        return CustomEnvironmentEffectsRendererManager.getCustomSkyboxRenderer(id);
    }

    public static @Nullable CustomWeatherEffectRenderer getCustomWeatherEffectRenderer(Identifier id) {
        if (NeoForgeEnvironmentAttributes.DEFAULT_CUSTOM_WEATHER_EFFECTS.equals((Object)id)) {
            return null;
        }
        return Objects.requireNonNull(CUSTOM_WEATHER_EFFECT_RENDERERS).get(id);
    }

    public static @Nullable CustomWeatherEffectRenderer getCustomWeatherEffectRenderer(Level level, Vec3 position) {
        Identifier id = (Identifier)level.environmentAttributes().getValue(NeoForgeEnvironmentAttributes.CUSTOM_WEATHER_EFFECTS, position);
        return CustomEnvironmentEffectsRendererManager.getCustomWeatherEffectRenderer(id);
    }

    @ApiStatus.Internal
    public static void init() {
        if (CUSTOM_CLOUD_RENDERERS != null) {
            throw new IllegalStateException("Already initialized.");
        }
        HashMap<Identifier, CustomCloudsRenderer> customCloudRenderers = new HashMap<Identifier, CustomCloudsRenderer>();
        HashMap<Identifier, CustomSkyboxRenderer> customSkyboxRenderers = new HashMap<Identifier, CustomSkyboxRenderer>();
        HashMap<Identifier, CustomWeatherEffectRenderer> customWeatherEffectRenderers = new HashMap<Identifier, CustomWeatherEffectRenderer>();
        ModLoader.postEventWrapContainerInModOrder((Event)new RegisterCustomEnvironmentEffectRendererEvent(customCloudRenderers, customSkyboxRenderers, customWeatherEffectRenderers));
        CUSTOM_CLOUD_RENDERERS = Map.copyOf(customCloudRenderers);
        CUSTOM_SKYBOX_RENDERERS = Map.copyOf(customSkyboxRenderers);
        CUSTOM_WEATHER_EFFECT_RENDERERS = Map.copyOf(customWeatherEffectRenderers);
    }

    private CustomEnvironmentEffectsRendererManager() {
    }
}

