/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.registries.callback.AddCallback;
import net.neoforged.neoforge.registries.callback.BakeCallback;
import net.neoforged.neoforge.registries.callback.ClearCallback;
import net.neoforged.neoforge.registries.callback.RegistryCallback;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

@ApiStatus.Internal
public abstract class BaseMappedRegistry<T>
implements Registry<T> {
    protected final List<AddCallback<T>> addCallbacks = new ArrayList<AddCallback<T>>();
    protected final List<BakeCallback<T>> bakeCallbacks = new ArrayList<BakeCallback<T>>();
    protected final List<ClearCallback<T>> clearCallbacks = new ArrayList<ClearCallback<T>>();
    final Map<Identifier, Identifier> aliases = new HashMap<Identifier, Identifier>();
    final Map<DataMapType<T, ?>, Map<ResourceKey<T>, ?>> dataMaps = new IdentityHashMap();
    private int maxId = 0x7FFFFFFE;
    private boolean sync;

    void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean doesSync() {
        return this.sync;
    }

    void setMaxId(int maxId) {
        this.maxId = maxId;
    }

    public int getMaxId() {
        return this.maxId;
    }

    public void addCallback(RegistryCallback<T> callback) {
        if (callback instanceof AddCallback) {
            AddCallback addCallback = (AddCallback)callback;
            this.addCallbacks.add(addCallback);
        }
        if (callback instanceof BakeCallback) {
            BakeCallback bakeCallback = (BakeCallback)callback;
            this.bakeCallbacks.add(bakeCallback);
        }
        if (callback instanceof ClearCallback) {
            ClearCallback clearCallback = (ClearCallback)callback;
            this.clearCallbacks.add(clearCallback);
        }
    }

    public void addAlias(Identifier from, Identifier to) {
        Identifier old;
        if (from.equals((Object)to)) {
            return;
        }
        if (this.aliases.containsKey(from) && !(old = this.aliases.get(from)).equals((Object)to)) {
            throw new IllegalStateException("Duplicate alias with key \"" + String.valueOf(from) + "\" attempting to map to \"" + String.valueOf(to) + "\", found existing mapping \"" + String.valueOf(old) + "\"");
        }
        if (this.resolve(from).equals((Object)to)) {
            throw new IllegalStateException("Infinite alias loop detected: from " + String.valueOf(from) + " to " + String.valueOf(to));
        }
        this.aliases.put(from, to);
    }

    public Identifier resolve(Identifier name) {
        if (this.containsKey(name)) {
            return name;
        }
        Identifier alias = this.aliases.get(name);
        if (alias == null) {
            return name;
        }
        return this.resolve(alias);
    }

    public ResourceKey<T> resolve(ResourceKey<T> key) {
        Identifier resolvedName = this.resolve(key.identifier());
        return resolvedName == key.identifier() ? key : ResourceKey.create((ResourceKey)this.key(), (Identifier)resolvedName);
    }

    public int getId(ResourceKey<T> key) {
        Object value = this.getValue(key);
        return value == null ? -1 : this.getId(value);
    }

    public int getId(Identifier name) {
        Object value = this.getValue(name);
        return value == null ? -1 : this.getId(value);
    }

    protected void clear(boolean full) {
        this.aliases.clear();
        if (full) {
            this.dataMaps.clear();
        }
    }

    protected abstract void registerIdMapping(ResourceKey<T> var1, int var2);

    protected abstract void unfreeze(boolean var1);

    public <A> @Nullable A getData(DataMapType<T, A> type, ResourceKey<T> key) {
        Map<ResourceKey<T>, ?> innerMap = this.dataMaps.get(type);
        return innerMap == null ? null : (A)innerMap.get(key);
    }

    public <A> Map<ResourceKey<T>, A> getDataMap(DataMapType<T, A> type) {
        return this.dataMaps.getOrDefault(type, Map.of());
    }

    public Map<DataMapType<T, ?>, Map<ResourceKey<T>, ?>> getDataMaps() {
        return this.dataMaps;
    }
}

