/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.pipeline;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ARGB;
import org.joml.Vector3f;

public class RemappingVertexPipeline
implements VertexConsumer {
    private static final Set<VertexFormatElement> KNOWN_ELEMENTS = Set.of(VertexFormatElement.POSITION, VertexFormatElement.COLOR, VertexFormatElement.UV, VertexFormatElement.UV1, VertexFormatElement.UV2, VertexFormatElement.NORMAL);
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final VertexConsumer parent;
    private final VertexFormat targetFormat;
    private final Vector3f position = new Vector3f();
    private final Vector3f normal = new Vector3f();
    private final int[] color = new int[]{255, 255, 255, 255};
    private final float[] uv0 = new float[]{0.0f, 0.0f};
    private final int[] uv1 = new int[]{0, 10};
    private final int[] uv2 = new int[]{0, 0};
    private float lineWidth = 0.0f;
    private final Map<VertexFormatElement, Integer> miscElementIds;
    private final int[][] misc;

    public RemappingVertexPipeline(VertexConsumer parent, VertexFormat targetFormat) {
        this.parent = parent;
        this.targetFormat = targetFormat;
        this.miscElementIds = new IdentityHashMap<VertexFormatElement, Integer>();
        int i = 0;
        for (VertexFormatElement element : targetFormat.getElements()) {
            if (KNOWN_ELEMENTS.contains(element)) continue;
            this.miscElementIds.put(element, i++);
        }
        this.misc = new int[i][];
        Arrays.fill((Object[])this.misc, EMPTY_INT_ARRAY);
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        this.position.set(x, y, z);
        return this;
    }

    public VertexConsumer setNormal(float x, float y, float z) {
        this.normal.set(x, y, z);
        return this;
    }

    public VertexConsumer setColor(int packedColor) {
        return this.setColor(ARGB.red((int)packedColor), ARGB.green((int)packedColor), ARGB.blue((int)packedColor), ARGB.alpha((int)packedColor));
    }

    public VertexConsumer setColor(int r, int g, int b, int a) {
        this.color[0] = r;
        this.color[1] = g;
        this.color[2] = b;
        this.color[3] = a;
        return this;
    }

    public VertexConsumer setUv(float u, float v) {
        this.uv0[0] = u;
        this.uv0[1] = v;
        return this;
    }

    public VertexConsumer setUv1(int u, int v) {
        this.uv1[0] = u;
        this.uv1[1] = v;
        return this;
    }

    public VertexConsumer setUv2(int u, int v) {
        this.uv2[0] = u;
        this.uv2[1] = v;
        return this;
    }

    public VertexConsumer misc(VertexFormatElement element, int ... values) {
        Integer id = this.miscElementIds.get(element);
        if (id != null) {
            this.misc[id.intValue()] = Arrays.copyOf(values, values.length);
        }
        return this;
    }

    public VertexConsumer setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public void endVertex() {
        for (VertexFormatElement element : this.targetFormat.getElements()) {
            if (element.equals((Object)VertexFormatElement.POSITION)) {
                this.parent.addVertex(this.position.x, this.position.y, this.position.z);
                continue;
            }
            if (element.equals((Object)VertexFormatElement.NORMAL)) {
                this.parent.setNormal(this.normal.x(), this.normal.y(), this.normal.z());
                continue;
            }
            if (element.equals((Object)VertexFormatElement.COLOR)) {
                this.parent.setColor(this.color[0], this.color[1], this.color[2], this.color[3]);
                continue;
            }
            if (element.equals((Object)VertexFormatElement.UV0)) {
                this.parent.setUv(this.uv0[0], this.uv0[1]);
                continue;
            }
            if (element.equals((Object)VertexFormatElement.UV1)) {
                this.parent.setUv1(this.uv1[0], this.uv1[1]);
                continue;
            }
            if (element.equals((Object)VertexFormatElement.UV2)) {
                this.parent.setUv2(this.uv2[0], this.uv2[1]);
                continue;
            }
            if (element.equals((Object)VertexFormatElement.LINE_WIDTH)) {
                this.parent.setLineWidth(this.lineWidth);
                continue;
            }
            this.parent.misc(element, this.misc[this.miscElementIds.get(element)]);
        }
    }
}

