/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.SSLHandshakeException;
import net.minecraftforge.installer.HashFunction;
import net.minecraftforge.installer.SimpleInstaller;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Manifest;
import net.minecraftforge.installer.json.Mirror;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;
import org.jetbrains.annotations.Nullable;

public class DownloadUtils {
    @Nullable
    public static String userAgent;
    public static boolean OFFLINE_MODE;

    public static boolean downloadLibrary(ProgressCallback monitor, Version.Library library, File root, Predicate<String> optional, List<Artifact> grabbed, List<File> additionalLibraryDirs) {
        Version.LibraryDownload download;
        Artifact artifact = library.getName();
        File target = artifact.getLocalPath(root);
        Version.LibraryDownload libraryDownload = download = library.getDownloads() == null ? null : library.getDownloads().getArtifact();
        if (download == null) {
            download = new Version.LibraryDownload();
            download.setPath(artifact.getPath());
        }
        if (!optional.test(library.getName().getDescriptor())) {
            monitor.message(String.format("Considering library %s: Not Downloading {Disabled}", artifact.getDescriptor()));
            return true;
        }
        monitor.message(String.format("Considering library %s", artifact.getDescriptor()));
        String url = download.getUrl();
        if (url == null || url.isEmpty()) {
            monitor.message("  Invalid library, missing url");
            return false;
        }
        if (monitor.downloader(url).additionalDirectory(additionalLibraryDirs.toArray(new File[0])).sha(download.getSha1()).localPath(download.getPath()).download(target)) {
            grabbed.add(artifact);
            return true;
        }
        return false;
    }

    public static String getSha1(File target) {
        try {
            return HashFunction.SHA1.hash(Files.readAllBytes(target.toPath())).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URLConnection getConnection(String address) {
        URL url;
        if (OFFLINE_MODE) {
            System.out.println("Offline Mode: Not downloading: " + address);
            return null;
        }
        try {
            url = new URL(address);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        try {
            int MAX = 3;
            URLConnection connection = null;
            for (int x = 0; x < MAX; ++x) {
                connection = url.openConnection();
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                if (!(connection instanceof HttpURLConnection)) break;
                HttpURLConnection hcon = (HttpURLConnection)connection;
                hcon.setRequestProperty("User-Agent", DownloadUtils.getUserAgent());
                hcon.setInstanceFollowRedirects(false);
                int res = hcon.getResponseCode();
                if (res != 301 && res != 302) break;
                String location = hcon.getHeaderField("Location");
                hcon.disconnect();
                if (x == MAX - 1) {
                    System.out.println("Invalid number of redirects: " + location);
                    return null;
                }
                System.out.println("Following redirect: " + location);
                url = new URL(url, location);
            }
            return connection;
        }
        catch (SSLHandshakeException e) {
            System.out.println("Failed to establish connection to " + address);
            String host = url.getHost();
            System.out.println(" Host: " + host + " [" + DownloadUtils.getIps(host).stream().collect(Collectors.joining(", ")) + "]");
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getUserAgent() {
        if (userAgent == null) {
            userAgent = "NeoForged LegacyInstaller";
            String installerVersion = SimpleInstaller.class.getPackage().getImplementationVersion();
            if (installerVersion != null) {
                userAgent = userAgent + " (" + installerVersion + ")";
            }
            try {
                InstallV1 profile = Util.loadInstallProfile();
                userAgent = userAgent + " / " + profile.getVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return userAgent;
    }

    public static List<String> getIps(String host) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(host);
            return Arrays.stream(addresses).map(InetAddress::getHostAddress).collect(Collectors.toList());
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Mirror[] downloadMirrors(String url) {
        try {
            URLConnection connection = DownloadUtils.getConnection(url);
            if (connection == null) return null;
            try (InputStream stream = connection.getInputStream();){
                Mirror[] mirrorArray = Util.loadMirrorList(stream);
                return mirrorArray;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest downloadManifest(ProgressCallback callback) {
        try (InputStream stream = callback.downloader("https://piston-meta.mojang.com/mc/game/version_manifest_v2.json").localPath("version_manifest.json").openStream();){
            Manifest manifest = Util.loadManifest(stream);
            return manifest;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean extractFile(String name, File target) {
        String path = name.charAt(0) == '/' ? name : '/' + name;
        InputStream input = DownloadUtils.class.getResourceAsStream(path);
        if (input == null) {
            System.out.println("File not found in installer archive: " + path);
            return false;
        }
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        try {
            Files.copy(input, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        OFFLINE_MODE = false;
    }
}

