/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.transfer.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class BundleItemHandler
implements ResourceHandler<ItemResource> {
    protected final ItemAccess itemAccess;
    protected final Item validItem;
    protected final DataComponentType<BundleContents> component;

    public BundleItemHandler(ItemAccess itemAccess, DataComponentType<BundleContents> component) {
        this.itemAccess = itemAccess;
        this.validItem = itemAccess.getResource().getItem();
        this.component = component;
    }

    @Override
    public int size() {
        BundleContents contents = (BundleContents)this.itemAccess.getResource().get(this.component);
        if (contents == null) {
            return 0;
        }
        return contents.size() + (contents.weight().intValue() < 1 ? 1 : 0);
    }

    protected ItemStack getStack(int index) {
        BundleContents contents = (BundleContents)this.itemAccess.getResource().get(this.component);
        if (contents == null || index >= contents.size()) {
            return ItemStack.EMPTY;
        }
        return contents.getItemUnsafe(index);
    }

    @Override
    public ItemResource getResource(int index) {
        if (this.itemAccess.getResource().is(this.validItem)) {
            return ItemResource.of(this.getStack(index));
        }
        return ItemResource.EMPTY;
    }

    @Override
    public long getAmountAsLong(int index) {
        if (this.itemAccess.getResource().is(this.validItem)) {
            return (long)this.itemAccess.getAmount() * (long)this.getStack(index).getCount();
        }
        return 0L;
    }

    @Override
    public long getCapacityAsLong(int index, ItemResource resource) {
        if (this.isValid(index, resource)) {
            return (long)this.itemAccess.getAmount() * (long)(resource.isEmpty() ? 99 : Math.min(resource.getMaxStackSize(), 99));
        }
        return 0L;
    }

    @Override
    public boolean isValid(int index, ItemResource resource) {
        return this.itemAccess.getResource().is(this.validItem) && BundleContents.canItemBeInBundle((ItemStack)resource.toStack());
    }

    @Override
    public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        TransferPreconditions.checkNonNegative(index);
        int accessAmount = this.itemAccess.getAmount();
        if (accessAmount == 0) {
            return 0;
        }
        int extractedPerItem = amount / accessAmount;
        ItemResource accessResource = this.itemAccess.getResource();
        BundleContents contents = (BundleContents)accessResource.get(this.component);
        if (contents == null || index > contents.size()) {
            return 0;
        }
        BundleContents.Mutable mutable = new BundleContents.Mutable(contents);
        int inserted = 0;
        if (index == contents.size()) {
            inserted = mutable.tryInsert(resource.toStack(extractedPerItem));
        } else {
            ItemStack existing = contents.getItemUnsafe(index);
            if (resource.matches(existing)) {
                inserted += mutable.tryInsert(resource.toStack(extractedPerItem));
            } else {
                return 0;
            }
        }
        return inserted * this.itemAccess.exchange((ItemResource)accessResource.with((DataComponentType)this.component, (Object)mutable.toImmutable()), accessAmount, transaction);
    }

    @Override
    public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
        TransferPreconditions.checkNonEmptyNonNegative(resource, amount);
        TransferPreconditions.checkNonNegative(index);
        int accessAmount = this.itemAccess.getAmount();
        if (accessAmount == 0) {
            return 0;
        }
        int extractedPerItem = amount / accessAmount;
        ItemResource accessResource = this.itemAccess.getResource();
        BundleContents contents = (BundleContents)accessResource.get(this.component);
        if (contents == null || index >= contents.size()) {
            return 0;
        }
        ItemStack stack = contents.getItemUnsafe(index);
        if (stack.isEmpty() || !resource.matches(stack)) {
            return 0;
        }
        int toExtract = Math.min(extractedPerItem, stack.getCount());
        if (toExtract <= 0) {
            return 0;
        }
        ObjectArrayList items = new ObjectArrayList(contents.size());
        contents.items().forEach(((List)items)::add);
        if (toExtract == stack.getCount()) {
            items.remove(index);
        } else {
            items.set(index, stack.copy().split(toExtract));
        }
        return toExtract * this.itemAccess.exchange((ItemResource)accessResource.with((DataComponentType)this.component, (Object)new BundleContents((List)items)), accessAmount, transaction);
    }
}

