/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.resources.Identifier;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.client.entity.animation.AnimationTarget;
import org.jetbrains.annotations.ApiStatus;

public class RegisterJsonAnimationTypesEvent
extends Event
implements IModBusEvent {
    private final ImmutableMap.Builder<Identifier, AnimationTarget> targets;
    private final ImmutableMap.Builder<Identifier, AnimationChannel.Interpolation> interpolations;
    private final Map<Identifier, AnimationTarget> registeredTargets = new HashMap<Identifier, AnimationTarget>();
    private final Map<Identifier, AnimationChannel.Interpolation> registeredInterpolations = new HashMap<Identifier, AnimationChannel.Interpolation>();

    @ApiStatus.Internal
    public RegisterJsonAnimationTypesEvent(ImmutableMap.Builder<Identifier, AnimationTarget> targets, ImmutableMap.Builder<Identifier, AnimationChannel.Interpolation> interpolations) {
        this.targets = targets;
        this.interpolations = interpolations;
    }

    public void registerTarget(Identifier key, AnimationTarget target) {
        RegisterJsonAnimationTypesEvent.checkDuplicate("target", key, this.registeredTargets, target);
        this.targets.put((Object)key, (Object)target);
    }

    public void registerInterpolation(Identifier key, AnimationChannel.Interpolation interpolation) {
        RegisterJsonAnimationTypesEvent.checkDuplicate("interpolation", key, this.registeredInterpolations, interpolation);
        this.interpolations.put((Object)key, (Object)interpolation);
    }

    private static <T> void checkDuplicate(String what, Identifier key, Map<Identifier, T> by, T obj) {
        T prevObj = by.putIfAbsent(key, obj);
        if (prevObj != null) {
            throw new IllegalStateException("Duplicate " + what + " registration for " + String.valueOf(key) + ". " + String.valueOf(obj) + " tried to overwrite " + String.valueOf(prevObj) + ".");
        }
    }
}

