/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.capabilities;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.CapabilityRegistry;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public final class EntityCapability<T, C>
extends BaseCapability<T, C> {
    private static final CapabilityRegistry<EntityCapability<?, ?>> registry = new CapabilityRegistry<EntityCapability>(EntityCapability::new);
    final Map<EntityType<?>, List<ICapabilityProvider<Entity, C, T>>> providers = new IdentityHashMap();

    public static <T, C> EntityCapability<T, C> create(Identifier name, Class<T> typeClass, Class<C> contextClass) {
        return registry.create(name, typeClass, contextClass);
    }

    public static <T> EntityCapability<T, @Nullable Void> createVoid(Identifier name, Class<T> typeClass) {
        return EntityCapability.create(name, typeClass, Void.TYPE);
    }

    public static <T> EntityCapability<T, @Nullable Direction> createSided(Identifier name, Class<T> typeClass) {
        return EntityCapability.create(name, typeClass, Direction.class);
    }

    public static synchronized List<EntityCapability<?, ?>> getAll() {
        return registry.getAll();
    }

    private EntityCapability(Identifier name, Class<T> typeClass, Class<C> contextClass) {
        super(name, typeClass, contextClass);
    }

    @ApiStatus.Internal
    public @Nullable T getCapability(Entity entity, C context) {
        for (ICapabilityProvider provider : this.providers.getOrDefault(entity.getType(), List.of())) {
            Object ret = provider.getCapability(entity, context);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

