/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.resource;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.FileUtil;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarcontents.JarResource;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class JarContentsPackResources
extends AbstractPackResources {
    static final Logger LOGGER = LogUtils.getLogger();
    private final JarContents contents;
    private final String prefix;

    public JarContentsPackResources(PackLocationInfo locationInfo, JarContents contents, String prefix) {
        super(locationInfo);
        this.contents = contents;
        this.prefix = prefix;
    }

    private static String getPathFromLocation(PackType packType, Identifier location) {
        return String.format(Locale.ROOT, "%s/%s/%s", packType.getDirectory(), location.getNamespace(), location.getPath());
    }

    public @Nullable IoSupplier<InputStream> getRootResource(String ... pathSegments) {
        return this.getResource(String.join((CharSequence)"/", pathSegments));
    }

    public IoSupplier<InputStream> getResource(PackType packType, Identifier location) {
        return this.getResource(JarContentsPackResources.getPathFromLocation(packType, location));
    }

    private String addPrefix(String location) {
        return this.prefix.isEmpty() ? location : this.prefix + "/" + location;
    }

    private @Nullable IoSupplier<InputStream> getResource(String relativePath) {
        JarResource resource = this.contents.get(this.addPrefix(relativePath));
        return resource == null ? null : () -> ((JarResource)resource).open();
    }

    public Set<String> getNamespaces(PackType packType) {
        HashSet namespaces = Sets.newHashSet();
        String prefix = this.addPrefix(packType.getDirectory() + "/");
        this.contents.visitContent(prefix, (relativePath, resource) -> {
            if (!relativePath.startsWith(prefix)) {
                throw new IllegalStateException("Path received from visitContent doesn't start with prefix '" + prefix + "': " + relativePath);
            }
            int i = prefix.length();
            int j = relativePath.indexOf(47, i);
            if (j == -1) {
                return;
            }
            String namespace = relativePath.substring(i, j);
            if (Identifier.isValidNamespace((String)namespace)) {
                namespaces.add(namespace);
            } else {
                LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)namespace, (Object)this.contents);
            }
        });
        return namespaces;
    }

    public void close() {
    }

    public void listResources(PackType packType, String namespace, String prefix, PackResources.ResourceOutput output) {
        String s = this.addPrefix(packType.getDirectory() + "/" + namespace + "/");
        String s1 = s + prefix + "/";
        this.contents.visitContent(s1, (relativePath, resource) -> {
            String s3 = relativePath.substring(s.length());
            Identifier resourcelocation = Identifier.tryBuild((String)namespace, (String)s3);
            if (resourcelocation != null) {
                output.accept((Object)resourcelocation, () -> ((JarResource)resource.retain()).open());
            } else {
                LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)s3);
            }
        });
    }

    public static class JarContentsResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final JarContents contents;
        private final String prefix;

        public JarContentsResourcesSupplier(JarContents contents) {
            this(contents, "");
        }

        public JarContentsResourcesSupplier(JarContents contents, String prefix) {
            this.contents = contents;
            while (prefix.endsWith("/")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            this.prefix = FileUtil.normalizeResourcePath((String)prefix);
        }

        public PackResources openPrimary(PackLocationInfo locationInfo) {
            return new JarContentsPackResources(locationInfo, this.contents, this.prefix);
        }

        public PackResources openFull(PackLocationInfo locationInfo, Pack.Metadata metadata) {
            JarContentsPackResources packresources = new JarContentsPackResources(locationInfo, this.contents, this.prefix);
            List overlays = metadata.overlays();
            if (overlays.isEmpty()) {
                return packresources;
            }
            ArrayList<JarContentsPackResources> effectiveOverlays = new ArrayList<JarContentsPackResources>(overlays.size());
            for (String s : overlays) {
                effectiveOverlays.add(new JarContentsPackResources(locationInfo, this.contents, s));
            }
            return new CompositePackResources((PackResources)packresources, effectiveOverlays);
        }
    }
}

